<?php

namespace App\Http\Controllers;

use Illuminate\Http\Request;
use Illuminate\Support\Facades\Validator;
use Auth;
use DB;
use App\Models\EmpPermit;

class EmpPermitController extends Controller
{
    public function index()
    {
        $emp_permits =  EmpPermit::where('del','0')->get();

        $data['emp_permits'] = $emp_permits;
 
         return response()->json([
             'message' => 'Work Permits Type Get Successfully',
             'data'   => $data
         ],200);
         
    }

    public function create()
    {
        //
    }

    public function store(Request $request)
    {
        $validator = Validator::make($request->all(), [
            'title' => 'required',
        ]);
        
        if ($validator->fails()) {

            $errors = $validator->errors();

            return response()->json([
                'message' => 'Validation Failed',
                'data' => $errors
            ],422);


        } else {
          
           $validatedData =  $validator->validated();
           
           $validatedData['created_by'] = Auth::user()->id;
           
           EmpPermit::insert($validatedData);

           $emp_permits =  EmpPermit::where('del','0')->get();

           $data['emp_permits'] = $emp_permits;
    
            return response()->json([
                'message' => 'Work Permits Type Saved Successfully',
                'data'   => $data
            ],200);
            
        }        

    }

    public function show($id)
    {
        //
    }

    public function edit($id)
    {
        //
    }

    public function update(Request $request, $id)
    {
        $validator = Validator::make($request->all(), [
            'title' => 'required'
        ]);
        
        if ($validator->fails()) {

            $errors = $validator->errors();

            return response()->json([
                'message' => 'Validation Failed',
                'data' => $errors
            ],422);


        } else {
          
            $validatedData =  $validator->validated();

            EmpPermit::where('id', $id)->update($validatedData);

            $emp_permits =  EmpPermit::where('del','0')->get();

            $data['emp_permits'] = $emp_permits;
     
             return response()->json([
                 'message' => 'Work Permits Type Updated Successfully',
                 'data'   =>   $data
             ],200);
            
        }        

    }

    public function destroy($id)
    {
        EmpPermit::where('id', $id)->update([
            'del' => '1'
        ]);

        $emp_permits =  EmpPermit::where('del','0')->get();

        $data['emp_permits'] = $emp_permits;
 
         return response()->json([
             'message' => 'Work Permits Type Deleted Successfully',
             'data'   => $data
         ],200);
    }
}
