<?php

namespace App\Http\Controllers;

use DB;
use Auth;
use Carbon\Carbon;
use App\Models\Fund;
use App\Models\Role;
use App\Models\Tier;
use App\Models\EmpTeam;
use App\Models\EmpType;
use App\Models\EmpAccess;
use App\Models\EmpPermit;
use App\Models\FundsMeta;
use App\General\MetaClass;
use App\Traits\EmailTrait;
use App\Models\EmpDocuments;
use App\Models\RosterAssign;
use Illuminate\Http\Request;
use App\Models\EmpWorkerType;
use App\Models\RosterHistory;
use App\Models\EmpTeamsMember;
use App\Models\RosterTemplate;
use Illuminate\Validation\Rule;
use App\Models\RequiredDocument;
use App\Models\EmpCompanyDetails;
use App\Models\EmpWorkExperience;
use App\Models\EmpPersonalDetails;
use App\Models\PorfileSubmittedLog;
use App\Traits\RosterTemplateTrait;
use App\Models\EmpEmergencyContacts;
use Illuminate\Support\Facades\Hash;
use App\Models\RequiredExternalDocument;
use Illuminate\Support\Facades\Validator;
use App\Http\Controllers\EmpTeamController;


class EmployeeOnboardingController extends Controller
{
    use RosterTemplateTrait, EmailTrait;
    public function sendCredentials(Request $request)
    {
        $id = $request->id;
        $user = EmpCompanyDetails::where('id', $id)->exists();
    
        if ($user) {
            $user_details = EmpCompanyDetails::where('id', $id)->first();
            $digits = 6;
            $password = rand(pow(10, $digits - 1), pow(10, $digits) - 1);
            
            // Update user password
            EmpCompanyDetails::where('id', $id)->update([
                'password' => Hash::make($password)
            ]);
    
            // Email data
            $data = [
                'email' => $user_details->employee_email,
                'password' => $password,
                'subject' => 'User Credentials | ' . env("APP_NAME")
            ];
    
            // Send email using the EmailTrait function
            $emailSent = $this->sendEmail(
                $user_details->employee_email, 
                'User Credentials | ' . env("APP_NAME"), 
                $data, 
                'Emails.invite'
            );
            return response()->json([
                'message' => $emailSent ? 'Email has been sent, Please check your Email.' : 'SMTP is not Working, Try Later!'
            ], $emailSent ? 200 : 400);
        }
    
        return response()->json([
            'message' => 'Account with the entered email does not exist.'
        ], 400);
    }
    

    public function sendInvite($id)
    {
        $user = EmpCompanyDetails::where('id', $id)->exists();
    
        if ($user) {
            $user_details = EmpCompanyDetails::where('id', $id)->first();
            $digits = 6;
            $password = rand(pow(10, $digits - 1), pow(10, $digits) - 1);
            
            // Update user password
            EmpCompanyDetails::where('id', $id)->update([
                'password' => Hash::make($password)
            ]);
            // Email data
            $data = [
                'email' => $user_details->employee_email,
                'password' => $password,
                'subject' => 'User Invitation | ' . env("APP_NAME")
            ];
    
            // Send email using the EmailTrait function
            $emailSent = $this->sendEmail(
                $user_details->employee_email, 
                'User Invitation | ' . env("APP_NAME"), 
                $data, 
                'Emails.invite'
            );
            return response()->json([
                'message' => $emailSent ? 'Email has been sent, Please check your Email.' : 'SMTP is not Working, Try Later!'
            ], $emailSent ? 200 : 400);
        }
    
        return response()->json([
            'message' => 'Account with the entered email does not exist.'
        ], 400);
    }
    

    public function sendRejectedProfile($id)
    {
        $user = EmpCompanyDetails::where('id', $id)->exists();
    
        if ($user) {
            $user_details = EmpCompanyDetails::where('id', $id)->first();
    
            // Email data
            $data = [
                'email' => $user_details->employee_email,
                'subject' => 'Your Profile Rejected | ' . env("APP_NAME")
            ];
    
            // Send email using the EmailTrait function
            $emailSent = $this->sendEmail(
                $user_details->employee_email, 
                'Your Profile Rejected | ' . env("APP_NAME"), 
                $data, 
                'Emails.profile_rejected'
            );
    
            return response()->json([
                'message' => $emailSent ? 'Email has been sent, Please check your Email.' : 'SMTP is not Working, Try Later!'
            ], $emailSent ? 200 : 400);
        }
    
        return response()->json([
            'message' => 'Account with the entered email does not exist.'
        ], 400);
    }
    

    public function sendOnCompeleteProfile($id)
    {
        $user = EmpCompanyDetails::where('id', $id)->exists();
    
        if ($user) {
            $user_details = EmpCompanyDetails::where('id', $id)->first();
    
            // Determine email template and data
            if ($user_details->invited == 1) {
                // If the user was invited, no password is included
                $data = [
                    'email' => $user_details->employee_email,
                    'subject' => 'Your Profile Completed And Approved | ' . env("APP_NAME")
                ];
                $template = 'Emails.profile_completed_without_password';
            } else {
                // If the user was not invited, generate a password
                $digits = 6;
                $password = rand(pow(10, $digits - 1), pow(10, $digits) - 1);
    
                // Update password in the database
                EmpCompanyDetails::where('id', $id)->update([
                    'password' => Hash::make($password)
                ]);
    
                $data = [
                    'email' => $user_details->employee_email,
                    'password' => $password,
                    'subject' => 'Your Profile Completed And Approved | ' . env("APP_NAME")
                ];
                $template = 'Emails.profile_compeleted_with_password';
            }
    
            // Send email only if credentials are enabled
            if ($user_details->credentials == 1) {
                $emailSent = $this->sendEmail(
                    $user_details->employee_email,
                    'Your Profile Completed And Approved | ' . env("APP_NAME"),
                    $data,
                    $template
                );
    
                return response()->json([
                    'message' => $emailSent ? 'Email has been sent, Please check your Email.' : 'SMTP is not Working, Try Later!'
                ], $emailSent ? 200 : 400);
            }
    
            return response()->json(['message' => ''], 204); // No content if credentials are disabled
        }
    
        return response()->json([
            'message' => 'Account with the entered email does not exist.'
        ], 400);
    }
    

    public function empCompanyDetailsStore(Request $request)
    {
        $validator = Validator::make($request->all(), [
            'emp_id' => 'required',
            'employee_email'  => ['required','email', Rule::unique('emp_company_details')->ignore($request->emp_id)],
            'employment_type'  => 'required',
            'access_role'  => 'required',
            'tier_id'  => 'required',
            'employee_teams'  => 'required',
            'work_permit_type'  => 'required',
            'tax_file_no'  => 'required|min:9',
            'employment_start_date'  => 'required|date',
            'employment_end_date'  => 'nullable|date|after_or_equal:employment_start_date',
            'attendance_effective_from'  => 'required|date', //after_or_equal:today
            'invited' => 'required|boolean',
            'credentials' => 'required',
            'status' => 'required',
            'employee_payroll_or_external_id' => 'required',
        ],[
            'emp_id.required' => 'Employee ID is required.',
            'employee_email.required' => 'Employee email is required.',
            'employee_email.email'  => 'Employee email must be a valid email address',
            'employee_email.unique'  => 'This email is already associated with another employee.',
            'employment_type.required'  => 'Employment type is required.',
            'access_role.required'  => 'Access role is required.',
            'tier_id.required' => 'Tier Package is required.',
            'employee_teams.required'  => 'Employee teams are required.',
            'work_permit_type.required'  => 'Work permit type is required.',
            'tax_file_no.required'  => 'Tax file number is required.',
            'employment_start_date.required'  => 'Employment start date is required.',
            'employment_start_date.date' => 'Invalid date format for employment start date.',
            'employment_end_date.date' => 'Invalid date format for employment end date.',
            'employment_end_date.after_or_equal' => 'Employment end date must be after or equal to the start date.',
            'attendance_effective_from.required'  => 'Attendance effective from date is required.',
            'attendance_effective_from.date' => 'Invalid date format for attendance effective from date.',
            //'attendance_effective_from.after_or_equal' => 'Attendance effective from date must be greater than or equal to today.',
            'invited.required' => 'Invited field is required.',
            'invited.boolean' => 'Invited field must be a boolean.',
            'credentials.required' => 'Credentials are required.',
            'status.required' => 'Status is required.',
            'employee_payroll_or_external_id.required' => 'Employee Payroll / External ID is required.',
        ]);
        

        
        
        if ($validator->fails()) {

            $error = $validator->errors()->first();

            return response()->json([
                'message' => $error
                
            ],422);


        } else {


            $validatedData =  $validator->validated();
            unset($validatedData['employee_payroll_or_external_id']);
         

            $emp_id = $validatedData['emp_id'];
            $emp_exit =  EmpCompanyDetails::where('id',$emp_id)->count();
            unset($validatedData['emp_id']);


            $employee_teams = $validatedData['employee_teams'];
            unset($validatedData['employee_teams']);
            
            


            if($emp_exit == 0)
            {
                $validatedData['created_by']   =  Auth::user()->id;
                
                $insertGetId =  EmpCompanyDetails::insertGetId($validatedData);
                $msg = 'Employee Company Details Saved Successfully';
                $emp_id = $insertGetId;
                if($validatedData['credentials'] == 1)
                {
                    
                    $this->sendInvite($emp_id);
                }
            }
            else
            {
                unset($validatedData['employee_email']);
                unset($validatedData['status']);
                unset($validatedData['credentials']);
                unset($validatedData['invited']);
                $validatedData['user_type'] = '0';
                EmpCompanyDetails::where('id',$emp_id)->update($validatedData);
                $msg = 'Employee Company Details Updated Successfully';
            }


            $meta_ = $request->only([
                'employee_payroll_or_external_id',
                ]);
    

            $MetaArray = [];

            foreach ($meta_ as $option => $value) {
                if ($value !== null) {
                    $MetaArray[] = [
                    'emp_id' => $emp_id,
                    'option' => $option,
                    'value' => $value,
                    ];
                    DB::table('user_meta')->where('emp_id',$emp_id)->where('option',$option)->delete();
                }
            }

            
            DB::table('user_meta')->insert($MetaArray);

           
  
            EmpTeamsMember::where([
                'emp_id' => $request->emp_id,
            ])->delete();

                $EmpTeamController = new EmpTeamController();
                
                $employee_teams = explode(",",$employee_teams);

                foreach($employee_teams as $employee_team)
                {
                   $request->team_id = $employee_team;
                   $request->emp_id = $emp_id;
                   $request->applied = '0';
                   $EmpTeamController->addRemoveTeamMember($request);
                }

            $data['emp_id'] =  $emp_id;

          
            return response()->json([
                'message' => $msg,
                'data' => $data
            ],200);
            
        }        

    }

    public function empCompanyDetailsEdit(Request $request)
    {
        $validator = Validator::make($request->all(), [
            'emp_id' => 'required'
        ],[
            'emp_id.required' => 'Employee ID is required.'
        ]);
        
        if ($validator->fails()) {

            $error = $validator->errors()->first();

            return response()->json([
                'message' => $error

            ],422);


        } else {
          
            $validatedData =  $validator->validated();
// 
           
            $emp_company_details =  EmpCompanyDetails::where('id', $validatedData['emp_id'] )->first();
            if($emp_company_details) unset($emp_company_details['password']);

            $data['emp_company_details'] = $emp_company_details;

            $emp_permits =  EmpPermit::where('del','0')->select('id','title')->get();

            $data['emp_permits'] = $emp_permits;

            $emp_types =  EmpType::where('del','0')->select('id','title')->get();

            $data['emp_types'] = $emp_types;

            
            $pkg_tiers =  Tier::select('id','title')->get();

            $data['pkg_tiers'] = $pkg_tiers;

            $roles = Role::where('del','0')->get();

            $data['emp_roles'] = $roles;

            $emp_teams = EmpTeam::where('del','0')->get();

            $data['emp_teams'] = $emp_teams;

            $emp_team_members = EmpTeamsMember::where('emp_id',$validatedData['emp_id'])->get();
            $str = "";

            foreach($emp_team_members as $emp_team_member)
            {
                $str .=  $emp_team_member->team_id.',';
            }


            
            $data['employee_teams'] =  rtrim($str, ",");
           

            $user_meta =  DB::table('user_meta')->where('emp_id',$validatedData['emp_id'])->get();
            
            $employee_payroll_or_external_id = MetaClass::getOptionValue('employee_payroll_or_external_id', $user_meta);

            $data['meta']['employee_payroll_or_external_id'] = $employee_payroll_or_external_id;

     
             return response()->json([
                 'message' => 'Employee Company Details GET Successfully',
                 'data'   =>   $data
             ],200);
            
        }   
    }

    public function empPersonalDetailsStore(Request $request)
    {
        // dd($request->all());
       
        $validator = Validator::make($request->all(), [
            'emp_id' => 'required',
            'first_name' => 'required',
            'middle_name' => 'nullable',
            'last_name' => 'required',
            'mobile' => 'required|numeric',
            'streat_address' => 'required',
            'suburb' => 'required|regex:/^[a-zA-Z\s]*$/',
            'state' => 'required|regex:/^[a-zA-Z\s]*$/',
            'postcode' => 'required',
            'date_of_birth' => 'required|date|before_or_equal:' . Carbon::now()->subYears(14)->format('Y-m-d'),
            'blood_group' => 'nullable',
            'superannuations_funds' => 'nullable',
           
          
        ], [
            'emp_id.required' => 'Employee ID is required.',
            'first_name.required' => 'First name is required.',
            'first_name.alpha' => 'First name must contain only alphabetic characters.',
            'last_name.required' => 'Last name is required.',
            'last_name.alpha' => 'Last name must contain only alphabetic characters.',
            'middle_name.alpha' => 'Middle name must contain only alphabetic characters.',
            'mobile.required' => 'Mobile number is required.',
            'mobile.numeric' => 'Mobile must be numeric.',
            'streat_address.required' => 'Street address is required.',
            'suburb.required' => 'Suburb is required.',
            'suburb.regex' => 'Suburb must contain only alphabetic characters.',
            'state.required' => 'State is required.',
            'state.regex' => 'State must contain only alphabetic characters.',
            'postcode.required' => 'Postcode is required.',
            'postcode.numeric' => 'Postcode is must be numeric.',
            'date_of_birth.required' => 'Date of birth is required.',
            'date_of_birth.date' => 'Invalid date format for date of birth.',
            'date_of_birth.before' => 'You must be at least 14 years old to register.',
           
           
        ]);
        if ($request->hasFile('image')) {
            $rules['image'] = 'image|mimes:jpeg,png,jpg,gif|max:2048'; // example rules for images
        }

        
        
        if ($validator->fails()) {

            $error = $validator->errors()->first();

            return response()->json([
                'message' => $error
                
            ],422);


        } else {

            $validatedData =  $validator->validated();

         

            $emp_id = $validatedData['emp_id'];

                //  'image' => 'nullable|mimes:jpeg,png,jpg,gif,svg'
            
            
            $emp_exit =  EmpPersonalDetails::where('emp_id',$emp_id)->count();
            $superannuations_funds =  json_decode($validatedData['superannuations_funds']);
            unset($validatedData['superannuations_funds']);

            if ($request->hasFile('image')) 
            {

                $image = $request->file('image');
                $imageName = time() . '.' . $image->getClientOriginalExtension();
                $image->move(public_path('upload/images'), $imageName);
                $validatedData['image'] = 'upload/images/' . $imageName;

            }


            if($emp_exit == 0)
            {
                $validatedData['created_by']   =  Auth::user()->id;
                EmpPersonalDetails::insertGetId($validatedData);
                $msg = 'Employee Personal Details Saved Successfully';
                
            }
            else
            {
                unset($validatedData['emp_id']);
                EmpPersonalDetails::where('emp_id',$emp_id)->update($validatedData);
                $msg = 'Employee Personal Details Updated Successfully';
            }

            $fund_array = [];
            $i =0;
            foreach($superannuations_funds as $fund)
            {
                $fund_array[$i]['emp_id'] = $emp_id; 
                $fund_array[$i]['fund_id'] = $fund->id; 
                $fund_array[$i]['usi_number'] = $fund->usi_number;
                $fund_array[$i]['member_number'] = $fund->member_number;
                $i++;
            }

            FundsMeta::where('emp_id',$emp_id)->delete();
            FundsMeta::insert($fund_array);

            $meta_ = $request->only([
                'account_title',
                'account_number',
                'bank_name'
                ]);
    

            $MetaArray = [];

            foreach ($meta_ as $option => $value) {
                if ($value !== null) {
                    $MetaArray[] = [
                    'emp_id' => $emp_id,
                    'option' => $option,
                    'value' => $value,
                    ];
                    DB::table('user_meta')->where('emp_id',$emp_id)->where('option',$option)->delete();
                }
            }

            
            DB::table('user_meta')->insert($MetaArray);



            $data['emp_id'] =  $emp_id;
          
            return response()->json([
                'message' => $msg,
                'data' => $data
            ],200);
            
        }        

    }

    public function empPersonalDetailsEdit(Request $request)
    {
       
        $validator = Validator::make($request->all(), [
            'emp_id' => 'required'
        ],[
            'emp_id.required' => 'Employee ID is required.'
        ]);
        
        if ($validator->fails()) {

            $error = $validator->errors()->first();

            return response()->json([
                'message' => $error
                
            ],422);


        } else {
          
            $validatedData =  $validator->validated();

           
            $emp_personal_details =  EmpPersonalDetails::where('emp_id', $validatedData['emp_id'] )->first();

            $funds = Fund::where('del','0')->get();
            $funds_meta = FundsMeta::where('emp_id',$validatedData['emp_id'])->with('fund')->get();

            $c = 0;
            
            foreach($funds as $f)
            {
                foreach($funds_meta as $fm)
                {
                    if($fm->fund_id == $f->id)
                    {
                        $funds[$c]['usi_number'] = $fm->usi_number;
                        $funds[$c]['member_number'] = $fm->member_number;

                    }
                }
                
                $c++;
            }

           
            if($emp_personal_details)
            {
                $emp_personal_details->image = url($emp_personal_details->image);
            }
            $data['emp_personal_details'] = $emp_personal_details;
            $data['funds'] = $funds;    
            $data['funds_meta'] = $funds_meta;

            $user_meta =  DB::table('user_meta')->where('emp_id',$validatedData['emp_id'])->get();
            
            $account_title = MetaClass::getOptionValue('account_title', $user_meta);
            $account_number = MetaClass::getOptionValue('account_number', $user_meta);
            $bank_name = MetaClass::getOptionValue('bank_name', $user_meta);

            $data['meta']['account_title'] = $account_title;
            $data['meta']['account_number'] = $account_number;
            $data['meta']['bank_name'] = $bank_name;   
     
             return response()->json([
                 'message' => 'Employee Personal Details GET Successfully',
                 'data'   =>   $data
             ],200);
            
        }   
    }


    public function empDocumentsStore(Request $request)
    {
       
        $required_documents = RequiredDocument::with('requiredDocumentField')->where('del','0')->where('for_who', '!=', '1')->get();
        $count = EmpDocuments::where('emp_id', $request->emp_id)->count();

        if($count == 0)
        {
          $msg = "Employee Documents Saved Successfully";
        }
        else
        {
          $msg = "Employee Documents Updated Successfully";
        }
			
         

        $i = 0;

        foreach($required_documents as $required_document)
        {
            foreach($required_document->requiredDocumentField as $required_document_field)
            {
                if($required_document_field->field_required == "1" && !$request->filled('document_array.' . $required_document_field->doc_id . '.' . $required_document_field->id) && !$request->hasFile('document_array.'.$required_document_field->doc_id.'.'.$required_document_field->id))
                {
                    if($count == 0)
                    {
                      return response()->json(['message' => $required_document_field->field_name.' field is required'],422);
                    }
                    else
                    {
                        if($required_document_field->field_type != 'file')
                        {
                            return response()->json(['message' => $required_document_field->field_name.' field is required'],422);
                        }
                    }
                    
                }
                if ($required_document_field->field_type == "file" && $request->hasFile('document_array.' . $required_document_field->doc_id . '.' . $required_document_field->id)) {
                    $allowedExtensions = ['jpg', 'jpeg', 'png', 'docx', 'pdf'];
                    $document_file = $request->file('document_array.' . $required_document_field->doc_id . '.' . $required_document_field->id);
                    $extension = $document_file->getClientOriginalExtension();
                    $mimeType = $document_file->getMimeType();
                   
                    // Validate extension and MIME type
                    if (!in_array($extension, $allowedExtensions) || !in_array($mimeType, ['image/jpeg', 'image/png', 'application/pdf', 'application/vnd.openxmlformats-officedocument.wordprocessingml.document'])) {
                        return response()->json(['message' => 'The ' . $required_document_field->field_name . ' file must be a file of type: jpg, jpeg, png, docx, pdf.'], 422);
                    }
                }
            }
            $i++;
        }

        foreach($required_documents as $required_document)
        {
            foreach($required_document->requiredDocumentField as $required_document_field)
            {

                $EmpDocumentsData = [
                    'emp_id' => $request->emp_id,
                    'required_document' => $required_document_field->doc_id,
                    'required_document_field' =>  $required_document_field->id,
                ];
                if($required_document_field->field_type == "file" && $request->hasFile('document_array.'.$required_document_field->doc_id.'.'.$required_document_field->id))
                {
                    $document_file = $request->file('document_array.'.$required_document_field->doc_id.'.'.$required_document_field->id);
                    $documentName = $i.time() . '.' . $document_file->getClientOriginalExtension();
                    $document_file->move(public_path('upload/documents'), $documentName);
                    $EmpDocumentsData['value'] = 'upload/documents/' . $documentName;
                    EmpDocuments::where(['emp_id' => $request->emp_id, 'required_document' => $required_document_field->doc_id, 'required_document_field' => $required_document_field->id])->delete();
                    EmpDocuments::insert($EmpDocumentsData);
                }

                if($required_document_field->field_type != "file")
                {
                    if(isset($request->document_array[$required_document_field->doc_id][$required_document_field->id]))
                    {
                        $EmpDocumentsData['value'] =  $request->document_array[$required_document_field->doc_id][$required_document_field->id];
                        EmpDocuments::where(['emp_id' => $request->emp_id, 'required_document' => $required_document_field->doc_id, 'required_document_field' => $required_document_field->id])->delete();
                        EmpDocuments::insert($EmpDocumentsData);
                    }

                }
            }

            $i++;
        }


        return response()->json([
            'message' => $msg,
            'data' => ['emp_id' => $request->emp_id]
        ],200);


    }
    

    public function empDocumentsEdit(Request $request)
    {
        $validator = Validator::make($request->all(), [
            'emp_id' => 'required'
        ],[
            'emp_id.required' => 'Employee ID is required.'
        ]);
        
        if ($validator->fails()) {

            $error = $validator->errors()->first();

            return response()->json([
                'message' => $error
                
            ],422);


        } else {
          
            $validatedData =  $validator->validated();

            $emp_documents =  EmpDocuments::where('emp_id', $validatedData['emp_id'] )->where('del', '0')->get();  
            $required_documents = RequiredDocument::with('requiredDocumentField')->where('del','0')->get();

            $data['required_documents'] = $required_documents;
            $data['emp_documents'] = $emp_documents;
            $data['base_url'] = url('/');
     
             return response()->json([
                 'message' => 'Employee Documents GET Successfully',
                 'data'   =>   $data
             ],200);
            
        }   
    }

    public function empDocumentsDelete(Request $request)
    {
        
        $validator = Validator::make($request->all(), [
            'id' => 'required',
        ],[
            'id.required' => 'ID is required.'
        ]);

        
        
        if ($validator->fails()) {

            $error = $validator->errors()->first();

            return response()->json([
                'message' => $error
                
            ],422);


        } else {

            $validatedData =  $validator->validated();
            
            EmpDocuments::where('id',$validatedData['id'])->update(['del' => '1']);

            return response()->json([
                'message' => 'Employee Document or Certification Deleted Successfully'
            ],200);
            
        }        

    }

    public function empDocumentsCount(Request $request)
    {
        
        $validator = Validator::make($request->all(), [
            'emp_id' => 'required',
        ],[
            'emp_id.required' => 'Employee ID is required.'
        ]);

        
        
        if ($validator->fails()) {

            $error = $validator->errors()->first();

            return response()->json([
                'message' => $error
                
            ],422);


        } else {

            $validatedData =  $validator->validated();
            
            $count =  EmpDocuments::where(['emp_id'=> $validatedData['emp_id'], 'del' => '0'])->count();

            if($count)
            {
                $data['emp_id'] = $validatedData['emp_id'];

                return response()->json([
                    'message' => '',
                    'data' => $data
                ],200);
            }
            else
            {
                return response()->json([
                    'message' => 'Please Upload At Least One Document or Certification First'
                ],400);
            }


            
        }        

    }

    public function empEmergencyContactsStore(Request $request)
    {       
        $validator = Validator::make($request->all(), [
            'id' => 'required',
            'emp_id' => 'required',
            'name' => 'required|regex:/^[a-zA-Z\s]*$/',
            'relation' => 'required',
            'phone' => 'required',
            'email' => 'nullable|email',
            'address' => 'nullable'            
        ], [
            'id.required' => 'ID is required.',
            'emp_id.required' => 'Employee ID is required.',
            'name.required' => 'Name is required.',
            'name.regex' => 'Name must contain only alphabetic characters.',
            'email.email' => 'Invalid email format.',
            'phone.required' => 'Phone number is required.',
            'relation.required' => 'Relation is required.'
        ]);
        

        
        
        if ($validator->fails()) {

            $error = $validator->errors()->first();

            return response()->json([
                'message' => $error
                
            ],422);


        } else {

            $validatedData =  $validator->validated();
            $id = $validatedData['id'];
            $emp_exit =  EmpEmergencyContacts::where('id',$id)->count();

            unset($validatedData['id']);


            if($emp_exit == 0)
            {
                $validatedData['created_by']   =  Auth::user()->id;
                EmpEmergencyContacts::insertGetId($validatedData);
                $msg = 'Employee Emergency Contacts Saved Successfully';
                
            }
            else
            {
                
                EmpEmergencyContacts::where('id',$id)->update($validatedData);
                $msg = 'Employee Emergency Contacts Updated Successfully';
            }



            $data['emp_id'] =  $validatedData['emp_id'];
          
            return response()->json([
                'message' => $msg,
                'data' => $data
            ],200);
            
        }        

    }

    public function empEmergencyContactsEdit(Request $request)
    {
        $validator = Validator::make($request->all(), [
            'emp_id' => 'required'
        ],[
            'emp_id.required' => 'Employee ID is required.'
        ]);
        
        if ($validator->fails()) {

            $error = $validator->errors()->first();

            return response()->json([
                'message' => $error
                
            ],422);


        } else {
          
            $validatedData =  $validator->validated();

           
            $emp_emergency_contacts =  EmpEmergencyContacts::where('emp_id', $validatedData['emp_id'] )->where('del', '0' )->get();
            
            $data['emp_emergency_contacts'] = $emp_emergency_contacts;            
     
             return response()->json([
                 'message' => 'Employee Emergency Contact GET Successfully',
                 'data'   =>   $data
             ],200);
            
        }   
    }

    public function empEmergencyContactsDelete(Request $request)
    {
        
        $validator = Validator::make($request->all(), [
            'id' => 'required',
        ],[
            'id.required' => 'ID is required.'
        ]);

        
        
        if ($validator->fails()) {

            $error = $validator->errors()->first();

            return response()->json([
                'message' => $error
                
            ],422);


        } else {

            $validatedData =  $validator->validated();
            
            EmpEmergencyContacts::where('id',$validatedData['id'])->update(['del' => '1']);

            return response()->json([
                'message' => 'Employee Emergency Contact Deleted Successfully'
            ],200);
            
        }        

    }

    public function empEmergencyContactsCount(Request $request)
    {
        
        $validator = Validator::make($request->all(), [
            'emp_id' => 'required',
        ],[
            'emp_id.required' => 'Employee ID is required.'
        ]);

        
        
        if ($validator->fails()) {

            $error = $validator->errors()->first();

            return response()->json([
                'message' => $error
                
            ],422);


        } else {

            $validatedData =  $validator->validated();
            
            $count =  EmpEmergencyContacts::where(['emp_id'=> $validatedData['emp_id'], 'del' => '0'])->count();

            
            if($count)
            {
                $data['emp_id'] = $validatedData['emp_id'];

                $emp  = EmpCompanyDetails::where('id', $validatedData['emp_id'])->first();

                if($emp->invited == 1)
                {
                    EmpCompanyDetails::where('id', $validatedData['emp_id'])->update([
                        'rejected' => '0',
                        'is_submitted' => '1'
                    ]);

                   
                }

                return response()->json([
                    'message' => '',
                    'data' => $data
                ],200);
            }
            else
            {
                return response()->json([
                    'message' => 'Please Upload At Least One Emergency Contacts First'
                ],400);
            }


            
        }        

    }


    public function empAccessStore(Request $request)
    {
            $validator = Validator::make($request->all(), [
            'emp_id' => 'required',
            'web_app' => 'required',
            'mobile_app' => 'required',
            'attendance' => 'required',
            'timesheet_reminders' => 'required',
            'email' => 'required',
            'timesheet' => 'required'
            ], [
            'emp_id.required' => 'Employee ID is required.',
            'web_app.required' => 'Web app preference is required.',
            'mobile_app.required' => 'Mobile app preference is required.',
            'attendance.required' => 'Attendance preference is required.',
            'timesheet_reminders.required' => 'Timesheet reminders preference is required.',
            'email.required' => 'Email preference is required.',
            'timesheet.required' => 'Timesheet preference is required.'
            ]);


        if ($validator->fails()) {

            $error = $validator->errors()->first();

            return response()->json([
            'message' => $error

            ],422);


        } else {

            $validatedData = $validator->validated();

            $check = EmpAccess::where('emp_id',$validatedData['emp_id'])->count();

            EmpAccess::where('emp_id',$validatedData['emp_id'])->delete();
            EmpAccess::insertGetId($validatedData);




            if($check == 0)
            {


            $EmpCompanyDetails = EmpCompanyDetails::where('id', $validatedData['emp_id'])->first();

            $this->sendOnCompeleteProfile($validatedData['emp_id']);

            if($EmpCompanyDetails->invited == 1)
            {
            PorfileSubmittedLog::insert([
            "emp_id" => $validatedData['emp_id'],
            "approved_by" => Auth::user()->id,
            "date" => date('Y-m-d')
            ]);

            EmpCompanyDetails::where('id', $validatedData['emp_id'])->update([
            'approved' => '1',
            'compeleted'=>'1',
            'approved_by' => Auth::user()->id,
            'approved_at' => date('Y-m-d'),
            'is_submitted' => '0',
            'invited' => '0'
            ]);

            }



            // aprove code end



            EmpCompanyDetails::where('id',$validatedData['emp_id'])->update([
            'compeleted' => '1',
            'approved' => '1',
            'approved_by' => Auth::user()->id,
            'approved_at' => date('d-m-Y'),
            ]);


            $employee_teams = EmpTeamsMember::where([
            'emp_id' => $validatedData['emp_id'],
            ])->get();

            EmpTeamsMember::where([
            'emp_id' => $validatedData['emp_id'],
            ])->delete();

            $EmpTeamController = new EmpTeamController();



            foreach($employee_teams as $employee_team)
            {
            $request->team_id = $employee_team->team_id;
            $request->emp_id =$employee_team->emp_id;
            $request->applied = '1';
            $EmpTeamController->addRemoveTeamMember($request);
            }



            $msg = 'Employee Access Saved Successfully';
            }
            else
            {
            $msg = 'Employee Access Updated Successfully';
            }

            EmpCompanyDetails::where('id',$validatedData['emp_id'])->update([
            'compeleted' => '1',
            'approved' => '1',

            ]);
            $data['emp_id'] = $validatedData['emp_id'];

            // if(str_contains($msg, 'Saved')){
            // dd("hi");

            // }
            $this->assignShift($data['emp_id']);

            return response()->json([
            'message' => $msg,
            'data' => $data
            ],200);

        }

    } 

    public function empAccessEdit(Request $request)
    {
        $validator = Validator::make($request->all(), [
            'emp_id' => 'required'
        ],[
            'emp_id.required' => 'Employee ID is required.'
        ]);
        
        if ($validator->fails()) {

            $error = $validator->errors()->first();

            return response()->json([
                'message' => $error
                
            ],422);


        } else {
          
            $validatedData =  $validator->validated();

           
            $emp_access =  EmpAccess::where('emp_id', $validatedData['emp_id'] )->where('del', '0' )->first();
            
            $data['emp_access'] = $emp_access;
     
             return response()->json([
                 'message' => 'Employee Access Get Successfully',
                 'data'   =>   $data
             ],200);
            
        }   
    }

    public function rejected(Request $request)
    {
        $validator = Validator::make($request->all(), [
            'reason' => 'required',
            'emp_id' => 'required'
        ],[
            'emp_id.required' => 'Employee ID is required.',
            'reason.required' => 'Reason is required.'
        ]);
        
        if ($validator->fails()) {

            $error = $validator->errors()->first();

            return response()->json([
                'message' => $error
                
            ],422);


        } else {
          
            $validatedData =  $validator->validated();

           
            PorfileSubmittedLog::insert([
                "emp_id" => $validatedData['emp_id'],
                "reason" => $validatedData['reason'],
                "rejected_by" => Auth::user()->id,
                "date" => date('Y-m-d'),
            ]);
            
            EmpCompanyDetails::where('id', $validatedData['emp_id'])->update([
                'rejected' => '1',
                'is_submitted' => '0'
            ]);

            $this->sendRejectedProfile($validatedData['emp_id']);
     
             return response()->json([
                 'message' => 'Profile Rejected Successfully'
             ],200);
            
        }   
    }

    public function profileSubmitHistory(Request $request)
    {
        $validator = Validator::make($request->all(), [
            'emp_id' => 'required'
        ],[
            'emp_id.required' => 'Employee ID is required.'
        ]);
        
        if ($validator->fails()) {

            $error = $validator->errors()->first();

            return response()->json([
                'message' => $error
                
            ],422);


        } else {
          
            $validatedData =  $validator->validated();

           
           $PorfileSubmittedLog =  PorfileSubmittedLog::where('emp_id', $validatedData['emp_id'])
                                                        ->with('rejectedBy')
                                                        ->with('approvedBy')
                                                        ->get();

            $data['profile_submit_history'] = $PorfileSubmittedLog;
     
             return response()->json([
                 'message' => 'Profile Submit History Get Successfully',
                 'data' => $data
             ],200);
            
        }   
    }
 
    public function assignShift($id)
    {
        $roster_setting = DB::table('settings')->whereIn('option', [
            'roster_setting_title',
            'roster_setting_paid_break',
            'roster_setting_color_code',
            'roster_setting_start_time',
            'roster_setting_end_time',
            'roster_setting_description',
            'roster_setting_working_days',
            'roster_setting_number_of_days',
            'roster_setting_working_hours',
        ])->select('option', 'value')->get();
        // Convert the collection to an associative array
        $formatted_roster_setting = $roster_setting->pluck('value', 'option')->toArray();
      
        $days = [];
        $working_days = explode(',', $formatted_roster_setting['roster_setting_working_days']);
        
        foreach($working_days as $day){
            $days[] = config('constants.weekdays_name.'.$day);
        }
        $arr = [
            'start_date' => Carbon::today()->format('Y-m-d'),
            'end_date' =>  Carbon::today()->addDays($formatted_roster_setting['roster_setting_number_of_days'])->format('Y-m-d'),
            'start_time' => $formatted_roster_setting['roster_setting_start_time'],
            'end_time' => $formatted_roster_setting['roster_setting_end_time'],
            'color_code' => $formatted_roster_setting['roster_setting_color_code'],
            'break_minutes' => $formatted_roster_setting['roster_setting_paid_break'],
            'shift_notes' => $formatted_roster_setting['roster_setting_description'],
            'working_hours' => $formatted_roster_setting['roster_setting_working_hours'],
            'users_ids' => [$id],
            'working_days_hidden' => implode(',',$days)
        ];
        // $this->bulkScheduleSave($arr,$arr);
          $this->bulkScheduleRoasterCreate($arr,$arr);
        // dd($arr);
        // 
        return 0;
 
    }

    public function approvedInvite(Request $request, $id)
    {
        try {
            // Find the employee details by ID
            $employeeDetail = EmpCompanyDetails::findOrFail($id);
            // Update the invited field to 1 or whatever value you want
            $employeeDetail->invited = 0;
            $employeeDetail->save();
            
            return response()->json('Invitation approved successfully');
        } catch (\Exception $e) {
            return response()->json(['message' => $e->getMessage()], 500);
        }
    }

    // public function bulkScheduleSave($validatedData,$request)
    // {
    //         $days_array =  explode(",", $validatedData['working_days_hidden']);
    //         $start_ = Carbon::parse($request['start_time']);
    //         $end_ = Carbon::parse($request['end_time']);
    //         $required_minutes =  $end_->diffInMinutes($start_); 
    //         $required_minutes = $required_minutes - $request['break_minutes'] ?? 0;

    //         $getDatesBetweens = $this->getDatesBetween($request['start_date'], $request['end_date']);

    //         $insert_id = 0;

    //         $days_array = $this->getShortDayNames($days_array);

    //         foreach($getDatesBetweens as $for_this_date)
    //         {

    //             if(!in_array(Carbon::parse($for_this_date)->format('D'), $days_array))
    //             {
    //                 continue;
    //             }

    //             foreach($request['users_ids'] as  $user_id)
    //             {         


    //             $insert_id =   RosterTemplate::insertGetId([
    //                 'start_time' => $request['start_time'],
    //                 'end_time' =>$request['end_time'],
    //                 'break_minutes' => $request['break_minutes'],
    //                 'color_code' => $request['color_code'],
    //                 'shift_notes' => $request['shift_notes'],
    //                 'repeat_shift' => 0,
    //                 'repeat_every' => 0,
    //                 'end_date' => $for_this_date,
    //                 'working_hours' => $required_minutes,
    //                 'is_saved' => '0',
    //                 'created_by' =>  '1'
    //             ]);
                
                
                
    //             RosterAssign::insertGetId([
    //                 'assign_to' => $user_id,
    //                 'roster_template_id' =>  $insert_id,
    //                 'schedule_date' => $for_this_date,
    //             ]);

    //             }


    //         }
        
    //         ////// history //////

    //         $authPersonalDetails = EmpPersonalDetails::where('emp_id', 1)->first();
        
    //         $history_arr = [
    //             'description' => "<a href='".url('/')."/user-profile/1"."' style='text-transform: capitalize;' role='button' class='primary text-decoration-none'> {$authPersonalDetails->first_name} {$authPersonalDetails->middle_name} {$authPersonalDetails->last_name}</a> created a bulk schedule at ".date('d-m-Y')." date",
    //             'roster_template_id' => 0
    //         ];

    //         $this->storeHistory($history_arr);

    //         ////// history end //////

    //         return response()->json([
    //             'message' => 'Bulk Schedule Created Successfully'
    //         ],200);

    // }

    // function getDatesBetween($start_date, $end_date)
    // {
    //     $dates = [];

    //     $start = Carbon::parse($start_date);
    //     $end = Carbon::parse($end_date);

    //     while ($start->lte($end)) {
    //         $dates[] = $start->toDateString();
    //         $start->addDay();
    //     }

    //     return $dates;
    // }
 
    // function getShortDayNames($days) {
    //     $shortDays = array();
    
    //     foreach ($days as $day) {
    //         switch($day) {
    //             case "Monday":
    //                 $shortDays[] = "Mon";
    //                 break;
    //             case "Tuesday":
    //                 $shortDays[] = "Tue";
    //                 break;
    //             case "Wednesday":
    //                 $shortDays[] = "Wed";
    //                 break;
    //             case "Thursday":
    //                 $shortDays[] = "Thu";
    //                 break;
    //             case "Friday":
    //                 $shortDays[] = "Fri";
    //                 break;
    //             case "Saturday":
    //                 $shortDays[] = "Sat";
    //                 break;
    //             case "Sunday":
    //                 $shortDays[] = "Sun";
    //                 break;
    //             default:
    //                 $shortDays[] = "Invalid day";
    //                 break;
    //         }
    //     }
    
    //     return $shortDays;
    // }

    public function storeHistory($arr)
    {
        RosterHistory::create([
            'roster_template_id' => $arr['roster_template_id'],
            'updated_by' => '1',
            'description' => $arr['description']
        ]);

    }
    
}
