<?php

namespace App\Http\Controllers;

use Illuminate\Http\Request;
use Illuminate\Support\Facades\Validator;
use Illuminate\Validation\Rule;
use Illuminate\Support\Facades\Hash;
use App\General\MetaClass;
use Auth;
use DB;
use App\Models\EmpCompanyDetails;
use App\Models\EmpPermit;
use App\Models\EmpTeam;
use App\Models\EmpTeamsMember;
use App\Models\EmpPersonalDetails;
use App\Models\EmpType;
use App\Models\Role;
use App\Models\Tier;
use App\Models\EmpDocuments;
use App\Models\EmpEmergencyContacts;
use App\Models\EmpAccess;
use App\Models\PorfileSubmittedLog;
use App\Models\RequiredDocument;
use App\Models\RosterHistory;
use App\Models\RosterTemplate;
use App\Models\RosterAssign;
use App\Http\Controllers\EmpTeamController;
use Carbon\Carbon;
use App\Models\Fund;
use App\Models\FundsMeta;
use App\Models\RequiredExternalDocument;
use App\Models\EmpWorkExperience;
use App\Models\EmpWorkerType;
use Intervention\Image\Facades\Image;
use App\Traits\RosterTemplateTrait;


class ExternalEmployeeOnboardingController extends Controller
{
    use RosterTemplateTrait;
    public function externalEmployeeOnboardingEdit(Request $request)
    {
        $validator = Validator::make($request->all(), [
            'emp_id' => 'required'
        ],[
            'emp_id.required' => 'Employee ID is required.'
        ]);
        
        if ($validator->fails()) {

            $error = $validator->errors()->first();

            return response()->json([
                'message' => $error

            ],422);


        } else {
          
            $validatedData =  $validator->validated();

           
            $emp_company_details =  EmpCompanyDetails::with(['empPersonalDetails','empEmergencyContacts','empAccess','workExperience','workerType','empTeamsMembers'])->where('id', $validatedData['emp_id'] )->first();

            if($emp_company_details) unset($emp_company_details['password']);

            $data['emp_company_details'] = $emp_company_details;

            $emp_permits =  EmpPermit::where('del','0')->select('id','title')->get();

            $data['emp_permits'] = $emp_permits;

            $emp_types =  EmpType::where('del','0')->select('id','title')->get();

            $data['emp_types'] = $emp_types;

            $pkg_tiers =  Tier::select('id','title')->get();

            $data['pkg_tiers'] = $pkg_tiers;

            $roles = Role::where('del','0')->get();

            $data['emp_roles'] = $roles;

            $emp_work_experiences =  EmpWorkExperience::where('del','0')->select('id','title')->get();

            $data['emp_work_experiences'] = $emp_work_experiences;

            $emp_worker_types =  EmpWorkerType::where('del','0')->get();

            $data['emp_worker_types'] = $emp_worker_types;


            $funds = Fund::where('del','0')->get();
            $funds_meta = FundsMeta::where('emp_id',$validatedData['emp_id'])->with('fund')->get();

            $c = 0;
            
            foreach($funds as $f)
            {
                
                foreach($funds_meta as $fm)
                {
                    if($fm->fund_id == $f->id)
                    {
                        $funds[$c]['usi_number'] = $fm->usi_number;
                    }
                }
                
                $c++;
            }

            $data['funds'] = $funds;    
            $data['funds_meta'] = $funds_meta;

            $user_meta =  DB::table('user_meta')->where('emp_id',$validatedData['emp_id'])->get();
            
            $account_title = MetaClass::getOptionValue('account_title', $user_meta);
            $account_number = MetaClass::getOptionValue('account_number', $user_meta);
            $bank_name = MetaClass::getOptionValue('bank_name', $user_meta);

            $data['meta']['account_title'] = $account_title;
            $data['meta']['account_number'] = $account_number;
            $data['meta']['bank_name'] = $bank_name;


            $data['medicalAttachFiles'] = DB::table('medical_attach_files')->where('emp_id', $validatedData['emp_id'])->get();


            

            $data['required_documents'] = RequiredDocument::with('requiredDocumentField')->where('del','0')->get();
            $data['emp_documents'] = EmpDocuments::where('emp_id', $validatedData['emp_id'] )->where('del', '0')->get();
            $data['emp_emergency_contacts']  = EmpEmergencyContacts::where('emp_id',$validatedData['emp_id'])->get();
            $data['teams'] = EmpTeam::get();
            $data['employee_team_members'] = isset($emp_company_details->empTeamsMembers) ? $emp_company_details->empTeamsMembers : [];
     
             return response()->json([
                 'message' => 'Details GET Successfully',
                 'data'   =>   $data
             ],200);
            
        }   
    }
 
    public function externalEmployeeOnboardingsStore(Request $request)
    {
        
        if($request->emp_id == 0){
            $validator = Validator::make($request->all(), [
                'image' => 'required|',
            ],[
                'image.required' => 'The Profile Image field is required.',
            ]);
        
            if ($validator->fails()) {
                $error = $validator->errors()->first();
                return response()->json([
                    'message' => $error
                ],422);
            }
        }
        
       
        $validator = Validator::make($request->all(), [
            'emp_id' => 'required',
            'team_id' => 'required',
            'first_name' => 'required',
            'middle_name' => 'nullable',
            'last_name' => 'required',
            'image' => 'nullable|mimes:jpeg,png,jpg,gif|max:1024',
            'temporary_student_visa' => 'nullable|mimes:jpeg,png,jpg,gif|max:1024',
            'signature' => 'nullable|mimes:jpeg,png,jpg,gif|max:1024',
            'medical_attach_files.*' => 'nullable|mimes:jpeg,png,jpg,gif|max:1024',
            'employee_email'  => ['required','email', Rule::unique('emp_company_details')->ignore($request->emp_id)],
            'date_of_birth' => 'required|date|before:' . Carbon::now()->subYears(15)->format('Y-m-d'),
            'mobile' => 'required|numeric',
            'suburb' => 'required|regex:/^[a-zA-Z\s]*$/',
            'state' => 'required|regex:/^[a-zA-Z\s]*$/',
            'streat_address' => 'required',
            'job_title' => 'required',
            'employer_name' => 'required',
            'worker_type' => 'required',
            'trade_qualified' => 'required',
            'trade_qualified_year' => 'required_if:trade_qualified,=,1',
            'trade_licensed' => 'required',
            'trade_licensed_year' => 'required_if:trade_licensed,=,1',
            'work_experience' => 'required',
            'year_commenced' => 'required',
            'legally_australia' => 'required',
            'citizenship_status' => 'required',
       
            'classified_high_risk' => 'required',
            'contact_name_first' => 'required',
            'contact_relation_first' => 'required',
            'contact_phone_first' => 'required',
      
            'allergies' => 'nullable',
            'details_allergies' => 'nullable',
            'previous_injuries' => 'nullable',
            'details_previous_injuries' => 'nullable',
            'medical_condition' => 'nullable'
            
        ],[
            'image.mimes' => 'The image must be a file of type: jpeg, png, jpg, gif.',
            'image.max' => 'The image may not be greater than 1MB.',
            'suburb.regex' => 'The suburb field must contain only alphabetic characters.',
            'state.regex' => 'The state field contain only alphabetic characters.',
            'date_of_birth.before' => 'You must be at least 15 years old to register.',
            'trade_qualified_year.required_if' => 'The trade qualified year field is required',
            'trade_licensed_year.required_if' => 'The trade licensed year field is required',
            'contact_name_first.required' => 'The contact name field is required',
            'contact_relation_first.required' => 'The contact relation field is required',
            'contact_phone_first.required' => 'The contact phone field is required',
            'bank_name.required' => 'The BSB field is required',
            'account_title.required' => 'The Account Name field is required',
            'bank_name.size' => 'The BSB field must be exactly 6 digits long',
            'employer_name.required' => 'The employer company name field is required',
            'team_id.required' => 'The Team field is required',
        ]);
        
        if ($validator->fails()) {

            $error = $validator->errors()->first();

            return response()->json([
                'message' => $error
            ],422);


        } else {

        $required_documents = RequiredDocument::with('requiredDocumentField')->where('del','0')->where('for_who', '!=', '0')->get();
        $count = EmpDocuments::where('emp_id', $request->emp_id)->count();		

        $i = 0;

        foreach($required_documents as $required_document)
        {
            foreach($required_document->requiredDocumentField as $required_document_field)
            {
                if($required_document_field->field_required == "1" && !$request->filled('document_array.' . $required_document_field->doc_id . '.' . $required_document_field->id) && !$request->hasFile('document_array.'.$required_document_field->doc_id.'.'.$required_document_field->id))
                {
                    if($count == 0)
                    {
                      return response()->json(['message' => $required_document_field->field_name.' field is required'],422);
                    }
                    else
                    {
                        if($required_document_field->field_type != 'file')
                        {
                            return response()->json(['message' => $required_document_field->field_name.' field is required'],422);
                        }
                    }
                    
                }
                if ($required_document_field->field_type == "file" && $request->hasFile('document_array.' . $required_document_field->doc_id . '.' . $required_document_field->id)) {
                    $allowedExtensions = ['jpg', 'jpeg', 'png', 'docx', 'pdf'];
                    $document_file = $request->file('document_array.' . $required_document_field->doc_id . '.' . $required_document_field->id);
                    $extension = $document_file->getClientOriginalExtension();
                    $mimeType = $document_file->getMimeType();
                   
                    // Validate extension and MIME type
                    if (!in_array($extension, $allowedExtensions) || !in_array($mimeType, ['image/jpeg', 'image/png', 'application/pdf', 'application/vnd.openxmlformats-officedocument.wordprocessingml.document'])) {
                        return response()->json(['message' => 'The ' . $required_document_field->field_name . ' file must be a file of type: jpg, jpeg, png, docx, pdf.'], 422);
                    }
                }
            }
            $i++;
        }
      
      

            
            $msg  = $this->companyDetailStore($request);
                    $this->personalDetailsStore($request);
                    $this->documentsStore($request);
                    $this->emergencyContactsStore($request);
                    $this->accessStore($request);
            $team_ids = explode(',',$request->team_id);
            EmpTeamsMember::where([
                'emp_id' => $request->emp_id,
            ])
            ->delete();
            foreach($team_ids as $team_id){
                
                EmpTeamsMember::insert([
                    'team_id' => $team_id,
                    'emp_id' => $request->emp_id,
                    'applied' => 1
                ]);
            }
            
            if(str_contains($msg, 'Register')){

                $this->assignShift($request->key,$request->emp_id);
                $this->sendOnExternalOnboarding($request->emp_id);
            }


            $data['emp_id'] =  $request->emp_id;

            return response()->json([
                'message' => $msg,
                'data' => $data
            ],200);
            
        }        

    }

    public function companyDetailStore($request)
    {
        $validatedData = $request->only([
            'employee_email',
            'job_title',
            'employer_name',
            'worker_type',
            'trade_qualified',
            'trade_qualified_year',
            'trade_licensed',
            'trade_licensed_year',
            'work_experience',
            'year_commenced',
            'citizenship_status',
            'classified_high_risk',
            'allergies',
            'details_allergies',
            'previous_injuries',
            'details_previous_injuries',
            'medical_condition',
            'legally_australia'
            ]);

                if ($request->hasFile('temporary_student_visa')) 
                {
                    $temporary_student_visa = $request->file('temporary_student_visa');
                    $imageName = time() . '.' . $temporary_student_visa->getClientOriginalExtension();
                    $temporary_student_visa->move(public_path('upload/temporary_student_visa'), $imageName);
                    $validatedData['temporary_student_visa'] = 'upload/temporary_student_visa/' . $imageName;

                }
                
                if ($request->hasFile('signature')) 
                {
                    $signature = $request->file('signature');
                    $imageName = time() . '2.' . $signature->getClientOriginalExtension();
                    $signature->move(public_path('upload/signature'), $imageName);
                    $validatedData['signature'] = 'upload/signature/' . $imageName;
                }            
       

        if(EmpCompanyDetails::where('id',$request->emp_id)->count() == 0)
        {
            $validatedData['status'] = "1";
            $validatedData['credentials'] = "1";
            $validatedData['user_type'] = "1";
            $validatedData['created_by'] = "1";
            $validatedData['access_role'] = "ext-emp";
            $validatedData['tier_id'] = "3";
            $validatedData['force_reset'] = "0";
            $validatedData['two_factor'] = "1";
            $validatedData['compeleted'] = "1";
            $validatedData['approved'] = '1';
            $validatedData['approved_by'] = '1';

            $request->emp_id =  EmpCompanyDetails::insertGetId($validatedData);
            $msg = 'Registered Successfully.Verify your email address.';
        }
        else
        {
            EmpCompanyDetails::where('id', $request->emp_id)->update($validatedData);
            $msg = 'Updated Successfully.';
        }

        if ($request->hasFile('medical_attach_files')) 
        {
            $medical_attach_files = $request->file('medical_attach_files');
            $i = 0;
            foreach ($medical_attach_files as $medical_attach_file) 
            {
                $i++;
                $imageName = time() . $i . '.' . $medical_attach_file->getClientOriginalExtension();
                $medical_attach_file->move(public_path('upload/medical_attach_files'), $imageName);
                DB::table('medical_attach_files')->insert(['emp_id' => $request->emp_id, 'file' => 'upload/medical_attach_files/' . $imageName]);
            }
        }

        return  $msg;
        
    }

    public function personalDetailsStore($request)
    {
        $validatedData = $request->only([
            'emp_id',
            'first_name',
            'middle_name',
            'last_name',
            'date_of_birth',
            'mobile',
            'suburb',
            'state',
            'streat_address'
        ]);

        if ($request->hasFile('image')) 
        {

            $image = $request->file('image');
            $imageName = time() . '.' . $image->getClientOriginalExtension();
            $image->move(public_path('upload/images'), $imageName);
            $validatedData['image'] = 'upload/images/' . $imageName;

        }
        
        $validatedData['emp_id'] = $request->emp_id;
        if(EmpPersonalDetails::where('emp_id',$request->emp_id)->count() == 0)
        {
            $validatedData['created_by']   =  '0';
            EmpPersonalDetails::insertGetId($validatedData);
        }
        else
        {
            unset($validatedData['emp_id']);
            EmpPersonalDetails::where('emp_id',$request->emp_id)->update($validatedData);
        }

        // FundsMeta::where('emp_id',$request->emp_id)->delete();

        // $fund_array = [];
        // $i =0;
        // $superannuations_funds =  json_decode($request->superannuations_funds);

        
        // foreach($superannuations_funds as $fund)
        // {
        //     $fund_array[$i]['emp_id'] = $request->emp_id; 
        //     $fund_array[$i]['fund_id'] = $fund->id; 
        //     $fund_array[$i]['usi_number'] = $fund->usi_number; 
        //     $i++;
        // }

        // FundsMeta::insert($fund_array);

        // $meta_ = $request->only([
        //     'account_title',
        //     'account_number',
        //     'bank_name'
        //     ]);


        // $MetaArray = [];

        // foreach ($meta_ as $option => $value) {
        //     if ($value !== null) {
        //         $MetaArray[] = [
        //         'emp_id' => $request->emp_id,
        //         'option' => $option,
        //         'value' => $value,
        //         ];
        //         DB::table('user_meta')->where('emp_id',$request->emp_id)->where('option',$option)->delete();
        //     }
        // }

        // DB::table('user_meta')->insert($MetaArray);

        return 0;
        
    }

    public function documentsStore($request)
    {
        $required_documents = RequiredDocument::with('requiredDocumentField')->where('del','0')->where('for_who', '!=', '0')->get();
        $count = EmpDocuments::where('emp_id', $request->emp_id)->count();		

        $i = 0;

        foreach($required_documents as $required_document)
        {
            foreach($required_document->requiredDocumentField as $required_document_field)
            {

                $EmpDocumentsData = [
                    'emp_id' => $request->emp_id,
                    'required_document' => $required_document_field->doc_id,
                    'required_document_field' =>  $required_document_field->id,
                ];
                if($required_document_field->field_type == "file" && $request->hasFile('document_array.'.$required_document_field->doc_id.'.'.$required_document_field->id))
                {
                    $document_file = $request->file('document_array.'.$required_document_field->doc_id.'.'.$required_document_field->id);
                    $documentName = $i.time() . '.' . $document_file->getClientOriginalExtension();
                    $document_file->move(public_path('upload/documents'), $documentName);
                    $EmpDocumentsData['value'] = 'upload/documents/' . $documentName;
                    EmpDocuments::where(['emp_id' => $request->emp_id, 'required_document' => $required_document_field->doc_id, 'required_document_field' => $required_document_field->id])->delete();
                    EmpDocuments::insert($EmpDocumentsData);
                }

                if($required_document_field->field_type != "file")
                {
                    if(isset($request->document_array[$required_document_field->doc_id][$required_document_field->id]))
                    {
                        $EmpDocumentsData['value'] =  $request->document_array[$required_document_field->doc_id][$required_document_field->id];
                        EmpDocuments::where(['emp_id' => $request->emp_id, 'required_document' => $required_document_field->doc_id, 'required_document_field' => $required_document_field->id])->delete();
                        EmpDocuments::insert($EmpDocumentsData);
                    }
                }
            }

            $i++;
        }


        return 0;


    }

    public function emergencyContactsStore($request)
    {
        EmpEmergencyContacts::where('emp_id',$request->emp_id)->delete();

        EmpEmergencyContacts::insert([
            'emp_id' => $request->emp_id,
            'name' => $request->contact_name_first,
            'relation' => $request->contact_relation_first,
            'phone' => $request->contact_phone_first,
            'created_by' => '0',
        ]);

        // if($request->contact_name_second && $request->contact_relation_second && $request->contact_phone_second)
        // {
        //     EmpEmergencyContacts::insert([
        //         'emp_id' => $request->emp_id,
        //         'name' => $request->contact_name_second,
        //         'relation' => $request->contact_relation_second,
        //         'phone' => $request->contact_phone_second,
        //         'created_by' => '0',
        //     ]);

        // }
        
        return 0;
        
    }

    public function accessStore(Request $request)
    {        
        $validatedData = [
        'emp_id' => $request->emp_id,
        'web_app' => '0',
        'mobile_app' => '1',
        'attendance' => '1',
        'timesheet_reminders' => '1',
        'email' => '1',
        'timesheet' => '1'
        ];
        
        EmpAccess::where('emp_id',$request->emp_id)->delete();
        EmpAccess::insertGetId($validatedData);      

    }

    public function deleteMedicalAttachment(Request $request)
    {
        DB::table('medical_attach_files')->where(['emp_id' => $request->emp_id, 'id' => $request->id ])->delete();
        return 0;
    }

    public function sendOnExternalOnboarding($id)
    {
           $user = EmpCompanyDetails::where('id',$id)->exists();

            if($user){

                $user_details = EmpCompanyDetails::where('id',$id)->first();

                    $digits = 6;
                    $password =  rand(pow(10, $digits-1), pow(10, $digits)-1);
                    EmpCompanyDetails::where('id', $id)->update([
                        'password' => Hash::make($password)
                    ]);      

                $data = [
                    'email' => $user_details->employee_email,
                    'password' => $password,
                    'subject' => 'Employee Registration | '.env("APP_NAME"),
                ];
        
                // Send email using the EmailTrait function
                $emailSent = $this->sendEmail(
                    $user_details->employee_email, 
                    'User Invitation | ' . env("APP_NAME"), 
                    $data, 
                    'Emails.external_employee_registration'
                );

                if($emailSent){
                    return 'Email has been sent, Please check your Email.';
                    
                }else{
                    return 'SMTP is not Working, Try Later!';
                    
                }
                
            }else{
                return 'Account with the entered email does not exsit.';
            }

        
    }

    public function assignShift($key,$id)
    {
        $link_management =  DB::table('link_management')->where(['secret_key' => $key])->first();

        $role = DB::table('roles')->where('id',$link_management->role_id)->first();

        EmpCompanyDetails::where('id',$id)->update(['access_role' => $role->code, 'tier_id' => $link_management->tier_id,'link_key' => $key]);
        $days = [];
        $working_days = explode(',', $link_management->working_days);
        foreach($working_days as $day){
            $days[] = config('constants.weekdays_name.'.$day);
        }
        $arr = [
            'start_date' => Carbon::today()->format('Y-m-d'),
            'end_date' =>  Carbon::today()->addDays($link_management->number_of_days)->format('Y-m-d'),
            'start_time' => $link_management->start_time,
            'end_time' => $link_management->end_time,
            'color_code' => $link_management->color_code,
            'break_minutes' => $link_management->paid_break,
            'shift_notes' => $link_management->description,
            'users_ids' => [$id],
            'working_days_hidden' => implode(',',$days)
        ];
        // dd($arr);
        // $request = Request::create('/', 'POST', $arr);
        return  $this->bulkScheduleRoasterCreate($arr,$arr); //Trait
        // $this->bulkScheduleSave($arr,$arr);

        return 0;

    }

    // public function bulkScheduleSave($validatedData,$request)
    // {
    //         $days_array =  explode(",", $validatedData['working_days_hidden']);
    //         $start_ = Carbon::parse($request['start_time']);
    //         $end_ = Carbon::parse($request['end_time']);
    //         $required_minutes =  $end_->diffInMinutes($start_); 
    //         $required_minutes = $required_minutes - $request['break_minutes'] ?? 0;

    //         $getDatesBetweens = $this->getDatesBetween($request['start_date'], $request['end_date']);

    //         $insert_id = 0;

    //         $days_array = $this->getShortDayNames($days_array);

    //         foreach($getDatesBetweens as $for_this_date)
    //         {

    //             if(!in_array(Carbon::parse($for_this_date)->format('D'), $days_array))
    //             {
    //                 continue;
    //             }

    //             foreach($request['users_ids'] as  $user_id)
    //             {         


    //             $insert_id =   RosterTemplate::insertGetId([
    //                 'start_time' => $request['start_time'],
    //                 'end_time' =>$request['end_time'],
    //                 'break_minutes' => $request['break_minutes'],
    //                 'color_code' => $request['color_code'],
    //                 'shift_notes' => $request['shift_notes'],
    //                 'repeat_shift' => 0,
    //                 'repeat_every' => 0,
    //                 'end_date' => $for_this_date,
    //                 'working_hours' => $required_minutes,
    //                 'is_saved' => '0',
    //                 'created_by' =>  '1'
    //             ]);
                
                
                
    //             RosterAssign::insertGetId([
    //                 'assign_to' => $user_id,
    //                 'roster_template_id' =>  $insert_id,
    //                 'schedule_date' => $for_this_date,
    //             ]);

    //             }


    //         }
        
    //         ////// history //////

    //         $authPersonalDetails = EmpPersonalDetails::where('emp_id', 1)->first();
        
    //         $history_arr = [
    //             'description' => "<a href='".url('/')."/user-profile/1"."' style='text-transform: capitalize;' role='button' class='primary text-decoration-none'> {$authPersonalDetails->first_name} {$authPersonalDetails->middle_name} {$authPersonalDetails->last_name}</a> created a bulk schedule at ".date('d-m-Y')." date",
    //             'roster_template_id' => 0
    //         ];

    //         $this->storeHistory($history_arr);

    //         ////// history end //////

    //         return response()->json([
    //             'message' => 'Bulk Schedule Created Successfully'
    //         ],200);

    // }





    // function getDatesBetween($start_date, $end_date)
    // {
    //     $dates = [];

    //     $start = Carbon::parse($start_date);
    //     $end = Carbon::parse($end_date);

    //     while ($start->lte($end)) {
    //         $dates[] = $start->toDateString();
    //         $start->addDay();
    //     }

    //     return $dates;
    // }

    public function storeHistory($arr)
    {
        RosterHistory::create([
            'roster_template_id' => $arr['roster_template_id'],
            'updated_by' => '1',
            'description' => $arr['description']
        ]);

    }

    // public function getHistory(Request $request)
    // {
    //     $history =   RosterHistory::orderBy('id', 'DESC')->get();

    //     $data['history'] = $history;

    //     return response()->json([
    //         'message' => 'Get History Successfully',
    //         'data'   => $data
    //     ],200);
    // }

    function getShortDayNames($days) {
        $shortDays = array();
    
        foreach ($days as $day) {
            switch($day) {
                case "Monday":
                    $shortDays[] = "Mon";
                    break;
                case "Tuesday":
                    $shortDays[] = "Tue";
                    break;
                case "Wednesday":
                    $shortDays[] = "Wed";
                    break;
                case "Thursday":
                    $shortDays[] = "Thu";
                    break;
                case "Friday":
                    $shortDays[] = "Fri";
                    break;
                case "Saturday":
                    $shortDays[] = "Sat";
                    break;
                case "Sunday":
                    $shortDays[] = "Sun";
                    break;
                default:
                    $shortDays[] = "Invalid day";
                    break;
            }
        }
    
        return $shortDays;
    }


}