<?php

namespace App\Http\Controllers;

use Illuminate\Http\Request;
use Illuminate\Support\Facades\Validator;
use Illuminate\Validation\Rule;
use Illuminate\Support\Facades\Hash;
use Auth;
use App\Models\IncidentNotifiableClassification;
use DB;



class NotifiableClassificationController extends Controller
{

    public function index(Request $request)
    {
        $data['incidentNotifiableClassifications'] = IncidentNotifiableClassification::where('del','0')->get();


            return response()->json([
                'message' => 'Get Incident Notifiable Classifications Successfully',
                'data' => $data
            ],200);
    }

    public function show($id)
    {

       $incidentNotifiableClassification =  IncidentNotifiableClassification::where('id',$id)->first();
      

       $data['incidentNotifiableClassification'] = $incidentNotifiableClassification;


        return response()->json([
            'message' => 'Get Incident Notifiable Classification Successfully',
            'data' => $data
        ],200);
    }

    public function edit($id)
    {
        $incidentNotifiableClassification = IncidentNotifiableClassification::find($id);

        if($incidentNotifiableClassification)
        {
            $data =  [
                'incidentNotifiableClassification' => $incidentNotifiableClassification
                ];

                return response()->json([
                    'message' => 'Get Incident Notifiable Classification Successfully',
                    'data' => $data
                ],200);

        }
        else
        {
            return response()->json([
                'message' => 'Incident Notifiable Classification Not Found'
            ],400);
        }
        
    }

    public function update(Request $request, $id)
    {
        $validator = Validator::make($request->all(), [
            'title' => 'required',
            'description' => 'nullable',
            'status' => 'required'
        ]);
        
        if ($validator->fails()) {

            $error = $validator->errors()->first();

            return response()->json([
                'message' => $error
                
            ],422);


        } else {
          
            $validatedData =  $validator->validated();

            $incidentNotifiableClassification = IncidentNotifiableClassification::where('id', $id)->first();

           IncidentNotifiableClassification::where('id', $id)->update($validatedData);
           $data['incidentNotifiableClassifications'] = IncidentNotifiableClassification::where('del','0')->get();

            return response()->json([
                'message' => 'Incident Notifiable Classification Updated Successfully',
                'data' => $data
            ],200);
            
        }        

    }

    public function store(Request $request)
    {
        $validator = Validator::make($request->all(), [
            'title' => 'required',
            'description' => 'nullable',
            'status' => 'required'
        ]);
        
        if ($validator->fails()) {

            $error = $validator->errors()->first();

            return response()->json([
                'message' => $error
                
            ],422);


        } else {
          
           $validatedData =  $validator->validated();        
           
           IncidentNotifiableClassification::insert($validatedData);
           $data['incidentNotifiableClassifications'] = IncidentNotifiableClassification::where('del','0')->get();
    
            return response()->json([
                'message' => 'Incident Notifiable Classification Saved Successfully',
                'data' => $data
            ],200);
            
        }        

    }

    public function destroy($incidentNotifiClassification)
    {

        IncidentNotifiableClassification::where('id', $incidentNotifiClassification)->update([
            'del' => '1'
        ]);

        $data['incidentNotifiableClassifications'] = IncidentNotifiableClassification::where('del','0')->get();

        return response()->json([
            'message' => 'Incident Notifiable Classification Deleted Successfully',
            'data' => $data
        ],200);

    }

}
