<?php

namespace App\Http\Controllers;

use Illuminate\Http\Request;
use Illuminate\Support\Facades\Validator;
use Auth;
use DB;
use App\Models\RequiredDocument;
use App\Models\RequiredDocumentField;

class RequiredDocumentController extends Controller
{
    public function index()
    {
        $required_documents =  RequiredDocument::with('requiredDocumentField')->where('del','0')->get();

        $data['required_documents'] = $required_documents;
 
         return response()->json([
             'message' => 'Required Documents Get Successfully',
             'data'   => $data
         ],200);
        
    }

    public function store(Request $request)
    {
        $validator = Validator::make($request->all(), [
            'title'      => 'required',
            'for_who'    => 'required',
            'field_name' => 'required|array',
            'field_type' => 'required|array',
            'field_required' => 'required|array',
            'priority' => 'required|array',
        ]);

        if ($validator->fails()) {

            $error = $validator->errors()->first();

            return response()->json([
                'message' => $error
            ],422);


        } else {

            $validatedData =  $validator->validated();

            $RequiredDocumentData = [
                'title'   =>  $validatedData['title'],
                'for_who' =>  $validatedData['for_who']
            ];

           $insertGetId =  RequiredDocument::insertGetId($RequiredDocumentData);

           $RequiredDocumentDataArr = [];

            $i = 0;
           foreach ($validatedData['field_name'] as $key => $value)
           { 
                $RequiredDocumentDataArr[$i] = [
                    'field_type' => $validatedData['field_type'][$key],
                    'field_name' => $validatedData['field_name'][$key],
                    'doc_id'     => $insertGetId,
                    'field_required' => $validatedData['field_required'][$key],
                    'priority' => $validatedData['priority'][$key]
                ];

                $i++;
           }

           RequiredDocumentField::insert($RequiredDocumentDataArr);

           $required_documents =  RequiredDocument::where('del','0')->get();

           $data['required_documents'] = $required_documents;

           return response()->json([
               'message' => 'Required Documents Store Successfully',
               'data'   =>   $data
           ],200);
        }
    }

    public function edit(Request $request,$id)
    {
        $data['required_documents'] = RequiredDocument::with('requiredDocumentField')->where('id', $id)->first();
    
        return response()->json([
            'message' => 'Document title Updated Successfully',
            'data'   =>   $data
        ],200);
    }

    public function update(Request $request)
    {
        $validator = Validator::make($request->all(), [
            'title'      => 'required',
            'for_who'    => 'required',
            'document_id'    => 'required',
            'field_name' => 'required|array',
            'field_type' => 'required|array',
            'field_required' => 'required|array',
            'status' => 'required|array',
            'has_data' => 'required|array',
            'id_list' => 'required|array',
            'priority' => 'required|array',
            ]);
        
        if ($validator->fails()) {

            $errors = $validator->errors()->first();

            return response()->json([
                'message' => $errors
            ],422);


        } else {
          
            $validatedData =  $validator->validated();

            $requiredDocumentData = [
                'title'   =>  $validatedData['title'],
                'for_who' =>  $validatedData['for_who']
            ];

            RequiredDocument::where('id', $validatedData['document_id'])->update($requiredDocumentData);

            $RequiredDocumentDataArr = [];

            $i = 0;
            foreach ($validatedData['field_name'] as $key => $value)
            {
                if($validatedData['id_list'][$key] == 0)
                {
                    $RequiredDocumentDataArr= [
                        'field_type' => $validatedData['field_type'][$key],
                        'field_name' => $validatedData['field_name'][$key],
                        'doc_id'     => $validatedData['document_id'],
                        'field_required' => $validatedData['field_required'][$key],
                        'status' => $validatedData['status'][$key],
                        'priority' => $validatedData['priority'][$key]
                    ];
                    RequiredDocumentField::insert($RequiredDocumentDataArr);

                }
                else
                {
                    if($validatedData['has_data'][$key] == 0)
                    {
                        $RequiredDocumentDataArr= [
                            'field_type' => $validatedData['field_type'][$key],
                            'field_name' => $validatedData['field_name'][$key],
                            'doc_id'     => $validatedData['document_id'],
                            'field_required' => $validatedData['field_required'][$key],
                            'status' => $validatedData['status'][$key],
                            'priority' => $validatedData['priority'][$key]
                        ];
                        RequiredDocumentField::where(['id' => $validatedData['id_list'][$key]])->update($RequiredDocumentDataArr);
                    }
                    else
                    {
                        $RequiredDocumentDataArr= [
                            'field_name' => $validatedData['field_name'][$key],
                            'doc_id'     => $validatedData['document_id'],
                            'field_required' => $validatedData['field_required'][$key],
                            'status' => $validatedData['status'][$key],
                            'priority' => $validatedData['priority'][$key]
                        ];
                        RequiredDocumentField::where(['id' => $validatedData['id_list'][$key]])->update($RequiredDocumentDataArr);

                    }
                }
                $i++;
            }
 
            

            $required_documents =  RequiredDocument::where('del','0')->get();

            $data['required_documents'] = $required_documents;
     
             return response()->json([
                 'message' => 'Document Updated Successfully',
                 'data'   =>   $data
             ],200);
            
        }        

    }

    public function destroy($id)
    {
        RequiredDocument::where('id', $id)->update([
            'del' => '1'
        ]);

        $required_documents =  RequiredDocument::where('del','0')->get();

        $data['required_documents'] = $required_documents;

        return response()->json([
            'message' => 'Document title Deleted Successfully',
            'data'   => $data
        ],200);
    }


    public function delete_field(Request $request)
    {
        RequiredDocumentField::where('id', $request->id)->delete();

        return response()->json([
            'message' => '',
            'data'   => []
        ],200);
    }

  
}
