<?php

namespace App\Http\Controllers;

use Illuminate\Http\Request;
use Illuminate\Support\Facades\Validator;
use Auth;
use DB;
use App\Models\RequiredExternalDocument;

class RequiredExternalDocumentController extends Controller
{
    public function index()
    {
        $required_external_documents =  RequiredExternalDocument::where('del','0')->get();

        $data['required_external_documents'] = $required_external_documents;
 
         return response()->json([
             'message' => 'Required Documents Get Successfully',
             'data'   => $data
         ],200);
        
    }

    public function store(Request $request)
    {
        $validator = Validator::make($request->all(), [
        'title' => 'required'
        ]);

        if ($validator->fails()) {

            $errors = $validator->errors();

            return response()->json([
            'message' => 'Validation Failed',
            'data' => $errors
            ],422);


        } else {

            $validatedData =  $validator->validated();

            RequiredExternalDocument::insert($validatedData);

            $required_external_documents =  RequiredExternalDocument::where('del','0')->get();
            $data['required_external_documents'] = $required_external_documents;

            return response()->json([
                'message' => 'Required Documents Store Successfully',
                'data'   =>   $data
            ],200);
        }
    }

    public function store_document_info(Request $request)
    {
        $validator = Validator::make($request->all(), [
        'title' => 'required'
        ]);

        if ($validator->fails()) {

            $errors = $validator->errors();

            return response()->json([
            'message' => 'Validation Failed',
            'data' => $errors
            ],422);


      } 
    else {

            $validatedData =  $validator->validated();

            RequiredExternalDocument::insert($validatedData);

            $required_external_documents =  RequiredExternalDocument::where('del','0')->get();

            $data['required_external_documents'] = $required_external_documents;

            return response()->json([
                'message' => 'Required Documents Store Successfully',
                'data'   =>   $data
            ],200);
    }
    }

    public function update(Request $request, $id)
    {
        $validator = Validator::make($request->all(), [
            'title' => 'required'
            ]);
        
        if ($validator->fails()) {

            $errors = $validator->errors();

            return response()->json([
                'message' => 'Validation Failed',
                'data' => $errors
            ],422);


        } else {
          
            $validatedData =  $validator->validated();

            RequiredExternalDocument::where('id', $id)->update($validatedData);

            $required_external_documents =  RequiredExternalDocument::where('del','0')->get();

            $data['required_external_documents'] = $required_external_documents;
     
             return response()->json([
                 'message' => 'Document title Updated Successfully',
                 'data'   =>   $data
             ],200);
            
        }        

    }

    public function destroy($id)
    {
        RequiredExternalDocument::where('id', $id)->update([
            'del' => '1'
        ]);

        $required_external_documents =  RequiredExternalDocument::where('del','0')->get();

        $data['required_external_documents'] = $required_external_documents;

        return response()->json([
            'message' => 'Document title Deleted Successfully',
            'data'   => $data
        ],200);
    }

    public function external_update_get_types(Request $request)
    {


        RequiredExternalDocument::where('id', $request->id)->update([  $request->name =>  $request->checked]);
        echo 0;
        die;

        
    }

  
}
