<?php

namespace App\Http\Controllers;

use Illuminate\Http\Request;
use Illuminate\Support\Facades\Validator;
use Illuminate\Validation\Rule;
use Illuminate\Support\Facades\Hash;
use Auth;
use App\Models\Training;
use DB;



class TrainingController extends Controller
{

    public function index(Request $request)
    {
        $data['trainings'] = Training::where('del','0')->get();


            return response()->json([
                'message' => 'Get Trainings Successfully',
                'data' => $data
            ],200);
    }

    public function show($id)
    {

       $training =  Training::where('id',$id)->first();
      

       $data['training'] = $training;


        return response()->json([
            'message' => 'Get Training Successfully',
            'data' => $data
        ],200);
    }

    public function edit($id)
    {
        $training = Training::find($id);

        if($training)
        {
            $data =  [
                'training' => $training
                ];

                return response()->json([
                    'message' => 'Get Training Successfully',
                    'data' => $data
                ],200);

        }
        else
        {
            return response()->json([
                'message' => 'Training Not Found'
            ],400);
        }
        
    }

    public function update(Request $request, $id)
    {
        $validator = Validator::make($request->all(), [
            'title' => 'required',
            'description' => 'nullable',
            'status' => 'required'
        ]);
        
        if ($validator->fails()) {

            $error = $validator->errors()->first();

            return response()->json([
                'message' => $error
                
            ],422);


        } else {
          
            $validatedData =  $validator->validated();

            $training = Training::where('id', $id)->first();

           Training::where('id', $id)->update($validatedData);
           $data['trainings'] = Training::where('del','0')->get();

            return response()->json([
                'message' => 'Training Updated Successfully',
                'data' => $data
            ],200);
            
        }        

    }

    public function store(Request $request)
    {
        $validator = Validator::make($request->all(), [
            'title' => 'required',
            'description' => 'nullable',
            'status' => 'required'
        ]);
        
        if ($validator->fails()) {

            $error = $validator->errors()->first();

            return response()->json([
                'message' => $error
                
            ],422);


        } else {
          
           $validatedData =  $validator->validated();        
           
           Training::insert($validatedData);
           $data['trainings'] = Training::where('del','0')->get();
    
            return response()->json([
                'message' => 'Training Saved Successfully',
                'data' => $data
            ],200);
            
        }        

    }

    public function destroy(Training $training)
    {

        Training::where('id', $training->id)->update([
            'del' => '1'
        ]);

        $data['trainings'] = Training::where('del','0')->get();

        return response()->json([
            'message' => 'Training Deleted Successfully',
            'data' => $data
        ],200);

    }

}
