<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;

class EmpTeamsMember extends Model
{
    use HasFactory;

    protected $fillable = ['team_id','emp_id'];

    public function empTeamsList()
    {
        return $this->hasOne(EmpTeam::class, 'id', 'team_id');
    }

    public function roster_assigns()
    {
        return $this->hasOne(RosterAssign::class, 'assign_to', 'emp_id')
            ->select('id','assign_to','schedule_date')
            ->with(['team_employee_attendance' => function($query) {
                // Making sure the date matches correctly
                $query->whereDate('date', '=', date('Y-m-d'));
            }])
            ->withDefault(); // Handle cases where there is no roster
    }
}
