<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;

class EmployeeSignedDocument extends Model
{
    use HasFactory;

    public function employee()
    {
        return $this->belongsTo(EmpPersonalDetails::class,'employee_id', 'emp_id')->select('id','emp_id','first_name','middle_name','last_name','image');
    }

    public function meeting()
    {
        return $this->belongsTo(Meeting::class,'meeting_id', 'id')->select('id','agenda');
    }

    public function meeting_attendance()
    {
        return $this->belongsTo(MeetingAttendance::class,'meeting_id', 'meeting_id');
    }
}
