<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;

class Meeting extends Model
{
    use HasFactory;

    public function meeting_users()
    {
        return $this->hasMany(MeetingUser::class)->with('meeting_employees','meeting_attendances');
    }

    public function meeting_organisers()
    {
        return $this->hasMany(MeetingOrganiser::class)->with('organiser');
    }

    public function created_by()
    {
        return $this->hasOne(EmpPersonalDetails::class,'emp_id','created_by')->select('id','emp_id','first_name','middle_name','last_name','image');
    }

    public function meeting_site()
    {
        return $this->hasOne(Sites::class,'id','site_id')->select('id','title');
    }

    public function meeting_documents()
    {
        return $this->hasMany(MeetingDocument::class)
        ->with('employee_signed_document');
    }
    public function meeting_note_documents()
    {
        return $this->hasMany(MeetingNoteDocumentsPdf::class)
        ->with('employee_signed_document');
    }
    public function meeting_histories(){
        return $this->hasMany(MeetingHistory::class);
    }

    public function today_meeting_documents()
    {
        return $this->hasMany(MeetingDocument::class)->where('meeting_date',null)->orWhere('meeting_date', date('Y-m-d'));
    }
    public function meeting_guest_users()
    {
        return $this->hasMany(MeetingGuestUser::class);
    }
    public function meeting_documents_only()
    {
        return $this->hasMany(MeetingDocument::class);
    }
}
