<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;
 
class RosterAssign extends Model
{
    use HasFactory;

    public function rosterTemplate()
    {
        return $this->hasOne(RosterTemplate::class, 'id', 'roster_template_id');
    }

    public function emppersonaldetails()
    {
        return $this->hasOne(EmpPersonalDetails::class, 'emp_id', 'assign_to');
    }

    public function employeeattendance()
    {
        return $this->hasOne(EmployeeAttendance::class, 'employee_id', 'assign_to');
    }

    public function team_employee_attendance()
    {
        return $this->hasOne(EmployeeAttendance::class, 'employee_id', 'assign_to')
            ->select('id','employee_id','site_id','check_in','check_out','date','working_hours')
            ->whereDate('date', '=', date('Y-m-d')); // Ensure correct date comparison
    }

}
