<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

class CreateSitesTable extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {
        Schema::create('sites', function (Blueprint $table) {
            $table->id();
            $table->string('title');
            $table->text('description')->nullable();
            $table->string('longitude');
            $table->string('latitude');
            $table->string('area_radius');
            $table->string('active')->default('1');
            $table->string('company_client');
            $table->string('external_id')->nullable();
            $table->string('project_id')->nullable();
            $table->string('supervisor_id');
            $table->string('site_state');
            $table->string('street_address');
            $table->string('created_by');
            $table->string('del')->default('0');
            $table->timestamps();
        });
    }

   
    public function down()
    {
        Schema::dropIfExists('sites');
    }
}
