@extends('includes/layout')
@section('main-page-content')
    <div class="container-xxl flex-grow-1 container-p-y">
        <!-- Button with Badges -->
        <div class="card mb-4 ">
            <div class="border-bottom p-3">
                <div class="h4 pb-0 mb-0 ">Edit Manual Attendance</div>
            </div>
            <form id="manual-attendacne-form">
                <div class="row p-3">
                    <input type="hidden" id="attendance-id" value="{{ $emp_attend->id }}">
                    <div class="col-6 mb-3">
                        <label>Employee</label>
                        <select class="form-select" name="employee" aria-label="Default select example">
                            <option value="" disabled>Select Employee</option>
                            @foreach ($get_employes as $get_employe)
                                @if ($get_employe->EmpPersonalDetails)
                                    <option value="{{ $get_employe->id }}"
                                        {{ $emp_attend->employee_id == $get_employe->id ? 'selected' : '' }}>
                                        {{ $get_employe->EmpPersonalDetails->first_name }}
                                        {{ $get_employe->EmpPersonalDetails->middle_name }}
                                        {{ $get_employe->EmpPersonalDetails->last_name }}
                                    </option>
                                @endif
                            @endforeach
                        </select>
                    </div>
                    <div class="col-6 mb-3">
                        <label>Sites</label>
                        <select class="form-select" name="site" aria-label="Default select example">
                            <option value="" disabled>Select Site</option>
                            @foreach ($sites as $site)
                                <option value="{{ $site->id }}"{{ $emp_attend->site_id == $site->id ? 'selected' : '' }}>{{ $site->title }}</option>
                            @endforeach
                        </select>
                    </div>
                    <div class="col-6 mb-3">
                        <label>Check In</label>
                        <input type="time" name="check_in" class="form-control" id="check_in"
                            value="{{ date('H:i', strtotime($emp_attend->check_in)) }}">
                    </div>                    
                    <div class="col-6 mb-3">
                        <label>Check Out</label>
                        <input type="Time" name="check_out" class="form-control" id=""
                            value="{{ $emp_attend->check_out }}">
                    </div>
                    <div class="col-6 mb-3">
                        <label>Date</label>
                        <input type="date" class="form-control" name="date" id="exampleColorInput"
                            value="{{ $emp_attend->date }}">
                    </div>
                    <div id="statusDiv" class="col-6 mb-3">
                        <label>Status</label>
                        <select class="form-select" aria-label="Default select example" name="status">
                            <option selected>--select--</option>
                            <option value="0" {{ $emp_attend->status == 0 ? 'selected' : '' }}>Pending</option>
                            <option value="1" {{ $emp_attend->status == 1 ? 'selected' : '' }}>Approved</option>
                            <option value="2" {{ $emp_attend->status == 2 ? 'selected' : '' }}>Rejected</option>
                        </select>
                    </div>
                </div>
                <div class="bg-primary h-px-30 px-0"></div>
                @foreach ($emp_breaks as $emp_break)
                    <div class="d-flex justify-content-around p-3 align-items-center">
                        <div class="break_width">
                            <label>Break In</label>
                            <input type="Time" name="break_in[]" class="form-control" id="exampleColorInput"
                                value="{{ $emp_break->break_in }}">
                        </div>
                        <div class="break_width">
                            <label>Break Out</label>
                            <input type="Time" name="break_out[]" class="form-control" id="exampleColorInput"
                                value="{{ $emp_break->break_out }}">
                        </div>
                        <div class="btn_width d-flex justify-content-end">
                            <a type="button" class=" px-2" data-id="{{ $emp_break->id }}" onclick="_delete_modal(this)">
                                <span class="mdi mdi-trash-can-outline mdi-20px text-danger"></span></a>
                        </div>
                    </div>
                @endforeach
                <div class="add_colum"> </div>
                <div class="d-flex justify-content-end">
                    <button class="border-none bg-transparent" type="button" onclick="addmore();"
                        style="padding-right:12px;">
                        <svg xmlns="http://www.w3.org/2000/svg" width="43" height="43" viewBox="0 0 43 43"
                            fill="none">
                            <g filter="url(#filter0_d_2182_1189)">
                                <rect x="4" y="2" width="35" height="35" rx="4" fill="#019FF3" />
                            </g>
                            <path
                                d="M30.221 9H13.4026C12.0757 9 11 10.0757 11 11.4026V28.221C11 29.5479 12.0757 30.6236 13.4026 30.6236H30.221C31.5479 30.6236 32.6236 29.5479 32.6236 28.221V11.4026C32.6236 10.0757 31.5479 9 30.221 9Z"
                                stroke="white" stroke-width="2" stroke-linecap="round" stroke-linejoin="round" />
                            <path d="M21.8125 15.0078V24.6183" stroke="white" stroke-width="2" stroke-linecap="round"
                                stroke-linejoin="round" />
                            <path d="M17.0068 19.8105H26.6173" stroke="white" stroke-width="2" stroke-linecap="round"
                                stroke-linejoin="round" />
                            <defs>
                                <filter id="filter0_d_2182_1189" x="0" y="0" width="43" height="43"
                                    filterUnits="userSpaceOnUse" color-interpolation-filters="sRGB">
                                    <feFlood flood-opacity="0" result="BackgroundImageFix" />
                                    <feColorMatrix in="SourceAlpha" type="matrix"
                                        values="0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 127 0" result="hardAlpha" />
                                    <feOffset dy="2" />
                                    <feGaussianBlur stdDeviation="2" />
                                    <feComposite in2="hardAlpha" operator="out" />
                                    <feColorMatrix type="matrix" values="0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0.25 0" />
                                    <feBlend mode="normal" in2="BackgroundImageFix"
                                        result="effect1_dropShadow_2182_1189" />
                                    <feBlend mode="normal" in="SourceGraphic" in2="effect1_dropShadow_2182_1189"
                                        result="shape" />
                                </filter>
                            </defs>
                        </svg>
                    </button>
                </div>
                <div class="border-top p-3 d-flex justify-content-end">
                    <button type="button" class="btn btn-outline-light text-dark me-2"
                        onclick="window.location='{{ url('/') }}/attendance'">CANCEL</button>
                    <button type="button" class="btn btn-primary waves-effect"
                        onclick=manual_attendance_update();>SAVE</button>
                </div>
            </form>
        </div>

    </div>
    <div class="modal fade" id="DeleteEmp" tabindex="-1" aria-labelledby="deletePreLabel" aria-hidden="true">
        <div class="modal-dialog modal-dialog-centered">
            <div class="modal-content">
                <div class="modal-header bg-danger px-4 py-2">
                    <h5 class="modal-title text-white" id="deletePreLabel">Delete</h5>
                </div>
                <div class="modal-body">
                    Are you sure you want to delete this record?<br><br>
                    <b class="text-warning">Warning:</b> This record will no longer be available. Please ensure you
                    genuinely want to delete it before clicking the delete button.
                </div>
                <div class="modal-footer border-top py-2">
                    <button type="button" class="btn btn-outline-dark" data-bs-dismiss="modal">Close</button>
                    <button type="button" class="btn btn-danger" id="break-id" data-id=""
                        onclick="_delete(this)">Delete</button>
                </div>
            </div>
        </div>
    </div>
@endsection
@section('css-js')
    <script>
        function _delete_modal(_this) {
            var id = $(_this).attr('data-id');
            $('#break-id').attr('data-id', id);
            $('#DeleteEmp').modal('show');
        }

        function _delete(_this) {
            var id = $(_this).attr('data-id');
            $.ajax({
                type: "DELETE",
                url: "{{ url('/delete-break') }}/" + id,
                headers: {
                    'X-CSRF-TOKEN': '{{ csrf_token() }}'
                },
                success: function(response) {
                    $('#DeleteEmp').modal('hide')
                    toastr.success(response.message);

                    setTimeout(function() {
                        location.reload();
                    }, 1000);
                },
                error: function(response) {
                    if (response.status == 500) {
                        toastr.error("Something went wrong");
                    } else {
                        toastr.error(response.responseJSON.message);
                    }
                }
            });
        }

        // function deleteBreak(empBreakId) {
        //     $.ajax({
        //         url: "{{ url('/delete-break') }}/" + empBreakId,
        //         type: 'DELETE', // Change this to DELETE
        //         dataType: 'json',
        //         headers: {
        //             'X-CSRF-TOKEN': '{{ csrf_token() }}'
        //         },
        //         success: function(response) {
        //             toastr.success(response.message);

        //             setTimeout(function () {
        //                 location.reload();
        //                 }, 1000);
        //         },
        //         error: function(response) {
        //             if (response.status == 500) {
        //                 toastr.error("Something went wrong");
        //             } else {
        //                 toastr.error(response.responseJSON.message);
        //             }
        //         }
        //     });
        // }
        function addmore() {
            var newColumn = `<div class="d-flex added-row justify-content-around p-3 align-items-center">
                <div class="break_width">
                    <label>Break In</label>
                    <input type="time" name="break_in[]" class="form-control" value="">
                </div>
                <div class="break_width">
                    <label>Break Out</label>
                    <input type="time" name="break_out[]" class="form-control" value="">
                </div>
                <div class="btn_width d-flex justify-content-end cursor-pointer">
                    <span class="mdi mdi-trash-can-outline mdi-20px text-danger" onclick="removeRow(this)"></span>
                </div>
            </div> `;

            $(".add_colum").append(newColumn);
        }

        function removeRow(button) {
            $(button).closest('.added-row').remove();
        }

        function manual_attendance_update() {
    var formData = $('#manual-attendacne-form').serialize();
    var attendId = $('#attendance-id').val();
    $.ajax({
        url: "{{ url('/attendance') }}/" + attendId,
        type: 'PUT',
        data: formData,
        dataType: 'json',
        headers: {
            'X-CSRF-TOKEN': '{{ csrf_token() }}'
        },
        success: function(response) {
            toastr.success(response.message);
            // Removed the redirection after success
            
            setTimeout(function() {
                window.location.href = "{{ url('/') }}/attendance";
            }, 1000);
            
        },
        error: function(response) {
            if (response.status == 500) {
                toastr.error("Something went wrong");
            } else {
                toastr.error(response.responseJSON.message);
            }
        }
    });
}

    </script>



    <style>
        @media only screen and (min-width: 320px)and (max-width: 568px) {
            .mdi-trash-can-outline {
                margin-right: -14px;
            }
        }

        @media only screen and (min-width: 768px)and (max-width: 1024px) {
            .mdi-trash-can-outline {
                margin-right: -7px;
            }
        }
    </style>
@endsection
