@extends('includes/layout')
@section('main-page-content')
    <div class="container-xxl flex-grow-1 container-p-y">
        <!-- Button with Badges -->
        <div class="card mb-4 ">
            <div class="border-bottom p-3">
                <div class="h4 pb-0 mb-0 ">Leave Package</div>
                <small>Dashboard-Leave Management-Leave Package</small>
            </div>
            <form id="leave-package-form">
                <div class="row p-3">
                    <div class="col-6">
                        <div class="mb-3">
                            <label for="leave-package" class="">Leave Package<span class="text-danger">*</span></label>
                            <input type="text" class="form-control" name="leave_package" id="leave-package"
                                placeholder="">
                        </div>
                    </div>
                    <div class="col-6">
                        <div class="mb-3">
                            <label>Leave Type<span class="text-danger">*</span></label>
                            <select class="form-select" aria-label="Default select example" name="leave_type">
                                <option value="">--select--</option>
                                @foreach ($leave_types as $leave_type)
                                    <option value="{{ $leave_type->id }}">{{ $leave_type->title }}</option>
                                @endforeach
                            </select>
                        </div>
                    </div>
                    <div class="col-6">
                        <div class="mb-3">
                            <label>No of Leave<span class="text-danger">*</span></label>
                            <input type="number" class="form-control" name="leave_number">
                        </div>
                    </div>
                    <!-- <div class="col-6">
                        <div class="mb-3">
                            <label>Paid/Unpaid</label>
                            <select class="form-select" aria-label="Default select example" name="is_paid">
                                <option value="">--select--</option>
                                <option value="1">Paid</option>
                                <option value="0">Unpaid</option>
                            </select>
                        </div>
                    </div> -->
                    <div class="col-md-3">
                        <div class="d-flex mb-3">
                            <div>
                                <label for="color-code" class="form-label mb-0">Color Code</label>
                                <input type="text" class="form-control" id="color-code" value="#563d7c"
                                    name="color_code">
                            </div>
                            <div>
                                <label for="color-field" class="form-label"></label>
                                <input type="color" class="form-control form-control-color ms-2" id="color-field"
                                    value="#563d7c" title="Choose your color">
                            </div>
                        </div>
                    </div>
                    <div class="col-md-3 mb-3">
                        <label>Renew On?</label>
                        <input type="date" class="form-control" id="exampleColorInput" value="" name="renew_on">
                    </div>
                    <div class="col-md-6 mb-3">
                        <label for="employee_roles">Employee Roles <span class="text-danger">*</span></label>
                        <select id="employee_roles" name="employee_roles[]" class="form-control mt-1" multiple="multiple"
                            data-placeholder="Employee Roles">
                            @foreach ($employee_roles as $employee_role)
                                <option value="{{ $employee_role->id }}">{{ $employee_role->title }}</option>
                            @endforeach
                        </select>
                    </div>
                </div>
                <div class="border-top p-3 d-flex justify-content-end">
                    <button type="button"
                        class="btn btn-outline-light text-dark me-2"onclick="window.location='{{ url('/') }}/leavepackage'"
                        id="clearButton">CANCEL</button>
                    <button type="button" class="btn btn-primary waves-effect"
                        onclick="leave_package_store();">SAVE</button>
                </div>
            </form>
        </div>
    </div>
@endsection
@section('css-js')
    <script>
        $(document).ready(function() {
            $('#color-field').change(function() {
                var selectedColor = $(this).val();
                $('#color-code').val(selectedColor);
            });
        });
        $(document).ready(function() {
            $('#clearButton').click(function() {
                $('#leave-package-form')[0].reset();
            });

            var s2_field = $('#employee_roles').select2();
        });
    </script>
    <script>
        function leave_package_store() {
            var formData = $('#leave-package-form').serialize();

            $.ajax({
                url: "{{ url('api/leavepackage-store') }}",
                type: 'POST',
                data: formData,
                dataType: 'json',
                headers: {
                    'X-CSRF-TOKEN': '{{ csrf_token() }}'
                },
                success: function(response) {
                    // toastr.success(response.message);
                    window.location.href = "{{ url('/') }}/leavepackage";
                },
                error: function(response) {
                    if (response.status == 500) {
                        toastr.error("Something went wrong")
                    } else {
                        toastr.error(response.responseJSON.message)
                    }
                }
            });
        }
    </script>
@endsection
