@extends('includes/layout')
@section('main-page-content')

<style>
    .bg-primary th {
      color: white;
    }
    .btn-color {
      background-color: #019FF3 !important;
    }
    .hearder-color{
      background-color: #019FF3 !important;
    }
  </style>
<div class="container-xxl flex-grow-1 container-p-y">
              <div class="row ">
                <div class="col-lg-6 col-sm-12 mb-3">
                  <div class="card">
                    <div class="card-body">
                      <div class="d-flex justify-content-between h-px-75">
                        <h5 class="card-title">Total Employees</h5>
                        <div><span class="mdi mdi-account rounded-1" style="background-color: #019FF3; color: white;"></span></div>
                      </div>
                     <div class="d-flex justify-content-between">
                      <div>Available</div>
                      <h5>{{$present_employees}}/{{$all_emp}}</h5>
                     </div>
                     <div class="progress rounded-pill">
                      @php

                          $percentage = $all_emp == 0 ? 0 :  ($present_employees / $all_emp) * 100;

                          $leave_percentage = $all_emp == 0 ? 0 :   ($leave_employees / $all_emp) * 100;
                      @endphp
                      <div class="progress-bar rounded-pill" role="progressbar" style="width: {{$percentage}}%" aria-valuenow="{{$percentage}}" aria-valuemin="0" aria-valuemax="100"></div>
                      {{-- <div class="progress-bar rounded-pill" role="progressbar" style="width: 25%" aria-valuenow="25" aria-valuemin="0" aria-valuemax="100"></div> --}}
                    </div>
                    </div>
                  </div>
                </div>
                <div class="col-lg-6 col-sm-12 mb-3">
                  <div class="card">
                    <div class="card-body">
                      <div class="d-flex justify-content-between h-px-75">
                        <h5 class="card-title">On Leave</h5>
                        <div><span class="mdi mdi-account rounded-1" style="background-color: #FFB400; color: white;"></span></div>
                      </div>
                     <div class="d-flex justify-content-between">
                      <div>Total</div>
                      <h5>{{$leave_employees}}/{{$all_emp}}</h5>
                     </div>
                     <div class="progress rounded-pill">
                      <div class="progress-bar bg-warning rounded-pill" role="progressbar" style="width: {{$leave_percentage}}%" aria-valuenow="{{$leave_percentage}}" aria-valuemin="0" aria-valuemax="100"></div>
                    </div>
                    </div>
                  </div>
                </div>
                {{-- <div class="col-lg-4 col-sm-12 mb-3">
                  <div class="card">
                    <div class="card-body">
                      <div class="d-flex justify-content-between h-px-75">
                        <h5 class="card-title">Absent</h5>
                        <div><span class="mdi mdi-account rounded-1" style="background-color: #FF4C51; color: white;"></span></div>
                      </div>
                     <div class="d-flex justify-content-between">
                      <div>Total</div>
                      <h5>11</h5>
                     </div>
                     <div class="progress rounded-pill">
                      <div class="progress-bar bg-danger rounded-pill" role="progressbar" style="width: 25%" aria-valuenow="25" aria-valuemin="0" aria-valuemax="100"></div>
                    </div>
                    </div>
                  </div>
                </div> --}}
              </div>
              <div class="row">
                <div class="col-lg-12 col-sm-12">
                 <div class="card mb-4 mt-4">
                    <div class="card-header p-0">
                        <div class="nav-align-top">
                          <ul class="nav nav-tabs" role="tablist">
                            <li class="nav-item border-end my-1" role="presentation">
                              <button type="button" class="nav-link waves-effect active" role="tab" data-bs-toggle="tab" data-bs-target="#upcoming-leave" aria-controls="upcoming-leave" aria-selected="true" onclick="upcoming_leave();">
                                Upcoming Leave
                              </button>
                            </li>
                            <li class="nav-item  border-end my-1" role="presentation">
                              <button type="button" class="nav-link waves-effect" role="tab" data-bs-toggle="tab" data-bs-target="#approve-leave" aria-controls="approve-leave" aria-selected="false" tabindex="-1" onclick="all_approved_leave();">
                                Approved
                              </button>
                            </li>
                            <li class="nav-item border-end my-1" role="presentation">
                              <button type="button" class="nav-link waves-effect" role="tab" data-bs-toggle="tab" data-bs-target="#rejected-leave" aria-controls="rejected-leave" aria-selected="false" tabindex="-1" onclick="all_rejected_leave();">
                                Rejected
                              </button>
                            </li>
                            {{-- <li class="nav-item my-1" role="presentation">
                              <button type="button" class="nav-link waves-effect" role="tab" data-bs-toggle="tab" data-bs-target="#expired-leave" aria-controls="expired-leave" aria-selected="false" tabindex="-1" onclick="expired_leave();">
                                Expired
                              </button>
                            </li> --}}
                            <span class="tab-slider" style="left: 0px; width: 91.1719px; bottom: 0px;"></span>
                            
                          </ul>
                          
                        </div>
                      </div>
                      <div class="card-body">
                        <div class="tab-content p-0">
                          <div class="tab-pane fade active show" id="upcoming-leave" role="tabpanel">
                            <div class="table-responsive text-nowrap border-bottom h-px-500 overflow-auto">
                              <table class="table">
                                <thead class="table-head-color bg-primary" >
                                  <tr class="" >
                                    <th style="width: 10%;">Employee</th>
                                    <th>Leave Type</th>
                                    <th>From & To</th>
                                    <th>No of days</th>
                                    <th>status</th>
                                    <th style="width: 10%;">Actions</th>
                                  </tr>
                                </thead>
                                <tbody class="table-border-bottom-0 table-body">
                                
                                </tbody>
                              </table>
                            </div>
                          </div>
                          <div class="tab-pane fade" id="approve-leave" role="tabpanel">
                            <div class="table-responsive text-nowrap border-bottom h-px-500 overflow-auto">
                              <table class="table">
                                <thead class="table-head-color bg-primary" >
                                  <tr class="" >
                                    <th style="width: 10%;">Employee</th>
                                    <th>Leave Type</th>
                                    <th>From & To</th>
                                    <th>No of days</th>
                                    <th>status</th>
                                    <th style="width: 10%;">Actions</th>
                                  </tr>
                                </thead>
                                <tbody class="table-border-bottom-0 approve-table-body">
                                  <tr>
                                    <td>
                                      <div class="d-flex align-items-center">
                                        <div class="border rounded-circle w-px-40 h-px-40">
                                          <img src="../assets/img/avatars/1.png" alt="" class="w-px-40 h-px-40 rounded-circle">
                                        </div>
                                        <div>
                                          <span class="fw-medium ms-2">Muhammad Salam</span>
                                        </div>
                                       </div>
                                    </td>
                                    <td>Sick Leave</td>
                                    <td class="text-success">10/12/2023-15/12/2023</td>
                                    <td>04 days</td>
                                    <td><span class="badge rounded-pill bg-label-success me-1">Approved</span></td>
                                  
                                    <td>
                                      <button class="btn p-0"><span class="mdi mdi-square-edit-outline mdi-20px text-primary me-2"></span></button>
                                      <button class="btn p-0"><span class="mdi mdi-trash-can-outline mdi-20px text-danger me-2"></span></button>
                                    </td>
                                  </tr>
                                </tbody>
                              </table>
                            </div>
                          </div>
                          <div class="tab-pane fade" id="rejected-leave" role="tabpanel">
                            <div class="table-responsive text-nowrap border-bottom h-px-500 overflow-auto">
                              <table class="table">
                                <thead class="table-head-color bg-primary" >
                                  <tr class="" >
                                    <th style="width: 10%;">Employee</th>
                                    <th>Leave Type</th>
                                    <th>From & To</th>
                                    <th>No of days</th>
                                    <th>status</th>
                                    <th style="width: 10%;">Actions</th>
                                  </tr>
                                </thead>
                                <tbody class="table-border-bottom-0 rejected-table-body">
                                 
                                </tbody>
                              </table>
                            </div>
                          </div>
                          <div class="tab-pane fade" id="expired-leave" role="tabpanel">
                            <div class="table-responsive text-nowrap border-bottom h-px-500 overflow-auto">
                              <table class="table">
                                <thead class="table-head-color bg-primary" >
                                  <tr class="" >
                                    <th style="width: 10%;">Employee</th>
                                    <th>Leave Type</th>
                                    <th>From & To</th>
                                    <th>No of days</th>
                                    <th>status</th>
                                    <th style="width: 10%;">Actions</th>
                                  </tr>
                                </thead>
                                <tbody class="table-border-bottom-0 expired-table-body">
                                
                                </tbody>
                              </table>
                            </div>
                          </div>
                        </div>
                      </div>
                 </div>
                </div>
              </div>
            </div>

@endsection
@section('css-js')
<script>
function formatDate(dateString) {
    const parts = dateString.split('-');
    const formattedDate = `${parts[2]}/${parts[1]}/${parts[0]}`;
    return formattedDate;
}

    $(document).ready(function () {
      _filter(0);
      upcoming_leave(0);
      
    });

    function _filter(filter_on)
    {

      var  collection = document.getElementsByClassName("filter");
      var arr = {};

      for (let i = 0; i < collection.length; i++) {
        arr[collection[i].name] =  filter_on == 1 ? collection[i].value : '';
      }

      if(filter_on == 0)
      {
        $('.filter').val('');
      } 

      localStorage.setItem('filter', JSON.stringify(arr));

    }

    function upcoming_leave(from)
    {
        // loader(true);

        $.ajax({
            type: "GET",
            url: `{{ url('/api/upcoming-leave') }}?from=${from}&filter=${localStorage.getItem('filter')}`,
            headers: {
                'X-CSRF-TOKEN': '{{csrf_token()}}'
            },
            success: function (response) {
                var all_leaves = response.data.all_leaves;
                console.log(all_leaves);
                var html = ``;
                var count = parseInt(response.count) < 10 ? 1 : parseInt(response.count)/10;
                            count = Math.ceil(count);
                            var pages_btn = ``;
                    
                            pages_btn += `
                            <li class="page-item prev ${response.count == 0 ? 'd-none' : ''}"   onclick="_get(0);" >
                            <a class="page-link waves-effect" href="javascript:void(0);"><i class="tf-icon mdi mdi-chevron-double-left"></i></a>
                    </li>
                                        <li class="page-item prev ${response.count == 0 ? 'd-none' : ''}"  onclick="$('.active').prev('.p-btn').trigger('onclick');" >
                                            <a class="page-link waves-effect" href="javascript:void(0);"><i class="tf-icon mdi mdi-chevron-left"></i></a>
                                        </li>`;
                    
                            $('.p-btn').removeClass('active');

                            var c = 0;
                            for(c = 0; c < count; c++)
                            {
                                if( 
                                (from == (c-3)*10) ||
                                (from == (c-2)*10) ||
                                (from == (c-1)*10) ||
                                (from == (c-0)*10) ||
                                (from == (c+1)*10) ||
                                (from == (c+2)*10) ||
                                (from == (c+3)*10) 
                                )
                                { 
                                    pages_btn += `
                                    <li class="page-item p-btn ${from == c*10 ? 'active' : '' } ${response.count == 0 ? 'd-none' : '' } "   onclick="_get(${c*10});">
                                    <a class="page-link waves-effect" href="javascript:void(0);">${c+1}</a>
                                    </li>
                                    `;
                                }
                            
                            }
                    
                    pages_btn += `
                    
                    <li class="page-item next ${response.count == 0 ? 'd-none' : ''}"  onclick="$('.active').next('.p-btn').trigger('onclick');" >
                            <a class="page-link waves-effect" href="javascript:void(0);"><i class="tf-icon mdi mdi-chevron-right"></i></a>
                    </li>
                    <li class="page-item next ${response.count == 0 ? 'd-none' : ''}"   onclick="_get(${(c-1)*10});" >
                            <a class="page-link waves-effect" href="javascript:void(0);"><i class="tf-icon mdi mdi-chevron-double-right"></i></a>
                    </li>
                    `;
                    
                    
                    $('.pages_btn').html(pages_btn);



                for (var i = 0; i < all_leaves.length; i++) {
                  
                    html += `
                        <tr>
                          <td>
                            <div class="d-flex align-items-center">
                              <div class="border h-px-40 w-px-40 rounded-circle" style="background-image: url('${all_leaves[i].emp_personal_details.image}'); background-size: cover; background-repeat:no-repeat"></div>
                                        <div>
                                          <span class="fw-medium ms-2"> ${all_leaves[i].emp_personal_details ? (all_leaves[i].emp_personal_details.middle_name ? `${all_leaves[i].emp_personal_details.first_name} ${all_leaves[i].emp_personal_details.middle_name} ${all_leaves[i].emp_personal_details.last_name}` : `${all_leaves[i].emp_personal_details.first_name} ${all_leaves[i].emp_personal_details.last_name}`) : ''}</span>
                                        </div>
                                       </div>
                           </td>
                           <td>${all_leaves[i].leave_package ? all_leaves[i].leave_package.title : ''}</td>
                            <td class="text-success">${formatDate(all_leaves[i].from)}-${formatDate(all_leaves[i].to)}</td>
                            <td>${all_leaves[i].total_day ? all_leaves[i].total_day : ''} days</td>
                            <td><span class="badge rounded-pill bg-label-info me-1">Pending</span></td>
                            <td>
                        
                              <button class="btn p-0 reason-btn" data-id="${all_leaves[i].id}" onclick="window.location='/leave-view/${all_leaves[i]?.id}'"><span class="mdi mdi-eye text-primary"></span></button>
                                </td>
                        </tr>`;
                }
                $('.table-body').html(html);

                if (html == ``) {
                    $('.table-body').html(`<tr><td colspan="8" class="text-center">No record found</td></tr>`);
                }

                loader(false);
            },
            error: function (response) {
                loader(false);
                if (response.status == 422) {
                    var errors = response.responseJSON.data;
                    $.each(errors, function (field, messages) {
                        error_msg = messages[0];
                        toastr.error(error_msg);
                    });
                } else if (response.status == 500) {
                    toastr.error("Something went wrong")
                } else {
                    toastr.error(response.responseJSON.message)
                }
            }
        });
    }

    function all_approved_leave(from)
    {
       
        $.ajax({
            type: "GET",
            url: `{{ url('/api/approved-leave') }}?from=${from}&filter=${localStorage.getItem('filter')}`,
            headers: {
                'X-CSRF-TOKEN': '{{csrf_token()}}'
            },
            success: function (response) {
                var approve_leaves = response.data.approve_leaves;
                console.log(approve_leaves);
                var html = ``;
                var count = parseInt(response.count) < 10 ? 1 : parseInt(response.count)/10;
                            count = Math.ceil(count);
                            var pages_btn = ``;
                    
                            pages_btn += `
                            <li class="page-item prev ${response.count == 0 ? 'd-none' : ''}"   onclick="_get(0);" >
                            <a class="page-link waves-effect" href="javascript:void(0);"><i class="tf-icon mdi mdi-chevron-double-left"></i></a>
                    </li>
                                        <li class="page-item prev ${response.count == 0 ? 'd-none' : ''}"  onclick="$('.active').prev('.p-btn').trigger('onclick');" >
                                            <a class="page-link waves-effect" href="javascript:void(0);"><i class="tf-icon mdi mdi-chevron-left"></i></a>
                                        </li>`;
                    
                            $('.p-btn').removeClass('active');

                            var c = 0;
                            for(c = 0; c < count; c++)
                            {
                                if( 
                                (from == (c-3)*10) ||
                                (from == (c-2)*10) ||
                                (from == (c-1)*10) ||
                                (from == (c-0)*10) ||
                                (from == (c+1)*10) ||
                                (from == (c+2)*10) ||
                                (from == (c+3)*10) 
                                )
                                { 
                                    pages_btn += `
                                    <li class="page-item p-btn ${from == c*10 ? 'active' : '' } ${response.count == 0 ? 'd-none' : '' } "   onclick="_get(${c*10});">
                                    <a class="page-link waves-effect" href="javascript:void(0);">${c+1}</a>
                                    </li>
                                    `;
                                }
                            
                            }
                    
                    pages_btn += `
                    
                    <li class="page-item next ${response.count == 0 ? 'd-none' : ''}"  onclick="$('.active').next('.p-btn').trigger('onclick');" >
                            <a class="page-link waves-effect" href="javascript:void(0);"><i class="tf-icon mdi mdi-chevron-right"></i></a>
                    </li>
                    <li class="page-item next ${response.count == 0 ? 'd-none' : ''}"   onclick="_get(${(c-1)*10});" >
                            <a class="page-link waves-effect" href="javascript:void(0);"><i class="tf-icon mdi mdi-chevron-double-right"></i></a>
                    </li>
                    `;
                    
                    
                    $('.pages_btn').html(pages_btn);



                for (var i = 0; i < approve_leaves.length; i++) {
                  
                    html += `
                        <tr>
                          <td>
                            <div class="d-flex align-items-center">
                              <div class="border h-px-40 w-px-40 rounded-circle" style="background-image: url('${approve_leaves[i].emp_personal_details.image}'); background-size: cover; background-repeat:no-repeat"></div>
                                        <div>
                                          <span class="fw-medium ms-2"> ${approve_leaves[i].emp_personal_details ? (approve_leaves[i].emp_personal_details.middle_name ? `${approve_leaves[i].emp_personal_details.first_name} ${approve_leaves[i].emp_personal_details.middle_name} ${approve_leaves[i].emp_personal_details.last_name}` : `${approve_leaves[i].emp_personal_details.first_name} ${approve_leaves[i].emp_personal_details.last_name}`) : ''}</span>
                                        </div>
                                       </div>
                           </td>
                           <td>${approve_leaves[i].leave_package ? approve_leaves[i].leave_package.title : ''}</td>
                            <td class="text-success">${formatDate(approve_leaves[i].from)}-${formatDate(approve_leaves[i].to)}</td>
                            <td>${approve_leaves[i].total_day ? approve_leaves[i].total_day : ''}</td>
                            <td><span class="badge rounded-pill bg-label-success me-1">Approved</span></td>
                            <td>
                        
                              <button class="btn p-0 reason-btn" data-id="${approve_leaves[i].id}" onclick="window.location='/leave-view/${approve_leaves[i]?.id}'"><span class="mdi mdi-eye text-primary"></span></button>
                                </td>
                        </tr>`;
                }
                $('.approve-table-body').html(html);

                if (html == ``) {
                    $('.approve-table-body').html(`<tr><td colspan="8" class="text-center">No record found</td></tr>`);
                }

                loader(false);
            },
            error: function (response) {
                loader(false);
                if (response.status == 422) {
                    var errors = response.responseJSON.data;
                    $.each(errors, function (field, messages) {
                        error_msg = messages[0];
                        toastr.error(error_msg);
                    });
                } else if (response.status == 500) {
                    toastr.error("Something went wrong")
                } else {
                    toastr.error(response.responseJSON.message)
                }
            }
        });
    }
    function all_rejected_leave(from)
    {
        
        $.ajax({
            type: "GET",
            url: `{{ url('/api/rejected-leave') }}?from=${from}&filter=${localStorage.getItem('filter')}`,
            headers: {
                'X-CSRF-TOKEN': '{{csrf_token()}}'
            },
            success: function (response) {
                var rejected_leaves = response.data.rejected_leaves;
                console.log(rejected_leaves);
                var html = ``;
                var count = parseInt(response.count) < 10 ? 1 : parseInt(response.count)/10;
                            count = Math.ceil(count);
                            var pages_btn = ``;
                    
                            pages_btn += `
                            <li class="page-item prev ${response.count == 0 ? 'd-none' : ''}"   onclick="_get(0);" >
                            <a class="page-link waves-effect" href="javascript:void(0);"><i class="tf-icon mdi mdi-chevron-double-left"></i></a>
                    </li>
                                        <li class="page-item prev ${response.count == 0 ? 'd-none' : ''}"  onclick="$('.active').prev('.p-btn').trigger('onclick');" >
                                            <a class="page-link waves-effect" href="javascript:void(0);"><i class="tf-icon mdi mdi-chevron-left"></i></a>
                                        </li>`;
                    
                            $('.p-btn').removeClass('active');

                            var c = 0;
                            for(c = 0; c < count; c++)
                            {
                                if( 
                                (from == (c-3)*10) ||
                                (from == (c-2)*10) ||
                                (from == (c-1)*10) ||
                                (from == (c-0)*10) ||
                                (from == (c+1)*10) ||
                                (from == (c+2)*10) ||
                                (from == (c+3)*10) 
                                )
                                { 
                                    pages_btn += `
                                    <li class="page-item p-btn ${from == c*10 ? 'active' : '' } ${response.count == 0 ? 'd-none' : '' } "   onclick="_get(${c*10});">
                                    <a class="page-link waves-effect" href="javascript:void(0);">${c+1}</a>
                                    </li>
                                    `;
                                }
                            
                            }
                    
                    pages_btn += `
                    
                    <li class="page-item next ${response.count == 0 ? 'd-none' : ''}"  onclick="$('.active').next('.p-btn').trigger('onclick');" >
                            <a class="page-link waves-effect" href="javascript:void(0);"><i class="tf-icon mdi mdi-chevron-right"></i></a>
                    </li>
                    <li class="page-item next ${response.count == 0 ? 'd-none' : ''}"   onclick="_get(${(c-1)*10});" >
                            <a class="page-link waves-effect" href="javascript:void(0);"><i class="tf-icon mdi mdi-chevron-double-right"></i></a>
                    </li>
                    `;
                    
                    
                    $('.pages_btn').html(pages_btn);

                    let totalDays = 0;

                for (var i = 0; i < rejected_leaves.length; i++) {
                  
                    html += `
                        <tr>
                          <td>
                            <div class="d-flex align-items-center">
                              <div class="border h-px-40 w-px-40 rounded-circle" style="background-image: url('${rejected_leaves[i].emp_personal_details.image}'); background-size: cover; background-repeat:no-repeat"></div>
                                        <div>
                                          <span class="fw-medium ms-2"> ${rejected_leaves[i].emp_personal_details ? (rejected_leaves[i].emp_personal_details.middle_name ? `${rejected_leaves[i].emp_personal_details.first_name} ${rejected_leaves[i].emp_personal_details.middle_name} ${rejected_leaves[i].emp_personal_details.last_name}` : `${rejected_leaves[i].emp_personal_details.first_name} ${rejected_leaves[i].emp_personal_details.last_name}`) : ''}</span>
                                        </div>
                                       </div>
                           </td>
                           <td>${rejected_leaves[i].leave_package ? rejected_leaves[i].leave_package.title : ''}</td>
                            <td class="text-success">${formatDate(rejected_leaves[i].from)}-${formatDate(rejected_leaves[i].to)}</td>
                            <td>${rejected_leaves[i].total_day ? rejected_leaves[i].total_day : ''} days</td>
                            <td><span class="badge rounded-pill bg-label-danger me-1">Rejected</span></td>
                            <td>
                        
                              <button class="btn p-0 reason-btn" data-id="${rejected_leaves[i].id}" onclick="window.location='/leave-view/${rejected_leaves[i]?.id}'"><span class="mdi mdi-eye text-primary"></span></button>
                                </td>
                        </tr>`;
                }
                $('.rejected-table-body').html(html);

                if (html == ``) {
                    $('.rejected-table-body').html(`<tr><td colspan="8" class="text-center">No record found</td></tr>`);
                }

                loader(false);
            },
            error: function (response) {
                loader(false);
                if (response.status == 422) {
                    var errors = response.responseJSON.data;
                    $.each(errors, function (field, messages) {
                        error_msg = messages[0];
                        toastr.error(error_msg);
                    });
                } else if (response.status == 500) {
                    toastr.error("Something went wrong")
                } else {
                    toastr.error(response.responseJSON.message)
                }
            }
        });
    }

    function expired_leave(from)
    {
        $.ajax({
            type: "GET",
            url: `{{ url('/api/exipired-leave') }}?from=${from}&filter=${localStorage.getItem('filter')}`,
            headers: {
                'X-CSRF-TOKEN': '{{csrf_token()}}'
            },
            success: function (response) {
                var expired_leaves = response.data.expired_leaves;
                var html = ``;
                var count = parseInt(response.count) < 10 ? 1 : parseInt(response.count)/10;
                            count = Math.ceil(count);
                            var pages_btn = ``;
                    
                            pages_btn += `
                            <li class="page-item prev ${response.count == 0 ? 'd-none' : ''}"   onclick="_get(0);" >
                            <a class="page-link waves-effect" href="javascript:void(0);"><i class="tf-icon mdi mdi-chevron-double-left"></i></a>
                    </li>
                                        <li class="page-item prev ${response.count == 0 ? 'd-none' : ''}"  onclick="$('.active').prev('.p-btn').trigger('onclick');" >
                                            <a class="page-link waves-effect" href="javascript:void(0);"><i class="tf-icon mdi mdi-chevron-left"></i></a>
                                        </li>`;
                    
                            $('.p-btn').removeClass('active');

                            var c = 0;
                            for(c = 0; c < count; c++)
                            {
                                if( 
                                (from == (c-3)*10) ||
                                (from == (c-2)*10) ||
                                (from == (c-1)*10) ||
                                (from == (c-0)*10) ||
                                (from == (c+1)*10) ||
                                (from == (c+2)*10) ||
                                (from == (c+3)*10) 
                                )
                                { 
                                    pages_btn += `
                                    <li class="page-item p-btn ${from == c*10 ? 'active' : '' } ${response.count == 0 ? 'd-none' : '' } "   onclick="_get(${c*10});">
                                    <a class="page-link waves-effect" href="javascript:void(0);">${c+1}</a>
                                    </li>
                                    `;
                                }
                            
                            }
                    
                    pages_btn += `
                    
                    <li class="page-item next ${response.count == 0 ? 'd-none' : ''}"  onclick="$('.active').next('.p-btn').trigger('onclick');" >
                            <a class="page-link waves-effect" href="javascript:void(0);"><i class="tf-icon mdi mdi-chevron-right"></i></a>
                    </li>
                    <li class="page-item next ${response.count == 0 ? 'd-none' : ''}"   onclick="_get(${(c-1)*10});" >
                            <a class="page-link waves-effect" href="javascript:void(0);"><i class="tf-icon mdi mdi-chevron-double-right"></i></a>
                    </li>
                    `;
                    
                    
                    $('.pages_btn').html(pages_btn);

              

                for (var i = 0; i < expired_leaves.length; i++) {
                  
                    html += `
                        <tr>
                          <td>
                            <div class="d-flex align-items-center">
                              <div class="border h-px-40 w-px-40 rounded-circle" style="background-image: url('${expired_leaves[i].emp_personal_details.image}'); background-size: cover; background-repeat:no-repeat"></div>
                                        <div>
                                          <span class="fw-medium ms-2"> ${expired_leaves[i].emp_personal_details ? (expired_leaves[i].emp_personal_details.middle_name ? `${expired_leaves[i].emp_personal_details.first_name} ${expired_leaves[i].emp_personal_details.middle_name} ${expired_leaves[i].emp_personal_details.last_name}` : `${expired_leaves[i].emp_personal_details.first_name} ${expired_leaves[i].emp_personal_details.last_name}`) : ''}</span>
                                        </div>
                                       </div>
                           </td>
                           <td>${expired_leaves[i].leave_package ? expired_leaves[i].leave_package.title : ''}</td>
                            <td class="text-success">${formatDate(expired_leaves[i].from)}-${formatDate(expired_leaves[i].to)}</td>
                            <td>${expired_leaves[i].total_day ? expired_leaves[i].total_day : ''} days</td>
                            <td><span class="badge rounded-pill bg-label-warning me-1">Expired</span></td>
                            <td>
                        
                              <button class="btn p-0 reason-btn" data-id="${expired_leaves[i].id}" onclick="window.location='/leave-view/${expired_leaves[i]?.id}'"><span class="mdi mdi-eye text-primary"></span></button>
                                </td>
                        </tr>`;
                }
                $('.expired-table-body').html(html);

                if (html == ``) {
                    $('.expired-table-body').html(`<tr><td colspan="8" class="text-center">No record found</td></tr>`);
                }

                loader(false);
            },
            error: function (response) {
                loader(false);
                if (response.status == 422) {
                    var errors = response.responseJSON.data;
                    $.each(errors, function (field, messages) {
                        error_msg = messages[0];
                        toastr.error(error_msg);
                    });
                } else if (response.status == 500) {
                    toastr.error("Something went wrong")
                } else {
                    toastr.error(response.responseJSON.message)
                }
            }
        });
    }
</script>

@endsection