@extends('includes/layout')

@section('main-page-content')
<style>
    .loader {
        width: 48px;
        height: 48px;
        border: 5px solid #1A2D4D;
        border-bottom-color: transparent;
        border-radius: 50%;
        display: inline-block;
        box-sizing: border-box;
        animation: rotation 1s linear infinite;
        position: fixed;
        top: 50%;
        left: 50%;
        transform: translate(-50%, -50%);
    }

    @keyframes rotation {
        0% {
            transform: rotate(0deg);
        }

        100% {
            transform: rotate(360deg);
        }
    }
    .employee-checkbox{
width: 15px;
height: 15px;
    }
</style>
<div class="container-xxl flex-grow-1 container-p-y">
    <div class="card">
        <div class="card-header d-flex justify-content-between align-items-center">
            <h5 class="mb-0">Generate Employee Payslips</h5>
            <small class="text-muted float-end">Select employees and month</small>
        </div>
        <div class="card-body">
            @if ($errors->any())
                <div class="alert alert-danger">
                    <ul>
                        @foreach ($errors->all() as $error)
                            <li>{{ $error }}</li>
                        @endforeach
                    </ul>
                </div>
            @endif

                <div class="row mb-4 align-items-end">
                    <div class="col-md-4">
                        <form method="GET" action="{{ route('payroll.select_employees') }}" id="filter-form">
                            <div class="d-flex ">
                                <input type="month" class="form-control me-2" id="month-filter" name="month"
                                    value="{{ $monthFilter }}">
                                <button type="submit" class="btn btn-secondary">Filter</button>
                            </div>
                        </form>
                    </div>
                    <div class="col-md-4">
                        <div class="input-group">
                            <input type="text" class="form-control" id="employee-search" name="employee_search"
                                placeholder="Type employee name..." value="{{ request('employee_search', '') }}"
                                autocomplete="off">
                            @if (request('employee_search'))
                                <button type="button" class="btn btn-outline-secondary" id="clear-search" title="Clear"
                                    onclick="document.getElementById('employee-search').value=''; document.getElementById('filter-form').submit();">
                                    <i class="mdi mdi-close"></i>
                                </button>
                            @endif
                            <button class="btn btn-outline-secondary" type="submit" id="button-search" title="Search">
                                <i class="mdi mdi-magnify"></i>
                            </button>
                        </div>
                    </div>
                    <div class="col-md-4">
                        <button type="button" class="btn btn-primary" onclick="generateSlips()">Generate Selected
                            Payslips</button>
                     {{-- <a href="{{ route('salary.index') }}" class="btn btn-primary">+Salary</a> --}}

                     <button type="button" class="btn btn-danger" onclick="bulkDeletePayslips()" title="Delete Selected">
                        Bulk<i class="mdi mdi-delete"></i>
                    </button>

                    </div>


                </div>


            <form id="generate-payslip-form">
                @csrf
                <input type="hidden" name="month" value="{{ $monthFilter }}">

                <div class="table-responsive text-nowrap">
                    <table class="table table-hover">
                        <thead class="bg-primary text-white">
                            <tr>
                                <th><input class="form-check-input" type="checkbox" style="height: 20px;width:20px;" id="select-all"></th>
                                <th>Employee Name</th>
                                {{-- <th>Salary</th> --}}
                                <th>Status</th>
                                <th>Actions</th>
                            </tr>
                        </thead>
                        <tbody class="table-border-bottom-0">
                            @forelse($empList as $employee)
                            <tr>
                                <td>
                                        <input class="form-check-input employee-checkbox" type="checkbox" name="employee_ids[]" value="{{ $employee->id }}" data-has-salary="{{ $employee->salary ? '1' : '0' }}">
                                </td>
                                <td>
                                    <strong>
                                        {{ $employee->EmpPersonalDetails->first_name ?? '' }}
                                        {{ $employee->EmpPersonalDetails->middle_name ?? '' }}
                                        {{ $employee->EmpPersonalDetails->last_name ?? '' }}
                                    </strong>
                                </td>
                                {{-- <td>{{ $employee->salary ? $employee->salary->basic_salary : 'No salary data' }}</td> --}}
                                <td>
                                    @if($employee->payslip)
                                        <span class="badge {{ $employee->payslip->status ? 'bg-success' : 'bg-danger' }}">
                                            {{ $employee->payslip->status ? 'Paid' : 'Unpaid' }}
                                        </span>
                                    @else
                                        <span class="badge bg-secondary">Not Generated</span>
                                    @endif
                                </td>
                                <td>
                                    @if($employee->payslip)
                                        <div class="d-flex gap-1">
                                            <!-- View Details Button -->
                                            <a style="text-decoration: none" class="btn btn-sm btn-info p-1" 
                                            href="{{ route('payroll.details', $employee->payslip->id) }}" 
                                            title="View Details">
                                                <i class="mdi mdi-eye-outline" style="font-size: 16px;"></i>
                                            </a>

                                            {{-- <!-- Edit Button -->
                                            <a href="{{ route('payroll.edit', $employee->payslip->id) }}" 
                                            class="btn btn-sm btn-dark p-1" 
                                            title="Edit">
                                                <i class="mdi mdi-pencil-outline" style="font-size: 16px"></i>
                                            </a> --}}

                                            <!-- PDF Receipt Button -->
                                            <a style="text-decoration: none" href="#" class="btn btn-sm btn-dark p-1" 
                                                    onclick="loadPayrollReceipt({{ $employee->payslip->id }})" 
                                                    title="Receipt">
                                                <i class="mdi mdi-file-pdf-box" style="font-size: 16px"></i>
                                            </a>

                                            <!-- Status Toggle Button -->
                                            <a class="btn btn-sm btn-{{ $employee->payslip->status ? 'success' : 'danger' }} p-1" 
                                               href="{{ route('payroll.toggleStatus', $employee->payslip->id) }}"
                                               title="{{ $employee->payslip->status ? 'Mark as Unpaid' : 'Mark as Paid' }}">
                                                <i class="mdi mdi-{{ $employee->payslip->status ? 'toggle-switch-off-outline' : 'toggle-switch-outline' }}" style="font-size: 16px"></i>
                                            </a>

                                            <!-- Attendance PDF Button -->
                                            @if ($employee->payslip->attendance_pdf_path)
                                                <a style="text-decoration: none" href="#"
                                                    class="btn btn-sm btn-success p-1"
                                                    onclick="downloadPdf(event)"
                                                    title="Download Attendance PDF"
                                                    data-url="{{ Storage::url($employee->payslip->attendance_pdf_path) }}">
                                                    <i class="mdi mdi-calendar-check" style="font-size: 16px"></i>
                                                </a>
                                            @else
                                                <a style="text-decoration: none" href="#"
                                                    class="btn btn-sm btn-warning p-1"
                                                    onclick="downloadAttendancePdf({{ $employee->payslip->id }})"
                                                    title="Generate Attendance PDF">
                                                    <i class="mdi mdi-calendar-plus" style="font-size: 16px"></i>
                                                </a>
                                            @endif

                                            <!-- Email Receipt Button -->
                                            <a style="text-decoration: none" href="#"
                                                class="btn btn-sm btn-primary p-1"
                                                onclick="sendPayslipEmail({{ $employee->payslip->id }}, '{{ $employee->employee_email ?? '' }}')"
                                                title="Send Payslip Email">
                                        <i class="mdi mdi-send-circle" style="font-size: 16px"></i>

                                            </a>

                                            <!-- Delete Button -->
                                            <button type="button" class="btn btn-sm btn-danger p-1" title="Delete"
                                                onclick="deletePayslip({{ $employee->payslip->id }}, this)">
                                                <i class="mdi mdi-delete"></i>
                                            </button>
                                        </div>
                                    @else
                                        <!-- Generate Payslip Button -->
                                        <a href="javascript:void(0);" 
                                           class="btn btn-sm btn-primary p-1" 
                                           onclick="generateSlips({{ $employee->id }})" 
                                           title="Generate Payslip">
                                            <i class="mdi mdi-file-document-outline" style="font-size: 16px"></i>
                                        </a>
                                    @endif
                                </td>
                            </tr>
                            @empty
                            <tr>
                                <td colspan="4" class="text-center">No employees found.</td>
                            </tr>
                            @endforelse
                        </tbody>
                    </table>
                </div>
            </form>
        </div>
    </div>
</div>

<div class="modal fade" id="pdfModal" tabindex="-1" aria-labelledby="pdfModalLabel" aria-hidden="true">
    <div class="modal-dialog modal-xl">
        <div class="modal-content">
            <div class="modal-header">
                <h5 class="modal-title" id="pdfModalLabel">Payroll Receipt</h5>
                <button type="button" class="btn-close" data-bs-dismiss="modal" aria-label="Close"></button>
            </div>
            <div class="modal-body">
                <div id="pdfPlaceholder" style="width: 100%; height: 650px;"></div>
            </div>
            <div class="modal-footer">
                <button type="button" class="btn btn-secondary" data-bs-dismiss="modal">Close</button>
            </div>
        </div>
    </div>
</div>

<span class="loader" style="display:none;"></span>
@endsection

@section('css-js')
<script src="https://cdnjs.cloudflare.com/ajax/libs/jspdf/2.4.0/jspdf.umd.min.js"></script>
<script src="https://cdnjs.cloudflare.com/ajax/libs/html2canvas/1.4.1/html2canvas.min.js"></script>
<script>
    document.addEventListener('DOMContentLoaded', function() {
        const selectAllCheckbox = document.getElementById('select-all');
        if(selectAllCheckbox) {
            selectAllCheckbox.addEventListener('click', function(event) {
                const checkboxes = document.querySelectorAll('.employee-checkbox');
                checkboxes.forEach(function(checkbox) {
                    checkbox.checked = event.target.checked;
                });
            });
        }
    });

function generateSlips(employeeId = null) {
    const form = document.getElementById('generate-payslip-form');
    const monthFilter = document.getElementById('month-filter').value;
    const action = "{{ route('generate.selectedemp') }}";
    
    if (!monthFilter) {
        alert('Please select a month first.');
        return;
    }

    const formData = new FormData();
    formData.append('month', monthFilter);

    let selectedCheckboxes;
    if (employeeId) {
        // Find the checkbox for this employeeId
        const checkbox = document.querySelector('.employee-checkbox[value="' + employeeId + '"]');
        if (checkbox && checkbox.getAttribute('data-has-salary') === '0') {
            toastr.error('Please set of this month salary first for this employee.');
            return;
        }
        formData.append('employee_ids[]', employeeId);
    } else {
        selectedCheckboxes = document.querySelectorAll('.employee-checkbox:checked');
        if (selectedCheckboxes.length === 0) {
            alert('Please select at least one employee to generate a payslip for.');
            return;
        }
        if (selectedCheckboxes.length === 1) {
            const checkbox = selectedCheckboxes[0];
            if (checkbox.getAttribute('data-has-salary') === '0') {
                toastr.error('Please set salary of this month first for this employee.');
                return;
            }
        }
        // Add all selected employee IDs
        selectedCheckboxes.forEach(checkbox => {
            formData.append('employee_ids[]', checkbox.value);
        });
    }

    document.querySelector('.loader').style.display = 'block';

    fetch(action, {
        method: 'POST',
        body: formData,
        headers: {
            'X-CSRF-TOKEN': '{{ csrf_token() }}',
            'Accept': 'application/json',
        }
    })
    .then(response => {
        document.querySelector('.loader').style.display = 'none';
        if (response.ok) {
            return response.json();
        }
        // Check if response is JSON
        const contentType = response.headers.get('content-type');
        if (contentType && contentType.includes('application/json')) {
            return response.json().then(data => {
                throw new Error(data.message || 'An error occurred while generating payslips.');
            });
        } else {
            throw new Error('Server returned an invalid response. Please try again.');
        }
    })
    .then(data => {
        if(data.success) {
            toastr.success(data.message);
            setTimeout(() => {
            window.location.reload();
            }, 1500);
        } else {
            toastr.error(data.message || 'An unknown error occurred.');
        }
    })
    .catch(error => {
        document.querySelector('.loader').style.display = 'none';
        console.error('Error:', error);
        
        // Handle different types of errors
        if (error.name === 'TypeError' && error.message.includes('JSON')) {
            toastr.error('Server returned an invalid response. Please check your connection and try again.');
        } else {
            toastr.error(error.message || 'An unexpected error occurred. Please try again.');
        }
    });
}

    function loadPayrollReceipt(payrollId) {
        document.querySelector('.loader').style.display = 'block';
        // Check if PDF exists
        fetch(`/payroll/${payrollId}/receipt`)
            .then(response => response.json())
            .then(data => {
                if (data.payroll && data.payroll.pdf_path) {
                    // PDF exists, trigger download
                    const pdfUrl = `/storage/${data.payroll.pdf_path}`;
                    const link = document.createElement('a');
                    link.href = pdfUrl;
                    link.target = '_blank';  // Open in a new tab
                    document.body.appendChild(link);
                    link.click();
                    document.body.removeChild(link);
                    document.querySelector('.loader').style.display = 'none';
                } else {
                    // PDF does not exist, generate and upload as before
                    const payroll = data.payroll;
                    const fines = data.fines;
                    const employe = payroll.employee;
                    const monthNames = [
                        "January", "February", "March", "April", "May", "June",
                        "July", "August", "September", "October", "November", "December"
                    ];
                    const monthName = monthNames[payroll.pay_month - 1];
                    generatePdf(payroll, fines, employe, monthName, true); // true = upload after generation
                }
            })
            .catch(error => {
                console.error('Error loading the payroll data:', error);
                document.querySelector('.loader').style.display = 'none';
            });
    }

    function formatTime(totalMinutes) {
        const hours = Math.floor(totalMinutes / 60);
        const minutes = totalMinutes % 60;
        return `${hours}:${minutes.toString().padStart(2, '0')}`;
    }

    function generatePdf(payroll, fines, employee, monthName, uploadAfter = false) {
        let finesTotal = 0;
        let bonusesTotal = 0;

        let finesContent = `
<table style="width: 100%; border-collapse: collapse; margin-top: 20px;">
    <thead>
        <tr style="background-color: #f2f2f2;">
            <th style="border: 1px solid #ddd; padding: 18px; text-align: left; font-size: 18px;">Reason</th>
            <th style="border: 1px solid #ddd; padding: 18px; text-align: left; font-size: 18px;">Date</th>
            <th style="border: 1px solid #ddd; padding: 18px; text-align: right; font-size: 18px;">Amount</th>
            <th style="border: 1px solid #ddd; padding: 18px; text-align: right; font-size: 18px;">Type</th>
        </tr>
    </thead>
    <tbody>
`;

fines.forEach(fine => {
        let amount = fine.fine_amount.toFixed(2);
        let typeDescription = fine.type === 1 ? 'Bonus' : 'Fine';
        if (fine.type === 1) {
            bonusesTotal += parseFloat(amount);
        } else {
            finesTotal += parseFloat(amount);
        }

        const fineDate = new Date(fine.date);
        const day = fineDate.getDate().toString().padStart(2, '0');
        const month = (fineDate.getMonth() + 1).toString().padStart(2, '0');
        const year = fineDate.getFullYear();
        const formattedDate = `${day}-${month}-${year}`;

        finesContent += `
        <tr>
            <td style="border: 1px solid #ddd; padding: 18px; font-size: 18px;">${fine.fine_reason}</td>
            <td style="border: 1px solid #ddd; padding: 18px; font-size: 18px;">${formattedDate}</td>
            <td style="border: 1px solid #ddd; padding: 18px; text-align: right; font-size: 18px;">${amount}</td>
            <td style="border: 1px solid #ddd; padding: 18px; text-align: right; font-size: 18px;">${typeDescription}</td>
        </tr>
        `;
    });

        finesContent += `
    </tbody>
    <tfoot>
        <tr>
            <td style="border: 1px solid #ddd; padding: 18px; font-weight: bold; font-size: 18px;">Total Fines/Bonuses</td>
            <td style="border: 1px solid #ddd; padding: 18px; text-align: right; font-weight: bold; font-size: 18px;" colspan="3">Fines: ${finesTotal.toFixed(2)}, Bonuses: ${bonusesTotal.toFixed(2)}</td>
        </tr>
    </tfoot>
</table>
`;

        const adjustedSalary = payroll.calculated_salary - finesTotal + bonusesTotal;

        const content = `
<div style="font-family: 'Helvetica Neue', Helvetica, Arial, sans-serif; color: #333; padding: 50px; margin: auto; width: 100%; box-sizing: border-box;">
     <header style="display: flex; justify-content: space-between; align-items: center; margin-bottom: 50px;">
        <div>
            <h1 style="margin: 0; font-size: 40px; color: #214F70;">Payroll Receipt</h1>
            <p style="margin: 10px 0 0 0; font-size: 24px; color: #777;">${monthName}, ${payroll.pay_year}</p>
        </div>
        <img src="/gtech-logo.jpeg" alt="G-Tech Solutions Logo" style="width: 150px; height: auto;">
    </header>
    <section style="margin-bottom: 50px;">
        <div style="display: flex; justify-content: space-between; margin-bottom: 30px; flex-wrap: wrap;">
            <div style="flex: 1; min-width: 300px; margin-right: 20px;">
                <h2 style="font-size: 28px; margin: 0 0 15px 0;">Employee Details</h2>
                <p style="margin: 0; line-height: 1.8; font-size: 22px;">
                    <strong>Name:</strong> ${employee.first_name || ''} ${employee.middle_name || ''} ${employee.last_name || ''}<br>
                    <strong>Mobile:</strong> ${employee.mobile}<br>
                    <strong>Required Hours:</strong> ${payroll.working_hours / 60}<br>
                </p>
            </div>
            <div style="flex: 1; min-width: 300px;">
                <h2 style="font-size: 28px; margin: 0 0 15px 0;">Salary Details</h2>
                <p style="margin: 0; line-height: 1.8; font-size: 22px;">
                    <strong>Basic Salary:</strong> ${payroll.basic_salary.toFixed(2)}<br>
                    <strong>Hours Worked:</strong> ${formatTime(payroll.actual_working_hours)}<br>
                    <strong>Over Time Hours:</strong> ${formatTime(payroll.overtime_hours)}<br>
                    <strong>Total Hours Worked:</strong> ${formatTime(payroll.hours_spent)}<br>
                    <strong>Approved Leaves:</strong> ${payroll.approvedLeave || 0}<br>
                    <strong>Approved Leave Hours:</strong> ${payroll.approved_leave_hours || 0}<br>
                    <strong>Calculated Salary:</strong> ${payroll.calculated_salary.toFixed(2)}
                </p>
            </div>
        </div>
    </section>
    <section>
        <h2 style="font-size: 30px; border-bottom: 4px solid #214F70; padding-bottom: 16px; margin-bottom: 30px;">Fines and Bonuses</h2>
        ${finesContent}
        <div style="margin-top: 30px; text-align: right;">
            <p style="font-size: 24px;"><strong>Adjusted Salary:</strong> ${adjustedSalary.toFixed(2)}</p>
        </div>
    </section>
    <footer style="text-align: center; margin-top: 50px; font-size: 18px; color: #777;">
        &copy; ${new Date().getFullYear()} G-TECH SOLUTIONS. All rights reserved.
    </footer>
</div>
`;

        const element = document.createElement('div');
        element.innerHTML = content;
        document.body.appendChild(element);

        html2canvas(element, {
            scale: 3
        }).then(canvas => {
            const imgData = canvas.toDataURL('image/png');
            const pdf = new jspdf.jsPDF({
                orientation: 'portrait',
                unit: 'pt',
                format: 'a4'
            });

            const imgProps = pdf.getImageProperties(imgData);
            const pdfWidth = pdf.internal.pageSize.getWidth();
            const pdfHeight = (imgProps.height * pdfWidth) / imgProps.width;

            pdf.addImage(imgData, 'PNG', 0, 0, pdfWidth, pdfHeight, undefined, 'FAST');

            const pdfFrame = document.createElement('iframe');
            pdfFrame.style.width = '100%';
            pdfFrame.style.height = '100%';
            pdfFrame.src = pdf.output('bloburl');
            const pdfPlaceholder = document.getElementById('pdfPlaceholder');
            if(pdfPlaceholder) {
                pdfPlaceholder.innerHTML = '';
                pdfPlaceholder.appendChild(pdfFrame);
            }
            
            const pdfModal = document.getElementById('pdfModal');
            if(pdfModal) {
                new bootstrap.Modal(pdfModal).show();
            }

            document.body.removeChild(element);
            document.querySelector('.loader').style.display = 'none';

            // Only upload if requested (i.e., PDF did not exist)
            if (uploadAfter) {
                const pdfBlob = pdf.output('blob');
                const formData = new FormData();
                formData.append('pdf', pdfBlob, 'payslip.pdf');
                formData.append('_token', '{{ csrf_token() }}');
                fetch(`/payroll/${payroll.id}/save-pdf`, {
                    method: 'POST',
                    body: formData,
                })
                .then(response => response.json())
                .then(data => {
                    if (data.success) {
                        toastr.success('Payslip PDF saved successfully!');
                        // Reload to show the download button

                    }
                });
            }
        }).catch(error => {
            console.error('Error generating PDF:', error);
            document.body.removeChild(element);
            document.querySelector('.loader').style.display = 'none';
        });
    }

    function downloadAttendancePdf(payrollId) {
        document.querySelector('.loader').style.display = 'block';
        fetch(`/payroll/${payrollId}/attendance-pdf`)
            .then(response => {
                if (!response.ok) throw new Error('PDF not found or error generating PDF');
                // Directly use the URL if no blob is required
                return response.url; 
            })
            .then(url => {
                // Open the PDF in a new tab
                const link = document.createElement('a');
                link.href = url;
                link.target = '_blank'; // Open in a new tab
                document.body.appendChild(link);
                link.click();
                document.body.removeChild(link);

                document.querySelector('.loader').style.display = 'none';

                // Reload the page to update the button state
                toastr.success('Attendance PDF generated successfully!');
                setTimeout(() => {
                    window.location.reload();
                }, 1500);
            })
            .catch(error => {
                document.querySelector('.loader').style.display = 'none';
                toastr.error('Could not generate/download attendance PDF.');
                console.error(error);
            });
    }
    
    function downloadPdf(event) {
        event.preventDefault(); // Stop the link from navigating
        const button = event.target.closest('a');
        const fileUrl = button.getAttribute('data-url');

        if (fileUrl) {
            // Create a temporary link to open the file in a new tab
            const link = document.createElement('a');
            link.href = fileUrl;
            link.target = '_blank';  // Open in a new tab
            document.body.appendChild(link);
            link.click();
            document.body.removeChild(link);
        } else {
            toastr.error('No attendance PDF available for this employee.');
        }
    }

    function sendPayslipEmail(payrollId, email) {
        if (!email) {
            toastr.error('No email address found for this employee.');
            return;
        }
        
        // Use SweetAlert2 instead of basic confirm
        Swal.fire({
            title: 'Send Payslip Email?',
            text: `Send payslip receipt to ${email}?`,
            icon: 'question',
            showCancelButton: true,
            confirmButtonColor: '#3085d6',
            cancelButtonColor: '#d33',
            confirmButtonText: 'Yes, send it!',
            cancelButtonText: 'Cancel'
        }).then((result) => {
            if (result.isConfirmed) {
                document.querySelector('.loader').style.display = 'block';

                fetch(`/payroll/${payrollId}/send-receipt-email`, {
                    method: 'POST',
                    headers: {
                        'X-CSRF-TOKEN': '{{ csrf_token() }}',
                        'Accept': 'application/json',
                    }
                })
                .then(response => response.json())
                .then(data => {
                    document.querySelector('.loader').style.display = 'none';
                    if (data.success) {
                        Swal.fire(
                            'Sent!',
                            'Payslip email sent successfully!',
                            'success'
                        );
                    } else {
                        Swal.fire(
                            'Error!',
                            data.message || 'Failed to send payslip email.',
                            'error'
                        );
                    }
                })
                .catch(error => {
                    document.querySelector('.loader').style.display = 'none';
                    Swal.fire(
                        'Error!',
                        'Error sending payslip email.',
                        'error'
                    );
                    console.error(error);
                });
            }
        });
    }

function deletePayslip(payslipId, btn) {
    Swal.fire({
        title: 'Are you sure?',
        text: "You won't be able to revert this!",
        icon: 'warning',
        showCancelButton: true,
        confirmButtonColor: '#3085d6',
        cancelButtonColor: '#d33',
        confirmButtonText: 'Yes, delete it!'
    }).then((result) => {
        if (result.isConfirmed) {
            $.ajax({
                url: "{{ url('payroll') }}/" + payslipId,
                method: 'DELETE',
                headers: {
                    'X-CSRF-TOKEN': '{{ csrf_token() }}',
                    'Accept': 'application/json'
                },
                success: function(data) {
                    if (data.success || data.message === 'Payroll and related fines deleted successfully.') {
                        toastr.success('Payslip deleted successfully!');
                        // Optionally remove the row from the table:
                        const row = btn.closest('tr');
                        if (row) row.remove();
                        setTimeout(() => {
                            window.location.reload();
                        }, 1000);
                    } else {
                        toastr.error(data.message || 'Failed to delete payslip.');
                    }
                },
                error: function() {
                    toastr.error('An error occurred while deleting the payslip.');
                }
            });
        }
    });
}

function bulkDeletePayslips() {
    const selectedCheckboxes = document.querySelectorAll('.employee-checkbox:checked');
    if (selectedCheckboxes.length === 0) {
        toastr.error('Please select at least one employee to delete payslips for.');
        return;
    }

    Swal.fire({
        title: 'Are you sure?',
        text: "This will delete payslips for the selected employees. This action cannot be undone!",
        icon: 'warning',
        showCancelButton: true,
        confirmButtonColor: '#d33',
        cancelButtonColor: '#3085d6',
        confirmButtonText: 'Yes, delete them!'
    }).then((result) => {
        if (result.isConfirmed) {
            const employeeIds = Array.from(selectedCheckboxes).map(cb => cb.value);
            document.querySelector('.loader').style.display = 'block';

            fetch("{{ route('payroll.bulk_delete') }}", {
                method: 'POST',
                headers: {
                    'X-CSRF-TOKEN': '{{ csrf_token() }}',
                    'Content-Type': 'application/json',
                    'Accept': 'application/json'
                },
                body: JSON.stringify({ employee_ids: employeeIds, month: document.getElementById('month-filter').value })
            })
            .then(response => response.json())
            .then(data => {
                document.querySelector('.loader').style.display = 'none';
                if (data.success) {
                    toastr.success(data.message || 'Payslips deleted successfully!');
                    setTimeout(() => window.location.reload(), 1000);
                } else {
                    toastr.error(data.message || 'Failed to delete payslips.');
                }
            })
            .catch(error => {
                document.querySelector('.loader').style.display = 'none';
                toastr.error('An error occurred while deleting payslips.');
                console.error(error);
            });
        }
    });
}

</script>
@endsection