@extends('includes/layout')

@section('main-page-content')
    <style>
        .loader {
            width: 48px;
            height: 48px;
            border: 5px solid #1A2D4D;
            border-bottom-color: transparent;
            border-radius: 50%;
            display: inline-block;
            box-sizing: border-box;
            animation: rotation 1s linear infinite;
            position: fixed;
            top: 50%;
            left: 50%;
            transform: translate(-50%, -50%);
        }

        @keyframes rotation {
            0% {
                transform: rotate(0deg);
            }

            100% {
                transform: rotate(360deg);
            }
        }
    </style>
    <div class="container-xxl flex-grow-1 container-p-y">
        <div class="card mb-4">
            <div class="card-body">
                <div class="d-flex justify-content-between align-items-center">
                    <div>
                        <div class="h4 pb-0 mb-0">Payroll</div>
                        <small>Dashboard - Payroll</small>
                    </div>
                    <div>
                        <a href="{{ route('payroll.select_employees') }}" class="btn btn-primary">
                            <i class="fas fa-file-invoice-dollar" style="margin-right: 5px;"></i> Create Pay slip
                        </a>
                    </div>

                    {{-- <div>
                        @if (in_array('Sites Maintain', Session::get('permissions')))
                            <button class="btn btn-primary" onclick="window.location='{{ route('payroll.create') }}'"><span
                                    class="mdi mdi-plus"></span>Add Pay Roll</button>
                        @endif
                    </div> --}}
                </div>
                <form method="GET" action="{{ route('payroll.index') }}" class="mt-3">
                    <div class="row">
                        <div class="col-md-3 mb-3">
                            <label>Employee</label>
                            <select class="form-control" name="employee">
                                <option value="">Select Employee</option>
                                @foreach ($get_employees as $employee)
                                    <option value="{{ $employee->id }}"
                                        {{ ($filters['employee'] ?? '') == $employee->id ? 'selected' : '' }}>
                                        {{ $employee->EmpPersonalDetails->first_name }}
                                        {{ $employee->EmpPersonalDetails->middle_name }}
                                        {{ $employee->EmpPersonalDetails->last_name }}
                                    </option>
                                @endforeach
                            </select>
                        </div>


                        <div class="col-md-3 mb-3">
                            <label>Year</label>
                            <select name="pay_year" id="pay_year" class="form-control">
                                <option value="">Select Year</option>
                                @php
                                    $currentYear = now()->year;
                                    $earliestYear = $currentYear - 10;
                                @endphp
                                @for ($year = $currentYear; $year > $earliestYear; $year--)
                                    <option value="{{ $year }}"
                                        {{ ($filters['pay_year'] ?? '') == $year ? 'selected' : '' }}>{{ $year }}
                                    </option>
                                @endfor
                            </select>
                        </div>

                        <div class="col-md-3 mb-3">
                            <label>Month</label>
                            <select name="pay_month" class="form-control">
                                <option value="">Select Month</option>
                                @foreach (range(1, 12) as $month)
                                    <option value="{{ $month }}"
                                        {{ isset($filters['pay_month']) && $filters['pay_month'] == $month ? 'selected' : '' }}>
                                        {{ date('F', mktime(0, 0, 0, $month, 1)) }}
                                    </option>
                                @endforeach
                            </select>
                        </div>
                        <div class="col-md-3 mb-3">
                            <label>Status</label>
                            <select name="status" class="form-control">
                                <option value="">Select Status</option>
                                <option value="1"
                                    {{ isset($filters['status']) && $filters['status'] == '1' ? 'selected' : '' }}>
                                    Paid
                                </option>
                                <option value="0"
                                    {{ isset($filters['status']) && $filters['status'] == '0' ? 'selected' : '' }}>Unpaid
                                </option>
                            </select>
                        </div>
                        <div class="col-md-12 text-end">
                            <button type="submit" class="btn btn-secondary">Filter</button>
                            <a href="{{ route('payroll.index') }}" class="btn btn-danger">Reset</a>
                        </div>
                    </div>
                </form>
                <div class="table-responsive text-nowrap mt-3">
                    <table class="table">
                        <thead class="bg-primary text-white">
                            <tr>
                                <th>Employee</th>
                                <th>Year</th>
                                <th>Month</th>
                                <th>Working Hours</th>
                                <th>Over Time</th>
                                <th>Total Hours Spent</th>
                                {{-- <th>Basic Salary</th>
                                <th>Calculated Salary</th>
                                <th>Adjusted Salary</th> --}}
                                <th>Status</th>
                                <th>Actions</th>
                            </tr>
                        </thead>
                        <tbody>
                            @forelse ($payrolls as $payroll)
                                <tr>
                                    <td>{{ $payroll->employee ? trim($payroll->employee->first_name . ' ' . ($payroll->employee->middle_name ?? '') . ' ' . $payroll->employee->last_name) : 'N/A' }}
                                    </td>
                                    <td>{{ $payroll->pay_year }}</td>
                                    <td>{{ date('F', mktime(0, 0, 0, $payroll->pay_month, 1)) }}</td>
                                    <td>@php echo floor($payroll->working_hours/60) . ':' . sprintf('%02d', $payroll->working_hours % 60); @endphp</td>
                                    <td>@php echo floor($payroll->overtime_hours/60) . ':' . sprintf('%02d', $payroll->overtime_hours % 60); @endphp</td>
                                    <td>@php echo floor($payroll->hours_spent/60) . ':' . sprintf('%02d', $payroll->hours_spent % 60); @endphp</td>
                                    {{-- <td>{{ $payroll->basic_salary }}</td>

                                    <td>{{ $payroll->calculated_salary }}</td>
                                    <td>{{ $payroll->calculated_salary - $payroll->total_fines }}</td> --}}
                                    <td>
                                        <span class="badge {{ $payroll->status ? 'bg-success' : 'bg-danger' }}">
                                            {{ $payroll->status ? 'Paid' : 'Unpaid' }}
                                        </span>
                                    </td>
                                    <td>
                                        <div class="dropdown">
                                            <button class="btn btn-secondary btn-sm dropdown-toggle" style="width: 0px; background-color: transparent; color: black; border: transparent;" type="button"
                                                id="dropdownMenuButton" data-bs-toggle="dropdown" aria-expanded="false">
                                                <i class="mdi mdi-dots-vertical"></i>
                                            </button>
                                            <ul class="dropdown-menu" aria-labelledby="dropdownMenuButton">
                                                {{-- <li><a class="dropdown-item"
                                                        href="{{ route('payroll.edit', $payroll->id) }}">Edit</a></li> --}}
                                                <li>
                                                    <form method="POST"
                                                        action="{{ route('payroll.destroy', $payroll->id) }}"
                                                        style="display:inline;">
                                                        @csrf
                                                        @method('DELETE')
                                                        <button type="button" class="dropdown-item"
                                                            onclick="confirmDeletion(event, this)">Delete</button>
                                                    </form>
                                                </li>

                                                <li>
                                                    <a href="#" class="dropdown-item"
                                                        onclick="loadPayrollReceipt({{ $payroll->id }})">
                                                        Receipt
                                                    </a>

                                                </li>
                                                <li>
                                                    @if ($payroll->status == 1)
                                                        <a class="dropdown-item"
                                                            href="{{ route('payroll.toggleStatus', $payroll->id) }}">
                                                            <i class="mdi mdi-toggle-switch-off-outline"></i> Unpaid
                                                        </a>
                                                    @else
                                                        <a class="dropdown-item"
                                                            href="{{ route('payroll.toggleStatus', $payroll->id) }}">
                                                            <i class="mdi mdi-toggle-switch"></i> Paid
                                                        </a>
                                                    @endif
                                                </li>
                                            </ul>
                                        </div>
                                    </td>

                                </tr>
                            @empty
                                <tr>
                                    <td colspan="8" class="text-center">No payrolls found.</td>
                                </tr>
                            @endforelse
                        </tbody>
                    </table>
                </div>
                <div class="mt-3">
                    {{ $payrolls->links() }}
                </div>
            </div>
        </div>
    </div>
    <div class="modal fade" id="pdfModal" tabindex="-1" aria-labelledby="pdfModalLabel" aria-hidden="true">
        <div class="modal-dialog modal-xl">
            <div class="modal-content">
                <div class="modal-header">
                    <h5 class="modal-title" id="pdfModalLabel">Payroll Receipt</h5>
                    <button type="button" class="btn-close" data-bs-dismiss="modal" aria-label="Close"></button>
                </div>
                <div class="modal-body">
                    <div id="pdfPlaceholder" style="width: 100%; height: 650px;"></div>
                </div>
                <div class="modal-footer">
                    <button type="button" class="btn btn-secondary" data-bs-dismiss="modal">Close</button>
                </div>
            </div>
        </div>
    </div>

    <script src="https://cdnjs.cloudflare.com/ajax/libs/jspdf/2.4.0/jspdf.umd.min.js"></script>
    <script src="https://cdnjs.cloudflare.com/ajax/libs/html2canvas/1.4.1/html2canvas.min.js"></script>
    <span class="loader" style="display:none;"></span>
@endsection
@section('css-js')

<script>
        function confirmDeletion(event, element) {
            event.preventDefault(); // Prevent the default form submission on button click

            Swal.fire({
                title: 'Are you sure?',
                text: "You won't be able to revert this!",
                icon: 'warning',
                showCancelButton: true,
                confirmButtonColor: '#3085d6',
                cancelButtonColor: '#d33',
                confirmButtonText: 'Yes, delete it!'
            }).then((result) => {
                if (result.isConfirmed) {
                    // If the user confirms, submit the form programmatically
                    element.closest('form').submit(); // Corrected this line
                }
            });
        }
    </script>
    <script>
        function loadPayrollReceipt(payrollId) {
            document.querySelector('.loader').style.display = 'block';

            const url = `/payroll/${payrollId}/receipt`;

            fetch(url)
                .then(response => response.json())
                .then(data => {
                    const payroll = data.payroll;
                    const fines = data.fines;
                    const employe = payroll.employee;
                    const monthNames = [
                        "January", "February", "March", "April", "May", "June",
                        "July", "August", "September", "October", "November", "December"
                    ];
                    const monthName = monthNames[payroll.pay_month - 1];
                    generatePdf(payroll, fines, employe, monthName);
                })
                .catch(error => {
                    console.error('Error loading the payroll data:', error);
                    // Hide loader if error
                    document.querySelector('.loader').style.display = 'none';
                });
        }

        function formatTime(totalMinutes) {
  const hours = Math.floor(totalMinutes / 60);
  const minutes = totalMinutes % 60;
  return `${hours}:${minutes.toString().padStart(2, '0')}`;
}

        function generatePdf(payroll, fines, employee, monthName) {
            let finesTotal = 0;
            let bonusesTotal = 0;

            let finesContent = `
<table style="width: 100%; border-collapse: collapse; margin-top: 20px;">
    <thead>
        <tr style="background-color: #f2f2f2;">
            <th style="border: 1px solid #ddd; padding: 18px; text-align: left; font-size: 18px;">Reason</th>
            <th style="border: 1px solid #ddd; padding: 18px; text-align: left; font-size: 18px;">Date</th>
            <th style="border: 1px solid #ddd; padding: 18px; text-align: right; font-size: 18px;">Amount</th>
            <th style="border: 1px solid #ddd; padding: 18px; text-align: right; font-size: 18px;">Type</th>
        </tr>
    </thead>
    <tbody>
`;

fines.forEach(fine => {
        let amount = fine.fine_amount.toFixed(2);
        let typeDescription = fine.type === 1 ? 'Bonus' : 'Fine';
        if (fine.type === 1) {
            bonusesTotal += parseFloat(amount); // Sum bonuses
        } else {
            finesTotal += parseFloat(amount); // Sum fines
        }
    
        // Format the date from fine.date to dd-mm-yyyy
        const fineDate = new Date(fine.date);
        const day = fineDate.getDate().toString().padStart(2, '0');
        const month = (fineDate.getMonth() + 1).toString().padStart(2, '0'); // Months are zero-indexed
        const year = fineDate.getFullYear();
        const formattedDate = `${day}-${month}-${year}`;
    
        finesContent += `
        <tr>
            <td style="border: 1px solid #ddd; padding: 18px; font-size: 18px;">${fine.fine_reason}</td>
            <td style="border: 1px solid #ddd; padding: 18px; font-size: 18px;">${formattedDate}</td>
            <td style="border: 1px solid #ddd; padding: 18px; text-align: right; font-size: 18px;">${amount}</td>
            <td style="border: 1px solid #ddd; padding: 18px; text-align: right; font-size: 18px;">${typeDescription}</td>
        </tr>
        `;
    });

            finesContent += `
    </tbody>
    <tfoot>
        <tr>
            <td style="border: 1px solid #ddd; padding: 18px; font-weight: bold; font-size: 18px;">Total Fines/Bonuses</td>
            <td style="border: 1px solid #ddd; padding: 18px; text-align: right; font-weight: bold; font-size: 18px;">Fines: ${finesTotal.toFixed(2)}, Bonuses: ${bonusesTotal.toFixed(2)}</td>
            <td></td>
        </tr>
    </tfoot>
</table>
`;

            const adjustedSalary = payroll.calculated_salary - finesTotal + bonusesTotal;

            const content = `
<div style="font-family: 'Helvetica Neue', Helvetica, Arial, sans-serif; color: #333; padding: 50px; margin: auto; width: 100%; box-sizing: border-box;">
     <header style="display: flex; justify-content: space-between; align-items: center; margin-bottom: 50px;">
        <div>
            <h1 style="margin: 0; font-size: 40px; color: #214F70;">Payroll Receipt</h1>
            <p style="margin: 10px 0 0 0; font-size: 24px; color: #777;">${monthName}, ${payroll.pay_year}</p>
        </div>
        <img src="/gtech-logo.jpeg" alt="G-Tech Solutions Logo" style="width: 150px; height: auto;">
    </header>
    <section style="margin-bottom: 50px;">
        <div style="display: flex; justify-content: space-between; margin-bottom: 30px; flex-wrap: wrap;">
            <div style="flex: 1; min-width: 300px; margin-right: 20px;">
                <h2 style="font-size: 28px; margin: 0 0 15px 0;">Employee Details</h2>
                <p style="margin: 0; line-height: 1.8; font-size: 22px;">
                    <strong>Name:</strong> ${employee.first_name || ''} ${employee.middle_name || ''} ${employee.last_name || ''}<br>
                    <strong>Mobile:</strong> ${employee.mobile}<br>
                    <strong>Required Hours:</strong> ${payroll.working_hours / 60}<br>
                </p>
            </div>
            <div style="flex: 1; min-width: 300px;">
                <h2 style="font-size: 28px; margin: 0 0 15px 0;">Salary Details</h2>
                <p style="margin: 0; line-height: 1.8; font-size: 22px;">
                    <strong>Basic Salary:</strong> ${payroll.basic_salary.toFixed(2)}<br>
                 <strong>Hours Worked:</strong> ${formatTime(payroll.actual_working_hours)}<br>
                <strong>Over Time Hours:</strong> ${formatTime(payroll.overtime_hours)}<br>
                <strong>Total Hours Worked:</strong> ${formatTime(payroll.hours_spent)}<br>
                    <strong>Calculated Salary:</strong> ${payroll.calculated_salary.toFixed(2)}
                </p>
            </div>
        </div>
    </section>
    <section>
        <h2 style="font-size: 30px; border-bottom: 4px solid #214F70; padding-bottom: 16px; margin-bottom: 30px;">Fines and Bonuses</h2>
        ${finesContent}
        <div style="margin-top: 30px; text-align: right;">
            <p style="font-size: 24px;"><strong>Adjusted Salary:</strong> ${adjustedSalary.toFixed(2)}</p>
        </div>
    </section>
    <footer style="text-align: center; margin-top: 50px; font-size: 18px; color: #777;">
        &copy; ${new Date().getFullYear()} G-TECH SOLUTIONS. All rights reserved.
    </footer>
</div>
`;

            const element = document.createElement('div');
            element.innerHTML = content;
            document.body.appendChild(element);

            html2canvas(element, {
                scale: 3 // Increased scale for better quality
            }).then(canvas => {
                const imgData = canvas.toDataURL('image/png');
                const pdf = new jspdf.jsPDF({
                    orientation: 'portrait',
                    unit: 'pt',
                    format: 'a4'
                });

                const imgProps = pdf.getImageProperties(imgData);
                const pdfWidth = pdf.internal.pageSize.getWidth();
                const pdfHeight = (imgProps.height * pdfWidth) / imgProps.width;

                pdf.addImage(imgData, 'PNG', 0, 0, pdfWidth, pdfHeight, undefined, 'FAST');

                const pdfFrame = document.createElement('iframe');
                pdfFrame.style.width = '100%';
                pdfFrame.style.height = '100%';
                pdfFrame.src = pdf.output('bloburl');
                document.getElementById('pdfPlaceholder').innerHTML = '';
                document.getElementById('pdfPlaceholder').appendChild(pdfFrame);

                new bootstrap.Modal(document.getElementById('pdfModal')).show();

                document.body.removeChild(element);
                document.querySelector('.loader').style.display = 'none';
            }).catch(error => {
                console.error('Error generating PDF:', error);
                document.body.removeChild(element);
                document.querySelector('.loader').style.display = 'none';
            });
        }
    </script>
@endsection
