<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Payroll Receipt - {{ \Carbon\Carbon::create($payroll->pay_year, $payroll->pay_month, 1)->format('F, Y') }}</title>
    <style>
        * {
            margin: 0;
            padding: 0;
            box-sizing: border-box;
        }

        body {
            font-family: Arial, sans-serif;
            background-color: white;
            padding: 20px;
            color: #000000;
            line-height: 1.2;
            font-size: 14px;
        }

        .receipt-container {
            max-width: 800px;
            margin: 0 auto;
            background-color: white;
            padding: 30px;
        }

        /* Header using table for better PDF compatibility */
        .header-table {
            width: 100%;
            margin-bottom: 40px;
            border-collapse: collapse;
        }

        .header-table td {
            vertical-align: top;
            padding: 0;
            border: none;
        }

        .header-left {
            width: 60%;
        }

        .header-left h1 {
            font-size: 24px;
            font-weight: normal;
            color: #2c5aa0 !important;
            margin-bottom: 5px;
        }

        .header-left .date {
            font-size: 14px;
            color: #000000;
        }

        .header-right {
            width: 40%;
            text-align: right;
        }

        .header-right img {
            max-width: 120px;
            height: auto;
        }

        /* Main content using table layout for PDF compatibility */
        .main-content-table {
            width: 100%;
            margin-bottom: 40px;
            border-collapse: collapse;
        }

        .main-content-table td {
            vertical-align: top;
            padding: 0;
            border: none;
        }

        .employee-section {
            width: 48%;
            padding-right: 20px;
        }

        .salary-section {
            width: 52%;
            padding-left: 20px;
        }

        .section-title {
            font-size: 16px;
            font-weight: bold;
            color: #000000;
            margin-bottom: 15px;
        }

        /* Detail rows using table for consistent spacing */
        .details-table {
            width: 100%;
            border-collapse: collapse;
        }

        .details-table tr {
            height: 22px; /* Fixed height for consistent spacing */
        }

        .details-table td {
            padding: 2px 0;
            border: none;
            vertical-align: top;
        }

        .detail-label {
            font-weight: bold;
            color: #000000;
            width: 140px;
        }

        .detail-value {
            color: #000000;
        }

        .fines-section {
            margin-top: 40px;
        }

        .fines-title {
            font-size: 16px;
            font-weight: bold;
            color: #000000;
            margin-bottom: 20px;
        }

        .fines-table {
            width: 100%;
            border-collapse: collapse;
            font-size: 14px;
        }

        .fines-table th {
            background-color: #f1f3f4;
            padding: 12px;
            text-align: left;
            font-weight: bold;
            color: #000000;
            border: 1px solid #ddd;
        }

        .fines-table td {
            padding: 12px;
            border: 1px solid #ddd;
            color: #000000;
        }

        .fines-table tr:nth-child(even) {
            background-color: #f9f9f9;
        }

        .total-row {
            background-color: #f1f3f4;
            font-weight: bold;
        }

        .adjusted-salary {
            text-align: right;
            margin-top: 30px;
            font-size: 16px;
            font-weight: bold;
            color: #000000;
        }

        .footer {
            text-align: center;
            margin-top: 60px;
            font-size: 12px;
            color: #000000;
        }

        /* PDF-specific optimizations */
        @media print {
            body {
                background-color: white;
                padding: 10px;
                color: #000000 !important;
                font-size: 13px;
            }
            
            .receipt-container {
                padding: 15px;
                max-width: none;
            }

            /* Force consistent spacing in PDF */
            .details-table tr {
                height: 20px !important;
                line-height: 1.1 !important;
            }

            .details-table td {
                padding: 1px 0 !important;
            }

            /* Ensure proper page breaks */
            .header-table,
            .main-content-table,
            .fines-section {
                page-break-inside: avoid;
            }

            /* Force all text to be black in PDF */
            * {
                color: #000000 !important;
            }

            .header-left h1 {
                color: #2c5aa0 !important;
            }
        }

        /* Force black text globally for PDF safety */
        * {
            color: #000000 !important;
        }

        .header-left h1 {
            color: #2c5aa0 !important;
        }
    </style>
</head>
<body>
    @php
        $approvedLeave = $approvedLeave ?? 0;
        $approvedLeaveHours = $approvedLeaveHours ?? 0;
    @endphp
    <div class="receipt-container">
        <!-- Header using table layout -->
        <table class="header-table">
            <tr>
                <td class="header-left">
                    <h1>Payroll Receipt</h1>
                    <div class="date">
                        {{ \Carbon\Carbon::create($payroll->pay_year, $payroll->pay_month, 1)->format('F, Y') }}
                    </div>
                </td>
                <td class="header-right">
                    <img src="{{ public_path('gtech-logo.jpeg') }}" alt="G-Tech Solutions Logo">
                </td>
            </tr>
        </table>

        <!-- Main content using table layout -->
        <table class="main-content-table">
            <tr>
                <td class="employee-section">
                    <div class="section-title">Employee Details</div>
                    <table class="details-table">
                        <tr>
                            <td class="detail-label">Name:</td>
                            <td class="detail-value">
                                {{ $employee->EmpPersonalDetails->first_name ?? '' }}
                                {{ $employee->EmpPersonalDetails->middle_name ?? '' }}
                                {{ $employee->EmpPersonalDetails->last_name ?? '' }}
                            </td>
                        </tr>
                        <tr>
                            <td class="detail-label">Mobile:</td>
                            <td class="detail-value">{{ $employee->EmpPersonalDetails->mobile ?? '' }}</td>
                        </tr>
                        <tr>
                            <td class="detail-label">Required Hours:</td>
                            <td class="detail-value"> {{ intdiv($payroll->working_hours, 60) }}:{{ str_pad($payroll->working_hours % 60, 2, '0', STR_PAD_LEFT) }}</td>
                        </tr>
                    </table>
                </td>
                <td class="salary-section">
                    <div class="section-title">Salary Details</div>
                    <table class="details-table">
                        <tr>
                            <td class="detail-label">Basic Salary:</td>
                            <td class="detail-value">{{ number_format($salary->basic_salary ?? 0, 2) }}</td>
                        </tr>
                        <tr>
                            <td class="detail-label">Hours Worked:</td>
                            <td class="detail-value">
                                {{ intdiv($payroll->actual_working_hours, 60) }}:{{ str_pad($payroll->actual_working_hours % 60, 2, '0', STR_PAD_LEFT) }}
                            </td>
                        </tr>
                        <tr>
                            <td class="detail-label">Approved Leaves:</td>
                            <td class="detail-value">
                                {{ $approvedLeave }}
                            </td>
                        </tr>
                        <tr>
                            <td class="detail-label">Approved Leave Hours:</td>
                            <td class="detail-value">
                                {{ $approvedLeaveHours }}
                            </td>
                        </tr>
                        <tr>
                            <td class="detail-label">Over Time Hours:</td>
                            <td class="detail-value">
                                {{ intdiv($payroll->overtime_hours, 60) }}:{{ str_pad($payroll->overtime_hours % 60, 2, '0', STR_PAD_LEFT) }}
                            </td>
                        </tr>
                        <tr>
                            <td class="detail-label">Total Hours Worked:</td>
                            <td class="detail-value">
                                {{ intdiv($payroll->hours_spent, 60) }}:{{ str_pad($payroll->hours_spent % 60, 2, '0', STR_PAD_LEFT) }}
                            </td>
                        </tr>
                        <tr>
                            <td class="detail-label">Calculated Salary:</td>
                            <td class="detail-value">{{ number_format($payroll->calculated_salary, 2) }}</td>
                        </tr>
                    </table>
                </td>
            </tr>
        </table>

        <div class="fines-section">
            <div class="fines-title">Fines and Bonuses</div>
            <table class="fines-table">
                <thead>
                    <tr>
                        <th>Reason</th>
                        <th>Date</th>
                        <th>Amount</th>
                        <th>Type</th>
                    </tr>
                </thead>
                <tbody>
                    @forelse($fines as $fine)
                        <tr>
                            <td>{{ $fine->fine_reason }}</td>
                            <td>{{ \Carbon\Carbon::parse($fine->date)->format('d-m-Y') }}</td>
                            <td>{{ number_format($fine->fine_amount, 2) }}</td>
                            <td>{{ $fine->type == 1 ? 'Bonus' : 'Fine' }}</td>
                        </tr>
                    @empty
                        <tr>
                            <td colspan="4" style="text-align:center;">No fines or bonuses</td>
                        </tr>
                    @endforelse
                    <tr class="total-row">
                        <td>Total Fines/Bonuses</td>
                        <td></td>
                        <td>
                            Fines: {{ number_format($totalFines, 2) }},
                            Bonuses: {{ number_format($totalBonuses, 2) }}
                        </td>
                        <td></td>
                    </tr>
                </tbody>
            </table>
        </div>

        <div class="adjusted-salary">
            <strong>Adjusted Salary: {{ number_format($adjustedSalary, 2) }}</strong>
        </div>

        <div class="footer">
            © {{ date('Y') }} G-TECH SOLUTIONS. All rights reserved.
        </div>
    </div>
</body>
</html>