@extends('includes/layout')
@section('main-page-content')
    <!-- add html here--->

    <div class="container-xxl flex-grow-1 container-p-y">
        <div class="row">
            <div class="col-md-12">
                <div class="card mb-4">
                    <div class="card-body">
                        <div>
                            <div class="h4 pb-0 mb-0">Permissions</div>
                            <small>Dashboard-Permissions</small>
                        </div>
                        <div class="row">
                            <div class="col-lg-3 col-md-4 col-12 mt-3 mt-lg-0 p-1">
                                <div class="border border-primary rounded">
                                    <div
                                        class="group-btn bg-primary text-light d-flex justify-content-between align-items-center p-2">
                                        <span class="text-white text-bold">Tier </span>
                                        <div class="invisible">
                                            <button class="btn btn-light bg-white btn-sm custom-icon-btn p-2 me-2"><span
                                                    class="mdi mdi-plus"></span> &nbsp;New </button>
                                        </div>
                                    </div>
                                    <div class="p-2">
                                        <small>Tier List</small>
                                        <div class="mt-3 ms-2" style="min-height:70vh;max-height:70vh;overflow-y: scroll;">
                                            @foreach ($tiers as $tier)
                                                <div class="form-check my-3">
                                                    <input name="tier-radio-button"
                                                        class="form-check-input tier-radio-button" type="radio"
                                                        value="{{ $tier->id }}"
                                                        onclick="_tierRelatedData({{ $tier->id }});"
                                                        id="id{{ $tier->id }}">
                                                    <label class="form-check-label"
                                                        for="id{{ $tier->id }}">{{ $tier->title }}({{ $tier->tier_key??'' }})</label>
                                                </div>
                                            @endforeach
                                        </div>
                                    </div>
                                </div>
                            </div>
                            <div class="col-lg-6 col-md-8 col-12 mt-3 mt-lg-0 p-1">
                                <div class="border border-primary rounded">
                                    <div
                                        class="bg-primary text-light d-flex justify-content-between align-items-center p-2">
                                        <span class="text-white font-weight-bold">Permissions</span>
                                        <div class="btn-center">
                                            @if (in_array('Permissions Maintain', Session::get('permissions')))
                                                <button class="btn btn-success btn-sm custom-icon-btn p-2"
                                                    onclick="_save_permission();">
                                                    <span class="mdi mdi-check"></span> Save
                                                </button>
                                                <button class="group-btn btn btn-danger btn-sm custom-icon-btn p-2"
                                                    onclick="_cancel_permission();">
                                                    <span class="mdi mdi-close"></span> Cancel
                                                </button>
                                            @endif
                                        </div>
                                    </div>
                                    <div class="p-2">
                                        <small>Permissions List</small>
                                        <form id="permissions_form">
                                            <div class="mt-3"
                                                style="min-height: 70vh; max-height: 70vh; overflow-y: scroll;">
                                                <input value="" type="hidden" class="tier_id_form" name="tier_id">
                                                @foreach ($permissions_modules as $permissions_module)
                                                    <div class="input-group rounded-0 p-2 bg-info">
                                                        <div
                                                            class="input-group-text form-check mb-0 border-0 rounded-0 bg-info">
                                                            <input class="form-check-input m-auto" type="checkbox"
                                                                value="{{ $permissions_module->id }}"
                                                                permission_value="{{ $permissions_module->id }}"
                                                                onchange="_change_permission(this)"
                                                                aria-label="Checkbox for following text input">
                                                        </div>
                                                        <div class="form-control rounded-0 bg-info border-0 text-white">
                                                            {{ $permissions_module->title }}</div>
                                                    </div>
                                                    <div class="ms-3">

                                                        @foreach ($permissions_module->permissionsSubModule as $permissionsSubModule)
                                                            <div class="input-group my-2">
                                                                <div class="input-group-text form-check mb-0 rounded-0">
                                                                    <input class="form-check-input m-auto my-0"
                                                                        type="checkbox"
                                                                        value="{{ $permissionsSubModule->id }}"
                                                                        submodule="{{ $permissionsSubModule->id }}"
                                                                        module="{{ $permissions_module->id }}"
                                                                        sub_permission_value="{{ $permissionsSubModule->id }}"
                                                                        onchange="_change_sub_permission(this)"
                                                                        aria-label="Checkbox for following text input">
                                                                </div>
                                                                <div
                                                                    class="meeting-fields form-control justify-content-between align-items-center rounded-0">
                                                                    {{ $permissionsSubModule->title }}
                                                                    <div
                                                                        class="meeting-fields justify-content-between align-items-center mt-1 pt-1">
                                                                        <div class="form-check form-check-inline">
                                                                            <input type="hidden"
                                                                                name="module[{{ $permissionsSubModule->id }}][0]"
                                                                                value="0">
                                                                            <input class="form-check-input" type="checkbox"
                                                                                id="inlineCheckbox1"
                                                                                view="{{ $permissionsSubModule->id }}"
                                                                                submodule="{{ $permissionsSubModule->id }}"
                                                                                module="{{ $permissions_module->id }}"
                                                                                onchange="_change_view_permission(this)"
                                                                                name="module[{{ $permissionsSubModule->id }}][0]"
                                                                                value="1">
                                                                            <label class="form-check-label"
                                                                                for="inlineCheckbox1">View</label>
                                                                        </div>
                                                                        <div class="form-check form-check-inline">
                                                                            <input type="hidden"
                                                                                name="module[{{ $permissionsSubModule->id }}][1]"
                                                                                value="0">
                                                                            <input class="form-check-input" type="checkbox"
                                                                                id="inlineCheckbox1"
                                                                                maintain="{{ $permissionsSubModule->id }}"
                                                                                submodule="{{ $permissionsSubModule->id }}"
                                                                                module="{{ $permissions_module->id }}"
                                                                                onchange="_change_maintain_permission(this)"
                                                                                name="module[{{ $permissionsSubModule->id }}][1]"
                                                                                value="1">
                                                                            <label class="form-check-label"
                                                                                for="inlineCheckbox1">Maintain</label>
                                                                        </div>
                                                                    </div>
                                                                </div>
                                                            </div>
                                                        @endforeach


                                                    </div>
                                                @endforeach

                                            </div>
                                        </form>
                                    </div>
                                </div>
                            </div>
                            <div class="col-lg-3 p-1 col-md-12 col-12 mt-3 mt-lg-0">
                                <div class="border border-primary rounded">
                                    <div
                                        class="bg-primary text-light d-flex justify-content-between align-items-center p-2">
                                        <span class="text-white text-bold" style="padding: 6px 0.1px;">Assigned User
                                        </span>
                                    </div>
                                    <div class="p-2">
                                        <small>Associated Users with Selected Tier</small>
                                        <div class="mt-3" style="min-height:70vh;max-height:70vh;overflow-y: scroll;"
                                            id="associated_user">
                                            <div class="w-100 text-center">
                                                no tier selected yet
                                            </div>
                                        </div>
                                    </div>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>
@endsection






@section('css-js')
    <script>
        /* add js  here */

        $(document).ready(function() {

            loader(false);
            _tierRelatedData($('.tier-radio-button:first').val());
            $('.tier-radio-button:first').prop('checked', true);

        });


        function _tierRelatedData(id) {
            var _FormData = new FormData();
            _FormData.append("tier_id", id);

            $('.tier_id_form').val(id);

            $.ajax({
                type: "POST",
                url: "{{ url('/tier-related-data') }}",
                headers: {
                    'X-CSRF-TOKEN': '{{ csrf_token() }}'
                },
                data: _FormData,
                processData: false,
                contentType: false,
                success: function(response) {

                    var users = response.data.users;
                    var tier_permissions = response.data.tier_permissions;
                    $('#permissions_form input[type="checkbox"]').prop('checked', false);

                    var html = ``;
                    for (var i = 0; i < users.length; i++) {
                        html += `
                                <div class="input-group mb-1"  tier="button" onclick="window.location.href = '{{ url('/') }}/user-profile/${users[i].user_id}'" >
                                   <div class="input-group-text form-check mb-0 rounded-0">
                                       <input disabled class="form-check-input m-auto" type="checkbox" value="" aria-label="Checkbox for following text input" checked>
                                   </div>
                                   <div class="form-control rounded-0 text-capitalize" aria-label="Text input with checkbox">${users[i].first_name ? users[i].first_name : ""} ${users[i].middle_name ? users[i].middle_name : ""} ${users[i].last_name ? users[i].last_name : ""} </div>
                                </div>`;
                    }

                    if (html == ``) {
                        html += `<div class="w-100 text-center">
                                no user assigned yet
                             </div>`;
                    }


                    $('#associated_user').html(html);

                    var sub_module = "";
                    for (var i = 0; i < tier_permissions.length; i++) {
                        sub_module = $(`input[maintain=${tier_permissions[i].sub_module_id}]`)
                        if (tier_permissions[i].view == '1') {
                            $(`input[view=${tier_permissions[i].sub_module_id}]`).prop('checked', true);
                            _change_view_permission(sub_module);
                        } else {
                            $(`input[view=${tier_permissions[i].sub_module_id}]`).prop('checked', false);
                            _change_view_permission(sub_module);
                        }


                        if (tier_permissions[i].maintain == '1') {
                            $(`input[maintain=${tier_permissions[i].sub_module_id}]`).prop('checked', true);
                            _change_maintain_permission(sub_module);
                        } else {
                            $(`input[maintain=${tier_permissions[i].sub_module_id}]`).prop('checked', false);
                            _change_maintain_permission(sub_module);
                        }


                    }





                    loader(false);

                },
                error: function(response) {
                    loader(false);
                    if (response.status == 500) {
                        toastr.error("Something went wrong")
                    } else {
                        toastr.error(response.responseJSON.message)
                    }
                }
            });

        }

        function _change_permission(_this) {
            if ($(_this).is(':checked')) {
                $(`input[module=${$(_this).val()}]`).prop('checked', true);
            } else {
                $(`input[module=${$(_this).val()}]`).prop('checked', false);
            }
        }

        function _change_sub_permission(_this) {
            var modules = $(`input[module=${$(_this).attr('module')}]`);
            var _checked = true;


            if ($(_this).is(':checked')) {
                $(`input[submodule=${$(_this).val()}]`).prop('checked', true);
            } else {
                $(`input[submodule=${$(_this).val()}]`).prop('checked', false);
            }



            for (var i = 0; i < modules.length; i++) {
                if (!$(modules[i]).is(':checked')) {
                    _checked = false;
                }
            }

            $(`input[permission_value=${$(_this).attr('module')}]`).prop('checked', _checked);

        }

        function _change_view_permission(_this) {

            // submodule
            var submodules = $(`input[submodule=${$(_this).attr('submodule')}]`);
            var __checked = true;

            for (var i = 1; i < submodules.length; i++) {
                if (!$(submodules[i]).is(':checked')) {
                    __checked = false;
                }
            }

            $(`input[sub_permission_value=${$(_this).attr('submodule')}]`).prop('checked', __checked);


            // module
            var modules = $(`input[module=${$(_this).attr('module')}]`);
            var _checked = true;

            for (var i = 0; i < modules.length; i++) {
                if (!$(modules[i]).is(':checked')) {
                    _checked = false;
                }
            }

            $(`input[permission_value=${$(_this).attr('module')}]`).prop('checked', _checked);

        }

        function _change_maintain_permission(_this) {

            // submodule
            var submodules = $(`input[submodule=${$(_this).attr('submodule')}]`);
            var __checked = true;

            for (var i = 1; i < submodules.length; i++) {
                if (!$(submodules[i]).is(':checked')) {
                    __checked = false;
                }
            }

            $(`input[sub_permission_value=${$(_this).attr('submodule')}]`).prop('checked', __checked);


            // module
            var modules = $(`input[module=${$(_this).attr('module')}]`);
            var _checked = true;

            for (var i = 0; i < modules.length; i++) {
                if (!$(modules[i]).is(':checked')) {
                    _checked = false;
                }
            }

            $(`input[permission_value=${$(_this).attr('module')}]`).prop('checked', _checked);

        }

        function _save_permission() {

            var id = $("input[name='tier-radio-button']:checked").val();

            if (!id) {
                toastr.error("Please Select A Tier First");
                return 0;
            }

            loader(true);

            $.ajax({
                type: "POST",
                url: `{{ url('/permission') }}`,
                headers: {
                    'X-CSRF-TOKEN': '{{ csrf_token() }}'
                },
                data: $("#permissions_form").serialize(),
                success: function(response) {

                    toastr.success(response.message);

                    loader(false);

                },
                error: function(response) {
                    loader(false);
                    if (response.status == 500) {
                        toastr.error("Something went wrong")
                    } else {
                        toastr.error(response.responseJSON.message)
                    }
                }
            });

        }

        function _cancel_permission() {
            var id = $("input[name='tier-radio-button']:checked").val();

            if (!id) {
                toastr.error("Please Select A Tier First");
                return 0;
            }


            _tierRelatedData(id);


        }
    </script>
    <style>
        /* css js here*/

        .btn-success {
            margin-right: 15px;
        }

        .meeting-fields.form-control {
            display: flex;
        }

        @media only screen and (max-width: 320px) {
            .meeting-fields.form-control {
                display: block;
            }

            .btn-success {
                margin-right: 0px;
                margin-bottom: 10px;
            }

            .btn-center {
                text-align: center;
            }
        }
    </style>
@endsection
