@php

    use App\Models\RosterTemplate;
    use App\Models\RosterAssign;
    use App\Models\LeaveRequest;
    use App\Models\PublicHoliday;
    use Carbon\Carbon;

    function AM_PM($TIME)
    {
        $time = new DateTime($TIME);
        $time = str_replace('M', '', $time->format('g:i A'));
        $time = str_replace(' ', '', $time);
        $time = str_replace(':00', '', $time);
        return $time;
    }

    function calculate_time_difference($start_time, $end_time, $break_minutes)
    {
        $time_format = 'H:i:s';
        $start_datetime = DateTime::createFromFormat($time_format, $start_time);
        $end_datetime = DateTime::createFromFormat($time_format, $end_time);
        $time_difference_seconds = $end_datetime->getTimestamp() - $start_datetime->getTimestamp();
        $break_minutes = $break_minutes * 60;
        return round(($time_difference_seconds - $break_minutes) / 3600, 2);
    }

    function hasShiftConflict($shifts, $currentShift)
    {
        $currentStartDateTime = Carbon::createFromFormat('H:i:s', $currentShift['roster_template']['start_time']);
        $currentEndDateTime = Carbon::createFromFormat('H:i:s', $currentShift['roster_template']['end_time']);

        foreach ($shifts as $shift) {
            if ($shift === $currentShift) {
                continue; // Skip checking against itself
            }

            $startDateTime = Carbon::createFromFormat('H:i:s', $shift['roster_template']['start_time']);
            $endDateTime = Carbon::createFromFormat('H:i:s', $shift['roster_template']['end_time']);

            // Check for overlap
            if ($currentStartDateTime < $endDateTime && $currentEndDateTime > $startDateTime) {
                return true; // Conflict found
            }
        }

        return false; // No conflicts found
    }

    $total_hour = 0;

@endphp
<div class="table-responsive text-nowrap mt-3 border-bottom">
    <div class="mini_loader d-none"></div>
    <table class="table table-bordered">
        <thead class="bg-light">
            <tr>
                <th>CUSTOM</th>
                @foreach ($dates_array as $date)
                    @php
                        $dateTime = new DateTime($date);
                        $hour_date_wise[$date] = 0;
                    @endphp
                    <th
                        style="min-width: 200px !important;@if ($date == date('Y-m-d')) font-weight:bold !important; color: #dd4848  !important; @endif">
                        {{ $dateTime->format('D d') }}</th>
                @endforeach

            </tr>
        </thead>
        <tbody class="table-border-bottom-0">

            @foreach ($users as $user)
                <tr>
                    <td class=" h-px-50 w-px-150 p-2">
                        <div class="d-flex">
                            <div class="employee-thumbnail w-px-40" style="position: relative;">
                                <div class="the-dot"
                                    style="background: {{ $user->user_type == 0 ? '#56ca00 ' : 'orange' }};"></div>
                                <img src="{{ url($user->empPersonalDetails->image) }}"
                                    class="img-fluid w-px-40 h-px-40 rounded-circle">
                            </div>
                            <a class="employee-name mt-2 ms-2 userId{{ $user->id }}"
                                target="_blank">{{ $user->empPersonalDetails->first_name }}
                                {{ $user->empPersonalDetails->middle_name }}
                                {{ $user->empPersonalDetails->last_name }}</a>
                        </div>
                    </td>
                    @foreach ($dates_array as $date)
                        <td class="h-px-50 w-px-120 plus-td">
                            <div class="d-flex justify-content-end">

 
                                @php
                                    $shifts_of_this_box = RosterAssign::with('rosterTemplate')
                                        ->where(['assign_to' => $user->id, 'schedule_date' => $date])
                                        ->get();

                                    $holiday = PublicHoliday::where('from', '<=', $date)
                                        ->where('to', '>=', $date)
                                        ->first();

                                    $leave = LeaveRequest::where('employee_id', $user->id)
                                        ->where('status', '!=', '2')
                                        ->where('from', '<=', $date)
                                        ->where('to', '>=', $date)
                                        ->first();

                                @endphp
                               
                                <div style="width: 100%;">




                                    @if ($holiday)
                                        <div class="col text-black p-1 mb-1 hoverc"
                                            style="width: 100%; background-color: #cdced1; border-color: #cdced1;">
                                            <div class="at-normal details justify-content-around">
                                                <small class="col-auto" style="font-weight:bold !important;">Holiday:
                                                    {{ $holiday->title }}</small>
                                            </div>
                                            <div class="at-hover details justify-content-around">
                                                <small class="col-auto" style="font-weight:bold !important;">Holiday:
                                                    {{ $holiday->title }}</small>
                                            </div>
                                        </div>

                                        @php $holiday_conflict = 1;  @endphp
                                    @else
                                        @php $holiday_conflict = 0;  @endphp
                                    @endif



                                    @if ($leave)
                                        <div class="col text-black p-1 mb-1 hoverc"
                                            style="width: 100%; background-color: #cdced1; border-color: #cdced1;">
                                            <div class="at-normal details justify-content-around">
                                                <small class="col-auto" style="font-weight:bold !important;">Leave:
                                                    {{ $leave->leavepackage->title ?? ''}}</small>
                                            </div>
                                            <div class="at-hover details justify-content-around">
                                                @if (in_array('Roster Maintain', Session::get('permissions')))
                                                    <button
                                                        class="btn btn-secondary btn-sm text-white w-50 btn-size ms-2"
                                                        type="button" onclick="edit_leave({{ $leave->id }});"><span
                                                            class="mdi mdi-pencil"></span></button>
                                                    <a class="btn btn-secondary btn-sm text-white w-50 btn-size ms-2"
                                                        target="_blank"
                                                        href="{{ url('/leave-view/' . $leave->id) }}"><span
                                                            class="mdi mdi-eye-outline"></span></a>
                                                @endif
                                            </div>
                                        </div>

                                        @php $leave_conflict = 0;  @endphp
                                    @endif


                                    @foreach ($shifts_of_this_box as $shift)
                                        @php

                                            $conflict = hasShiftConflict(
                                                json_decode($shifts_of_this_box, true),
                                                json_decode($shift, true),
                                            );

                                            $shift = json_decode($shift, true);

                                            $hour = calculate_time_difference(
                                                $shift['roster_template']['start_time'],
                                                $shift['roster_template']['end_time'],
                                                $shift['roster_template']['break_minutes'],
                                            );

                                            $total_hour += $hour;

                                            $hour_date_wise[$date] += $hour;

                                            if ($leave) {
                                                if ($leave->full_day == '1') {
                                                    $leave_conflict = 1;
                                                } else {
                                                    $startTime = DateTime::createFromFormat(
                                                        'H:i:s',
                                                        $leave->start_time,
                                                    );
                                                    $endTime = DateTime::createFromFormat('H:i:s', $leave->end_time);

                                                    $shiftStartTime = DateTime::createFromFormat(
                                                        'H:i:s',
                                                        $shift['roster_template']['start_time'],
                                                    );
                                                    $shiftEndTime = DateTime::createFromFormat(
                                                        'H:i:s',
                                                        $shift['roster_template']['end_time'],
                                                    );

                                                    if ($startTime >= $shiftStartTime && $endTime <= $shiftEndTime) {
                                                        $leave_conflict = 1;
                                                    } else {
                                                        $leave_conflict = 0;
                                                    }
                                                }
                                            } else {
                                                $leave_conflict = 0;
                                            }

                                        @endphp




                                        <div class="col text-black p-1 mb-1 hoverc"
                                            style="width: 100%; background-color: {{ $shift['roster_template']['color_code'] }}; border-color: {{ $shift['roster_template']['color_code'] }};">
                                            <div class="at-normal details justify-content-around">
                                                <small class="col-auto text-lowercase"
                                                    style="font-weight:bold !important;">
                                                    {{ AM_PM($shift['roster_template']['start_time']) }} -
                                                    {{ AM_PM($shift['roster_template']['end_time']) }} </small>
                                                <small lass="col-auto">
                                                    @if ($shift['roster_template']['repeat_shift'] == '1')
                                                        <span class="mdi mdi-repeat"></span>
                                                    @else
                                                        <span class="mdi mdi-repeat"
                                                            style="color:transparent !important;"></span>
                                                    @endif
                                                </small>
                                                <small lass="col-auto">
                                                    @if ($conflict || $holiday_conflict || $leave_conflict)
                                                        <span class="mdi mdi-alert-circle-outline text-white"></span>
                                                    @else
                                                        <span class="mdi mdi-alert-circle-outline"
                                                            style="color:transparent !important;"></span>
                                                    @endif
                                                </small>
                                            </div>
                                            <div class="at-hover justify-content-around" style="position: relative">
                                                @if (in_array('Roster Maintain', Session::get('permissions')))
                                                    <button class="btn btn-secondary btn-sm text-white w-75 btn-size"
                                                        type="button"
                                                        onclick="_template_modal('{{ $date }}','{{ $user->id }}',0,{{ $shift['roster_template']['id'] }},'edit');"><span
                                                            class="mdi mdi-pencil"></span></button>
                                                @endif
                                                @if ($conflict || $holiday_conflict || $leave_conflict)
                                                    <button
                                                        class="btn btn-secondary btn-sm text-white w-75 btn-size  ms-2"
                                                        type="button" data-bs-toggle="dropdown"><span
                                                            class="mdi mdi-alert-circle-outline"></span></button>
                                                @endif
                                                <ul class="dropdown-menu beak-container bg-secondary text-center">
                                                    @if ($conflict)
                                                        <li role="button" class="ps-2 pe-2">Conflict with other shift
                                                        </li>
                                                    @endif
                                                    @if ($holiday_conflict)
                                                        <li role="button" class="ps-2 pe-2">Today is public holiday
                                                        </li>
                                                    @endif

                                                    @if ($leave_conflict)
                                                        <li role="button" class="ps-2 pe-2">This employee is on leave
                                                        </li>
                                                    @endif
                                                </ul>
                                                @if (in_array('Roster Maintain', Session::get('permissions')))
                                                    <button
                                                        class="btn btn-secondary btn-sm text-white w-25 btn-size ms-2"
                                                        data-bs-toggle="dropdown" type="button"><span
                                                            class="mdi mdi-dots-vertical"></span></button>
                                                    <ul class="dropdown-menu beak-container bg-secondary text-center">
                                                        <li role="button"
                                                            onclick="_shift_delete_modal('{{ $date }}','{{ $user->id }}',{{ $shift['roster_template']['id'] }},{{ $shift['roster_template']['repeat_shift'] }})">
                                                            Delete</li>
                                                    </ul>
                                                @endif
                                            </div>
                                        </div>
                                    @endforeach
                                </div>
                                @if (in_array('Roster Maintain', Session::get('permissions')))
                                    <span class="ms-2 mdi-plus-icon font-weight-bold"
                                        onclick="_template_modal('{{ $date }}',{{ $user->id }},1,0,'');">+</span>
                                @endif
                            </div>
                        </td>
                    @endforeach

                </tr>
            @endforeach
        </tbody>
        <tfoot class="bg-light">
            <tr>
                <th>
                    <div class="form-select select_ p-1" style="font-size: 12px;">Assigned total {{ $total_hour }}
                        hours</div>
                </th>
                @foreach ($dates_array as $date)
                    <th>{{ $hour_date_wise[$date] }}</th>
                @endforeach
            </tr>
        </tfoot>
    </table>
</div>




@php
    $html = '';
    $pages_btn = '';
    $count = intval($count) < $per_page ? 1 : intval($count) / $per_page;
    $count = ceil($count);
    $c = 0;
@endphp

<nav aria-label="Page navigation" class="mt-3">
    <ul class="pagination justify-content-md-end justify-content-center pages_btn">

        <li class="page-item prev {{ $count == 0 ? 'd-none' : '' }}" onclick="_get(0);">
            <a class="page-link waves-effect" href="javascript:void(0);"><i
                    class="tf-icon mdi mdi-chevron-double-left"></i></a>
        </li>
        <li class="page-item prev {{ $count == 0 ? 'd-none' : '' }}"
            onclick="$('.active').prev('.p-btn').trigger('onclick');">
            <a class="page-link waves-effect" href="javascript:void(0);"><i
                    class="tf-icon mdi mdi-chevron-left"></i></a>
        </li>

        @for ($c = 0; $c < $count; $c++)
            @if (
                $from == ($c - 3) * $per_page ||
                    $from == ($c - 2) * $per_page ||
                    $from == ($c - 1) * $per_page ||
                    $from == $c * $per_page ||
                    $from == ($c + 1) * $per_page ||
                    $from == ($c + 2) * $per_page ||
                    $from == ($c + 3) * $per_page)
                <li class="page-item p-btn {{ $from == $c * $per_page ? 'active' : '' }} {{ $count == 0 ? 'd-none' : '' }}"
                    onclick="_get({{ $c * $per_page }});">
                    <a class="page-link waves-effect" href="javascript:void(0);">{{ $c + 1 }}</a>
                </li>
            @endif
        @endfor

        <li class="page-item next {{ $count == 0 ? 'd-none' : '' }}"
            onclick="$('.active').next('.p-btn').trigger('onclick');">
            <a class="page-link waves-effect" href="javascript:void(0);"><i
                    class="tf-icon mdi mdi-chevron-right"></i></a>
        </li>
        <li class="page-item next {{ $count == 0 ? 'd-none' : '' }}" onclick="_get({{ ($c - 1) * $per_page }});">
            <a class="page-link waves-effect" href="javascript:void(0);"><i
                    class="tf-icon mdi mdi-chevron-double-right"></i></a>
        </li>
    </ul>
</nav>

<input value="{{ $from }}" type="hidden" id="from">
