@extends('includes/layout')
@section('main-page-content')

    @php

        use App\Models\EmpCompanyDetails;

    @endphp
    <style>
        .the-dot {
            border: 1px solid transparent;
            border-radius: 50%;
            width: 10px;
            height: 10px;
            z-index: 2;
            position: absolute;
        }

        .mdi-plus-icon {
            font-size: 24px;
            font-weight: bold;
            cursor: pointer;
            color: #73CEFE;
            display: none;
        }

        .custom-color-input {
            appearance: none;
            border: none;
            width: 40px;
            height: 40px;
            border-radius: 50%;
            padding: 0;
            margin: 0;
        }

        .custom-color-input::-webkit-color-swatch-wrapper {
            border: none;
            border-radius: 50%;
        }

        .custom-color-input::-webkit-color-swatch {
            border: none;
            border-radius: 50%;
            width: 100%;
            height: 100%;
        }

        .ui-datepicker-container {
            background-color: ghostwhite;
        }

        .ui-datepicker .ui-datepicker-header {
            background-color: ghostwhite !important;
        }

        .ui-datepicker {
            background-color: ghostwhite !important;
        }

        .ui-datepicker-prev,
        .ui-datepicker-next {
            display: none !important;
        }

        .ui-datepicker {
            background-color: ghostwhite !important;
            color: black;
            position: absolute;
            top: 285px !important;
            left: 408px !important;
            z-index: 1;
        }

        .select_ {
            appearance: none;
            border: 0;
            outline: 0;
            background: none;
        }

        .custome-icon {
            position: absolute;
            position: absolute;
            left: 220px;
            bottom: 35px;
        }


        .details {
            /* background-image: url(data:image/svg+xml;base64,PD94bWwgdmVyc2lvbj0iMS4wIiBlbmNvZGluZz0iVVRGLTgiPz4KPHN2ZyB3aWR0aD0iMTZweCIgaGVpZ2h0PSIxNnB4IiB2aWV3Qm94PSIwIDAgMTYgMTYiIHZlcnNpb249IjEuMSIgeG1sbnM9Imh0dHA6Ly93d3cudzMub3JnLzIwMDAvc3ZnIiB4bWxuczp4bGluaz0iaHR0cDovL3d3dy53My5vcmcvMTk5OS94bGluayI+CiAgICA8dGl0bGU+QXJ0Ym9hcmQ8L3RpdGxlPgogICAgPGcgaWQ9IkFydGJvYXJkIiBzdHJva2U9Im5vbmUiIHN0cm9rZS13aWR0aD0iMSIgZmlsbD0ibm9uZSIgZmlsbC1ydWxlPSJldmVub2RkIiBmaWxsLW9wYWNpdHk9IjAuMyI+CiAgICAgICAgPHBvbHlnb24gaWQ9IlBhdGgiIGZpbGw9IiNGRkZGRkYiIHBvaW50cz0iOCAwIDAgOCAwIDAiPjwvcG9seWdvbj4KICAgICAgICA8cG9seWdvbiBpZD0iUGF0aC0yIiBmaWxsPSIjRkZGRkZGIiBwb2ludHM9IjAgMTYgMTYgMCAxNiA4IDggMTYiPjwvcG9seWdvbj4KICAgIDwvZz4KPC9zdmc+); */
        }

        .btn-size {
            padding-top: 3px !important;
            padding-bottom: 3px !important;
        }

        .at-hover {
            display: none;
        }

        .at-normal {
            display: flex;
        }

        .plus-td:hover .mdi-plus-icon {
            display: inline;
        }

        .hoverc:hover .at-hover {
            display: flex;
        }


        .hoverc:hover .at-normal {
            display: none;
        }

        .position-text {
            margin-left: 12px;
            background-color: rgb(242, 242, 242, 0.7);
            padding-left: 4px;
            padding-right: 4px;
        }


        .beak-container {
            position: relative;
            width: auto;
            height: auto;
            color: white;
        }

       


        .table-container-assign {
            overflow-y: auto;
            /* Add vertical scrollbar if necessary */
            max-height: 200px;
            /* Adjust the maximum height as needed */
            /* Other styles */
        }

        .table-assign {
            border-collapse: collapse;
            width: 100%;
        }

        .th-assign,
        .td-assign {
            padding: 8px;
            text-align: left;
        }

        .thead-assign .th-assign {
            position: sticky;
            top: 0;
            background-color: white;
            z-index: 1;
        }
    </style>

    <div class="container-xxl flex-grow-1 container-p-y">
        <h4 class="py-3 mb-4">Scheduler & Roster</h4>
        <div class="card mb-4">
            <div class="card-body">
                <div class="roster-detail border-bottom  flex-wrap mb-3">
                    <div class="d-flex flex-wrap flex-md-nowrap mt-2 mb-2">
                        <div class=" p-2 ">
                            <div class="">
                                <h4 class="pb-0 mb-0 full_date"></h4>
                            </div>
                            
                        </div>
                    </div>
                
                    <div class="btn-group mb-3 ms-auto me-2 roaster_btn_w" role="group">
                        <!-- @if (in_array('Roster Maintain', Session::get('permissions')))
                            <button type="button" class="btn btn-primary" onclick="_publish();">Publish & Notify <br> All
                                Employees</button>
                            <div class="btn-group" role="group">
                                <button id="btnGroupDrop1" type="button" class="btn btn-primary dropdown-toggle"
                                    data-bs-toggle="dropdown" aria-expanded="false" data-bs-auto-close="outside"></button>
                                <div class="dropdown-menu  close_drowpdown_menu publish-notify-dropdown" style="width:350px;">
                                    <div class="row p-4">
                                        <div class="d-flex justify-content-between border-bottom">
                                            <h5 class="notify-title" id="">Publish & Notify</h5>
                                        </div>
                                        <div class="col-12 form-group">
                                            <div class="mb-3">
                                                <label for="scheduler_notify_recipents"
                                                    class="form-label">RECIPIENTS</label>
                                                   <select class="form-select" style="min-width:100%;" multiple data-placeholder="Select Recipent" id="scheduler_notify_recipents">
                                                    <option value="all">All</option>
                                                    @php
                                                        $recipents = EmpCompanyDetails::query();
                                                        $recipents->where('id', '!=', '1');
                                                        $recipents->where('del', '0');
                                                        $recipents->where('compeleted', '1');
                                                        $recipents->where('approved', '1');
                                                        $recipents->where('status', '1');
                                                        $recipents->with([
                                                            'empPersonalDetails' => function ($recipents) {
                                                                $recipents->select(
                                                                    'emp_id',
                                                                    'first_name',
                                                                    'middle_name',
                                                                    'last_name',
                                                                    'image',
                                                                );
                                                            },
                                                        ]);

                                                        $recipents_users = $recipents->get();

                                                    @endphp

                                                    @foreach ($recipents_users as $recipents_user)
                                                        <option
                                                            value="employee.{{ $recipents_user->empPersonalDetails->emp_id }}">
                                                            {{ $recipents_user->empPersonalDetails->first_name }}
                                                            {{ $recipents_user->empPersonalDetails->middle_name }}
                                                            {{ $recipents_user->empPersonalDetails->last_name }}</option>
                                                    @endforeach

                                                </select>
                                            </div>
                                        </div>
                                        <div class="col-12">
                                            <div class="mb-3">
                                                <label for="scheduler_notify_date_range" class="form-label">Date Range</label>
                                                <div class="input-group" id="scheduler_notify_date_range">
                                                    <input type="date" aria-label="Start Date"
                                                        id="scheduler_notify_date_range_start" class="form-control">
                                                    <input type="date" aria-label="End Date"
                                                        id="scheduler_notify_date_range_end" class="form-control">
                                                </div>
                                            </div>
                                        </div>
                                    
                                        <div class="col-12">
                                            <div class="mb-3">
                                                <label for="scheduler_notify_message" class="form-label">Message (Optional & Email Only)</label>
                                                <textarea class="form-control" id="scheduler_notify_message" rows="3"></textarea>
                                            </div>
                                        </div>
                                        <div class="col-12 border-top">
                                            <div class="mt-3 d-flex justify-content-center">
                                                <button class="btn btn-primary" onclick="_publish_custom();">PUBLISH SHIFT</button>
                                            </div>
                                        </div>
                                    </div>
                                </div>
                            </div>
                        @endif -->
                    </div>


                    <div class="btn-group mb-3 roaster_btn_w" role="group">
                        <button type="button" class="btn btn-primary p-3" onclick="_bulk_schedule();">Bulk
                            Schedule</button>
                    </div>
                    <div class="btn-group ms-2 mb-3 " role="group">
                        <button type="button" class="btn btn-danger" onclick="bulk_delete_modal();">Bulk Delete</button>
                    </div>
                </div>

                <div class="roster-detail border-bottom  flex-wrap mb-3">
                    <div class="d-flex flex-wrap flex-md-nowrap mt-2 mb-2">
                        <div class=" p-2 ">
                            <div class="btn-group" role="group" aria-label="Basic outlined example">
                                <button type="button" class="btn btn-outline-light btn-sm p-1" id="decreaseDate"
                                    onclick="_prev_date();">
                                    <span class="mdi mdi-chevron-left text-dark"></span>
                                </button>
                                <button type="button" class="btn btn-outline-light btn-sm" id="scheduler_date"
                                    onchange="_onchange_date($('#scheduler_date').attr('value'));">
                                    <span class="mdi mdi-calendar-month text-dark"></span>
                                </button>
                                </label>
                                <button type="button" class="btn btn-outline-light btn-sm p-1" id="increaseDate"
                                    onclick="_next_date();">
                                    <span class="mdi mdi-chevron-right text-dark"></span>
                                </button>
                            </div>
                        </div>
                        <div class="p-2 ">
                            <button class="btn btn-outline-light text-dark border p-1" onclick="_today();">Today</button>
                        </div>
                        <div class="p-2 ">
                            <select class="form-select p-1  w-px-100" id="scheduler_mode" onchange="_change_mode();">
                                <option value="Week" selected>Week</option>
                                <option value="2 Week">2 Week</option>
                            </select>
                        </div>
                        <div class="p-2">
                            <select class="form-select p-1  w-px-100" id="user_type" onchange="_change_mode();">
                                <option value="">Type</option>
                                <option value="0">Internal</option>
                                <option value="1">External</option>
                            </select>
                        </div>

                        <div class="p-2 me-auto">
                            <button type="button" class="btn btn-outline-light p-1 text-dark"
                                onclick="_history_modal();">History</button>
                        </div>

                        <div class="p-2">
                            <select class="form-select p-1  w-px-350" id="emp_id" multiple  onchange="_change_mode();" >
                                @if (in_array('Roster Maintain', Session::get('permissions')))
                                    @php
                                        $recipents = EmpCompanyDetails::query();
                                        $recipents->where('id', '!=', '1');
                                        $recipents->where('del', '0');
                                        $recipents->where('compeleted', '1');
                                        $recipents->where('approved', '1');
                                        $recipents->where('status', '1');
                                        $recipents->with([
                                            'empPersonalDetails' => function ($recipents) {
                                                $recipents->select(
                                                    'emp_id',
                                                    'first_name',
                                                    'middle_name',
                                                    'last_name',
                                                    'image',
                                                    );
                                                    },
                                                ]);
                                                $recipents_users = $recipents->get();
                                                @endphp
                                                @foreach ($recipents_users as $recipents_user)
                                                    <option
                                                        value="{{ $recipents_user->empPersonalDetails->emp_id }}">
                                                        {{ $recipents_user->empPersonalDetails->first_name }}
                                                        {{ $recipents_user->empPersonalDetails->middle_name }}
                                                        {{ $recipents_user->empPersonalDetails->last_name }}</option>
                                                @endforeach
                                @endif                                
                            </select>
                        </div>
                    </div>
                
                </div>

                <div class="mt-3">
                    <div class="append_table ">
                        <div class="table-responsive text-nowrap mt-3 border-bottom">
                            <table class="table table-bordered">
                                <thead class="bg-light">
                                    <tr>
                                        <th>CUSTOM</th>
                                        <th>-</th>
                                        <th>-</th>
                                        <th>-</th>
                                        <th>-</th>
                                        <th>-</th>
                                        <th>-</th>
                                        <th>-</th>
                                    </tr>
                                </thead>
                                <tbody class="table-border-bottom-0">
                                    <td colspan="8" class="text-center">

                                        No data yet

                                    </td>
                                </tbody>
                                <tfoot class="bg-light">
                                    <tr>
                                        <th>

                                            <select class="form-select select_ p-1" aria-label="Default select example"
                                                style="font-size: 12px;">
                                                <option selected>Assigned total 0hours</option>
                                                <option value="1">One</option>
                                                <option value="2">Two</option>
                                                <option value="3">Three</option>
                                            </select>
                                        </th>
                                        <th>0</th>
                                        <th>0</th>
                                        <th>0</th>
                                        <th>0</th>
                                        <th>0</th>
                                        <th>0</th>
                                        <th>0</th>
                                    </tr>
                                </tfoot>
                            </table>
                        </div>
                    </div>

                </div>
            </div>
        </div>
    </div>
    <!-- Modal -->
    <div class="modal fade" id="scheduler_model" data-bs-backdrop="static" data-bs-keyboard="false" tabindex="-1"
        aria-labelledby="scheduler_model_Label" aria-hidden="true">
        <div class="modal-dialog  modal-lg modal-dialog-centered">
            <div class="modal-content">
                <div class="modal-header border-bottom mb-2">
                    <h5 class="modal-title modal_title" id="scheduler_model_Label"></h5>
                    <div class="mb-2">
                        <button type="button" class="btn-close border" data-bs-dismiss="modal"
                            aria-label="Close"></button>
                    </div>
                </div>
                <div class="modal-body">
                    <div class="row">
                        <div class="col-12">
                            <div class="mb-3">
                                <label for="assing_to" class="form-label">Assign To</label>
                                <input value="" id="scheduler_h_date" type="hidden">
                                <input value="" id="scheduler_template_id" type="hidden">
                                <input value="" id="scheduler_edit" type="hidden">
                                <input value="0" id="scheduler_publish" type="hidden">

                                <select class="form-select" aria-label="Default select example" id="scheduler_assing_to">
                                    <option value="">--Select Employee--</option>

                                    @php
                                        $query = EmpCompanyDetails::query();
                                        $query->where('id', '!=', '1');
                                        $query->where('del', '0');
                                        $query->where('compeleted', '1');
                                        $query->where('approved', '1');
                                        $query->where('status', '1');
                                        $query->with([
                                            'empPersonalDetails' => function ($query) {
                                                $query->select(
                                                    'emp_id',
                                                    'first_name',
                                                    'middle_name',
                                                    'last_name',
                                                    'image',
                                                );
                                            },
                                        ]);

                                        $assign_to_users = $query->get();
                                    @endphp

                                    @foreach ($assign_to_users as $assign_to_user)
                                        <option value="{{ $assign_to_user->empPersonalDetails->emp_id }}">
                                            {{ $assign_to_user->empPersonalDetails->first_name }}
                                            {{ $assign_to_user->empPersonalDetails->middle_name }}
                                            {{ $assign_to_user->empPersonalDetails->last_name }}</option>
                                    @endforeach



                                </select>
                            </div>
                        </div>
                        <div class="col-lg-6 col-sm-12">
                            <label for="scheduler_time" class="form-label">Time</label>
                            <div class="input-group">
                                <input type="time" aria-label="First name" id="scheduler_start_time"
                                    class="form-control">
                                <input type="time" aria-label="Last name" id="scheduler_end_time"
                                    class="form-control">
                            </div>
                        </div>
                        <div class="col-lg-4 col-md-6">
                            <div class="mb-3">
                                <label for="" class="form-label">Paid Break</label>
                                <div class="input-group mb-3">
                                    <input type="text" class="form-control" aria-label="Sizing example input"
                                        id="scheduler_paid_break" value="0" aria-describedby="inputGroup-sizing-sm">
                                    <span class="input-group-text" id="inputGroup-sizing-sm">mins</span>
                                </div>
                            </div>
                        </div>
                        <div class="col-lg-4 col-md-6">
                            <div class="mb-3">
                                <label for="" class="form-label">Total Required Hours</label>
                                <div class="input-group mb-3">
                                    <input type="text" class="form-control" aria-label="Sizing example input"
                                        id="scheduler_total_required_hours" value="0" aria-describedby="inputGroup-sizing-sm">
                                    <span class="input-group-text" id="inputGroup-sizing-sm">hours</span>
                                </div>
                            </div>
                        </div>
                        <div class="col-2">
                            <div class="mb-3">
                                <label for="scheduler_unpaid_break" class="form-label">Pick Color</label>
                                <input type="color" name="favcolor" value="#ff0000"
                                    class="custom-color-input border-0 rounded-circle" id="scheduler_pick_color">
                            </div>
                        </div>
                        <div class="col-12">
                            <div class="mb-3">
                                <label for="scheduler_message" class="form-label">Message</label>
                                <textarea class="form-control" id="scheduler_message" rows="3"></textarea>
                            </div>
                        </div>
                        <div class="col-lg-4 col-sm-12 d-none">
                            <div class="form-check">
                                <input type="hidden" value="" id="old_scheduler_repeat_shift">
                                <input class="form-check-input" type="checkbox" value=""
                                    id="scheduler_repeat_shift">
                                <label class="form-check-label" for="repeat_shift">
                                    REPEAT SHIFT
                                </label>
                            </div>
                        </div>
                        <div class="col-lg-6 col-sm-12">
                            <div class="form-check">
                                <input class="form-check-input ms-0" type="checkbox" value=""
                                    id="scheduler_save_shift_template">
                                <label class="form-check-label ms-2" for="save_shift_template">
                                    SAVE AS SHIFT TEMPLATE
                                </label>
                            </div>
                        </div>
                        <div class="row hide_every_week  d-none">
                            <div class="col-lg-6 col-sm-12">
                                <div class="mb-3">
                                    <label for="scheduler_repeat_every" class="form-label">REPEAT EVERY</label>
                                    <select class="form-select" aria-label="Default select example"
                                        id="scheduler_repeat_every">
                                        <option value="1">Every Week</option>
                                        <option value="2">Every 2 Week</option>
                                    </select>
                                </div>
                            </div>
                            <div class="col-lg-6 col-sm-12">
                                <div class="mb-3">
                                    <label for="scheduler_ending" class="form-label">ENDING</label>
                                    <input id="scheduler_ending" name="ending_date" class="form-control" value=""
                                        type="date" />
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
                <div class="modal-footer border-top">
                    <!-- <button type="button" class="btn btn-outline-info" onclick="_if_repeating_shift(1);">Save &
                        Publish</button> -->
                    <button type="button" class="btn btn-primary" onclick="_if_repeating_shift(0);">Save</button>
                </div>
            </div>
        </div>
    </div>



    <!-- Modal -->
    <div class="modal fade" id="bulk_scheduler_model" data-bs-backdrop="static" data-bs-keyboard="false" tabindex="-1"
        aria-labelledby="scheduler_model_Label" aria-hidden="true">
        <div class="modal-dialog  modal-lg modal-dialog-centered">
            <div class="modal-content">
                <div class="modal-header border-bottom mb-2">
                    <h5 class="modal-title modal_title" id="bulk_scheduler_model_Label">Bulk Scheduler</h5>
                    <div class="mb-2">
                        <button type="button" class="btn-close border" data-bs-dismiss="modal"></button>
                    </div>
                </div>
                <div class="modal-body">
                    <div class="row">

                        <div class="col-lg-4 col-sm-12">
                            <label for="" class="form-label">Start Date</label>
                            <input type="date" id="bulk_scheduler_start_date" class="form-control">
                        </div>

                        <div class="col-lg-4 col-sm-12">
                            <label for="" class="form-label">End Date</label>
                            <input type="date" id="bulk_scheduler_end_date" class="form-control">
                        </div>


                        <div class="col-lg-2 col-sm-12 ms-5">
                            <div class="mb-3">
                                <label for="" class="form-label">Pick Color</label>
                                <input type="color" name="favcolor" value="#ff0000"
                                    class="custom-color-input border-0 rounded-circle" id="bulk_scheduler_pick_color">
                            </div>
                        </div>

                        <div class="col-lg-4 col-sm-12">
                            <label for="" class="form-label">Start Time</label>
                            <input type="time" id="bulk_scheduler_start_time" class="form-control">
                        </div>

                        <div class="col-lg-4 col-sm-12">
                            <label for="scheduler_time" class="form-label">End Time</label>
                            <div class="input-group">
                                <input type="time" id="bulk_scheduler_end_time" class="form-control">
                            </div>
                        </div>


                        <div class="col-lg-4 col-md-6">
                            <div class="mb-3">
                                <label for="" class="form-label">Paid Break</label>
                                <div class="input-group mb-3">
                                    <input type="text" class="form-control" aria-label="Sizing example input"
                                        id="bulk_scheduler_paid_break" value="0"
                                        aria-describedby="inputGroup-sizing-sm">
                                    <span class="input-group-text" id="inputGroup-sizing-sm">mins</span>
                                </div>
                            </div>
                        </div>



                        <div class="col-8">
                            <h6 class="mt-4 mb-3">Select Days</h6>
                            <div class="work-day d-flex flex-wrap gap-2 mb-2">

                                <div class="">
                                    <input class="form-check-input res-checkbox working-days d-none" type="checkbox"
                                        value="Mon" id="Monday-working-days">
                                    <label class="form-check-label btn res-btn btn-outline-secondary"
                                        for="Monday-working-days">Mon</label>
                                </div>

                                <div class="">
                                    <input class="form-check-input res-checkbox  working-days d-none" type="checkbox"
                                        value="Tue" id="Tuesday-working-days">
                                    <label class="form-check-label btn res-btn btn-outline-secondary"
                                        for="Tuesday-working-days">Tue</label>
                                </div>

                                <div class="">
                                    <input class="form-check-input  res-checkbox  working-days d-none" type="checkbox"
                                        value="Wed" id="Wednesday-working-days">
                                    <label class="form-check-label btn res-btn btn-outline-secondary"
                                        for="Wednesday-working-days">Wed</label>
                                </div>

                                <div class="">
                                    <input class="form-check-input res-checkbox  working-days d-none" type="checkbox"
                                        value="Thu" id="Thursday-working-days">
                                    <label class="form-check-label btn res-btn btn-outline-secondary"
                                        for="Thursday-working-days">Thu</label>
                                </div>

                                <div class="">
                                    <input class="form-check-input  res-checkbox  working-days d-none" type="checkbox"
                                        value="Fri" id="Friday-working-days">
                                    <label class="form-check-label btn res-btn btn-outline-secondary"
                                        for="Friday-working-days">Fri</label>
                                </div>

                                <div class="">
                                    <input class="form-check-input res-checkbox  working-days d-none" type="checkbox"
                                        value="Sat" id="Saturday-working-days">
                                    <label class="form-check-label btn res-btn btn-outline-secondary"
                                        for="Saturday-working-days">Sat</label>
                                </div>

                                <div class="">
                                    <input class="form-check-input res-checkbox  res-lable working-days d-none"
                                        type="checkbox" value="Sun" id="Sunday-working-days">
                                    <label class="form-check-label btn res-btn btn-outline-secondary"
                                        for="Sunday-working-days">Sun</label>
                                </div>
                                <input type="hidden" value="" id="working_days_hidden" name="working_days">
                            </div>
                        </div>
                        <div class="col-lg-4 col-md-6">
                            <div class="mt-4 mb-3">
                                <label for="" class="form-label">Total Required Hours</label>
                                <div class="input-group mb-3">
                                    <input type="text" class="form-control" aria-label="Sizing example input"
                                        id="scheduler_total_required_hours_bulk" value="0" aria-describedby="inputGroup-sizing-sm">
                                    <span class="input-group-text" id="inputGroup-sizing-sm">hours</span>
                                </div>
                            </div>
                        </div>

                        <div class="col-12">
                            <div class="mb-3">
                                <label for="" class="form-label">Message</label>
                                <textarea class="form-control" id="bulk_scheduler_message" rows="3"></textarea>
                            </div>
                        </div>
                        <div class="col-12">
                            <input type="text" class="form-control" placeholder="Search Employee"
                                id="bluk_search_bar" value="">
                        </div>
                        <div class="col-12">
                            <div class="mb-3 table-container-assign">

                                <!-- bulk_scheduler_assing_to -->
                                <table class="table table-assign">
                                    <thead class="thead-assign">
                                        <tr>
                                            <th class="th-assign"><input type="checkbox" value=""
                                                    class="bulk_scheduler_checkbox_all"></th>
                                            <th class="th-assign">Name</th>
                                            <th class="th-assign">Role</th>
                                        </tr>
                                    </thead>
                                    <tbody id="bluk_tbody">



                                        @php
                                            $query = EmpCompanyDetails::query();
                                            $query->where('id', '!=', '1');
                                            $query->where('del', '0');
                                            $query->where('compeleted', '1');
                                            $query->where('approved', '1');
                                            $query->where('status', '1');
                                            $query->with([
                                                'accessRole' => function ($query) {
                                                    $query->select('id', 'title', 'code');
                                                },
                                            ]);
                                            $query->with([
                                                'empPersonalDetails' => function ($query) {
                                                    $query->select(
                                                        'emp_id',
                                                        'first_name',
                                                        'middle_name',
                                                        'last_name',
                                                        'image',
                                                    );
                                                },
                                            ]);

                                            $assign_to_users = $query->get();
                                        @endphp

                                        @foreach ($assign_to_users as $assign_to_user)
                                            <tr>
                                                <td class="td-assign"><input type="checkbox"
                                                        class="bulk_scheduler_checkbox"
                                                        value="{{ $assign_to_user->empPersonalDetails->emp_id }}"></th>
                                                <td class="td-assign">
                                                    {{ $assign_to_user->empPersonalDetails->first_name }}
                                                    {{ $assign_to_user->empPersonalDetails->middle_name }}
                                                    {{ $assign_to_user->empPersonalDetails->last_name }}</td>
                                                <td class="td-assign">
                                                    {{ $assign_to_user->accessRole ? $assign_to_user->accessRole->title : '-' }}
                                                </td>
                                            </tr>
                                        @endforeach

                                    </tbody>
                                </table>


                            </div>
                        </div>
                    </div>
                </div>
                <div class="modal-footer border-top">
                    <button type="button" class="btn btn-primary" onclick="_bulk_schedule_save();">Save</button>
                </div>
            </div>
        </div>
    </div>


    <!-- BULK DELETE MADAL -->
    <div class="modal fade" id="bulk_delete_model" data-bs-backdrop="static" data-bs-keyboard="false" tabindex="-1"
        aria-labelledby="scheduler_model_Label" aria-hidden="true">
        <div class="modal-dialog  modal-lg modal-dialog-centered">
            <div class="modal-content">
                <div class="modal-header border-bottom mb-2">
                    <h5 class="modal-title modal_title" id="bulk_scheduler_model_Label">Bulk Delete</h5>
                    <div class="mb-2">
                        <button type="button" class="btn-close border" data-bs-dismiss="modal"></button>
                    </div>
                </div>
                <div class="modal-body">
                    <div class="row">
                        <div class="col-lg-6 col-sm-12">
                            <label for="" class="form-label">Start Time</label>
                            <input type="time" id="bulk_delete_start_time" class="form-control">
                        </div>
                        <div class="col-lg-6 col-sm-12">
                            <label for="" class="form-label">End Time</label>
                            <input type="time" id="bulk_delete_end_time" class="form-control">
                        </div>

                        <div class="col-lg-6 col-sm-12 mt-2">
                            <label for="" class="form-label">Start Date</label>
                            <input type="date" id="bulk_delete_start_date" class="form-control">
                        </div>

                        <div class="col-lg-6 col-sm-12 mt-2">
                            <label for="" class="form-label">End Date</label>
                            <input type="date" id="bulk_delete_end_date" class="form-control">
                        </div>

                        <div class="col-12 mt-3">
                            <input type="text" class="form-control" placeholder="Search Employee"
                                id="bulk_delete_search_bar" value="">
                        </div>
                        <div class="col-12">
                            <div class="mb-3 table-container-assign">

                                <!-- bulk_scheduler_assing_to -->
                                <table class="table table-assign">
                                    <thead class="thead-assign">
                                        <tr>
                                            <th class="th-assign"><input type="checkbox" value=""
                                                    class="bulk_delete_checkbox_all"></th>
                                            <th class="th-assign">Name</th>
                                            <th class="th-assign">Role</th>
                                        </tr>
                                    </thead>
                                    <tbody id="bulk_delete_tbody">



                                        @php
                                            $query = EmpCompanyDetails::query();
                                            $query->where('id', '!=', '1');
                                            $query->where('del', '0');
                                            $query->where('compeleted', '1');
                                            $query->where('approved', '1');
                                            $query->where('status', '1');
                                            $query->with([
                                                'accessRole' => function ($query) {
                                                    $query->select('id', 'title', 'code');
                                                },
                                            ]);
                                            $query->with([
                                                'empPersonalDetails' => function ($query) {
                                                    $query->select(
                                                        'emp_id',
                                                        'first_name',
                                                        'middle_name',
                                                        'last_name',
                                                        'image',
                                                    );
                                                },
                                            ]);

                                            $assign_to_users = $query->get();
                                        @endphp

                                        @foreach ($assign_to_users as $assign_to_user)
                                            <tr>
                                                <td class="td-assign"><input type="checkbox" class="bulk_delete_checkbox"
                                                        value="{{ $assign_to_user->empPersonalDetails->emp_id }}"></th>
                                                <td class="td-assign">
                                                    {{ $assign_to_user->empPersonalDetails->first_name }}
                                                    {{ $assign_to_user->empPersonalDetails->middle_name }}
                                                    {{ $assign_to_user->empPersonalDetails->last_name }}</td>
                                                <td class="td-assign">
                                                    {{ $assign_to_user->accessRole ? $assign_to_user->accessRole->title : '-' }}
                                                </td>
                                            </tr>
                                        @endforeach

                                    </tbody>
                                </table>


                            </div>
                        </div>
                    </div>
                </div>
                <div class="modal-footer border-top">
                    <button type="button" class="btn btn-danger" onclick="bulk_delete();">Delete</button>
                </div>
            </div>
        </div>
    </div>

    <!-- request_time_off_model -->
    <div class="modal fade" id="request_time_off" tabindex="-1" aria-labelledby="exampleModalLabel"
        aria-hidden="true">
        <div class="modal-dialog modal-dialog-centered">
            <div class="modal-content">
                <div class="modal-header border-bottom">
                    <h5 class="modal-title mb-2" id="exampleModalLabel">Apply Leave</h5>
                    <button type="button" class="btn-close border mb-2" data-bs-dismiss="modal"
                        aria-label="Close"></button>
                </div>
                <div class="modal-body">
                    <div class="row">
                        <div class="col-12">
                            <div class="mb-3">
                                <form id="leave-request-form" method="post">

                                    <label for="scheduler_assing_to" class="form-label">WHO</label>
                                    <input type="hidden" value="" id="leave_request_id">
                                    <select class="form-select" aria-label="Default select example"
                                        id="leave_request_employee" name="employee" data-live-search="true">
                                        <option value=""> --Select Employee-- </option>

                                        @php
                                            $query = EmpCompanyDetails::query();
                                            $query->where('id', '!=', '1');
                                            $query->where('del', '0');
                                            $query->where('compeleted', '1');
                                            $query->where('approved', '1');
                                            $query->where('status', '1');
                                            $query->with([
                                                'empPersonalDetails' => function ($query) {
                                                    $query->select(
                                                        'emp_id',
                                                        'first_name',
                                                        'middle_name',
                                                        'last_name',
                                                        'image',
                                                    );
                                                },
                                            ]);

                                            $leave_users = $query->get();
                                        @endphp

                                        @foreach ($leave_users as $leave_user)
                                            <option value="{{ $leave_user->empPersonalDetails->emp_id }}">
                                                {{ $leave_user->empPersonalDetails->first_name }}
                                                {{ $leave_user->empPersonalDetails->middle_name }}
                                                {{ $leave_user->empPersonalDetails->last_name }}</option>
                                        @endforeach
                                    </select>
                            </div>
                        </div>
                        <div class="col-8">
                            <div class="mb-3">
                                <label for="scheduler_time_of_type" class="form-label">Leave Package</label>
                                <select class="form-select" aria-label="Default select example"
                                    id="leave_request_leave_package" name="leave_package">
                                    <option value="">--Select--</option>
                                </select>
                            </div>
                        </div>
                        <div class="col-4">
                            <div class="form-check" style="margin-top: 35px;">
                                <input type="hidden" value="0" name="full_day">
                                <input class="form-check-input" type="checkbox" value="1" checked
                                    id="leave_request_full_day" onclick="_leave_request_full_day(this.checked);"
                                    name="full_day">
                                <label class="form-check-label" for="scheduler_full_day">
                                    Full Day
                                </label>
                            </div>
                        </div>

                        <div class="col-lg-6 col-sm-12 block_start_date ">
                            <div class="mb-3">
                                <label for="scheduler_start_date" class="form-label">START DATE</label>
                                <input id="leave_request_start_date" name="start_date"
                                    onchange="leave_request_start_date_change(this);" class="form-control"
                                    type="date" />
                            </div>
                        </div>
                        <div class="col-lg-6 col-sm-12 block_end_date">
                            <div class="mb-3">
                                <label for="scheduler_end_date" class="form-label">END DATE</label>
                                <input id="leave_request_end_date" name="end_date" class="form-control"
                                    type="date" />
                            </div>
                        </div>
                        <div class="col-lg-6 col-sm-12 block_start_time">
                            <div class="mb-3">
                                <label for="scheduler_start_date " class="form-label">START TIME</label>
                                <input id="leave_request_start_time" name="start_time" class="form-control"
                                    type="time" />
                            </div>
                        </div>
                        <div class="col-lg-6 col-sm-12 block_end_time">
                            <div class="mb-3">
                                <label for="scheduler_end_date" class="form-label">END TIME</label>
                                <input id="leave_request_end_time" name="end_time" class="form-control"
                                    type="time" />
                            </div>
                        </div>
                        <div class="col-12">
                            <div class="mb-3">
                                <label for="scheduler_request_message" class="form-label">Reason</label>
                                <textarea class="form-control" id="leave_request_reason" name="reason" rows="3"></textarea>
                            </div>
                        </div>
                    </div>
                </div>
                <div class="modal-footer border-top">
                    <button type="button" class="btn btn-primary" onclick="_leave_request_store();">Send
                        Request</button>
                </div>
            </div>
        </div>
    </div>

    <div class="modal fade" id="scheduler_template_model" tabindex="-1" aria-labelledby="exampleModalLabel"
        aria-hidden="true">
        <div class="modal-dialog modal-dialog-centered  modal-lg">
            <div class="modal-content">
                <div class="modal-header  border-bottom">
                    <h5 class="modal-title modal_title" id="exampleModalLabel"></h5>
                    <div class="mb-2">
                        <button type="button" class="btn btn-outline-light p-1 text-dark"
                            onclick="_request_time_off_modal();">Apply Leave</button>
                        <button type="button" class="btn-close border" data-bs-dismiss="modal"
                            aria-label="Close"></button>
                    </div>
                </div>
                <div class="modal-body">
                    <div class="row append_templates">

                    </div>
                    <div class="col-lg-12 col-md-8 col-sm-4  border-top">
                        <div class="input-group mb-3 mt-3" style="width: 300px;"
                            onclick="$('#scheduler_template_model').modal('hide'); _template_modal($('#scheduler_hidden_date').val(),$('#scheduler_hidden_user').val(),0,0,'');">
                            <input type="hidden" value="" id="scheduler_hidden_date">
                            <input type="hidden" value="" id="scheduler_hidden_user">
                            <a href="#" class="btn btn-success active" aria-current="page">Create a custome
                                shift</a>
                            <a href="#" class="btn btn-success btn-sm"><span
                                    class="mdi mdi-plus-circle-outline"></span></a>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>





    <div class="modal fade" id="scheduler_to_all_shift_model" tabindex="-1" aria-labelledby="exampleModalLabel"
        aria-hidden="true">
        <div class="modal-dialog modal-dialog-centered  modal-lg">
            <div class="modal-content">
                <div class="modal-header  border-bottom">
                    <h5 class="modal-title" id="exampleModalLabel">Save shift</h5>
                    <div class="mb-2">
                        <button type="button" class="btn-close border" data-bs-dismiss="modal"
                            aria-label="Close"></button>
                    </div>
                </div>
                <div class="modal-body">
                    <div class="row ">

                        <p>You updated a repeating shift. Do you want to update all instances or just this one?</p>
                        <p>Updating all will update shifts in this series set beyond today's date.</p>
                    </div>
                    <div class="col-lg-12 col-md-8 col-sm-4  border-top">
                        <button type="button" class="btn btn-primary btn-sm mt-3"
                            onclick="_update_repeat_shift_and_publish($('#scheduler_publish').val(),'1');">Apply To
                            All</button>
                        <button type="button" class="btn btn-primary btn-sm mt-3"
                            onclick="_save_shift_and_publish($('#scheduler_publish').val());">Apply To One</button>
                        <button type="button" class="btn btn-secondary btn-sm ms-auto me-0 mt-3"
                            data-bs-dismiss="modal">Close</button>
                    </div>
                </div>
            </div>
        </div>
    </div>

    <div class="modal fade" id="scheduler_delete_all_shift_model" tabindex="-1" aria-labelledby="exampleModalLabel"
        aria-hidden="true">
        <div class="modal-dialog modal-dialog-centered  modal-lg">
            <div class="modal-content">
                <div class="modal-header  border-bottom">
                    <h5 class="modal-title" id="exampleModalLabel">Delete shift</h5>
                    <div class="mb-2">
                        <button type="button" class="btn-close border" data-bs-dismiss="modal"
                            aria-label="Close"></button>
                    </div>
                </div>
                <div class="modal-body">
                    <div class="row">

                        <p>You are deleting a recurring shift. Do you want to delete all future shifts or just this one?</p>
                        <p>Deleting all will remove shifts in this series set beyond this date.</p>

                    </div>
                    <div class="col-lg-12 col-md-8 col-sm-4  border-top">
                        <button type="button" class="btn btn-danger btn-sm mt-3" onclick="_shift_delete(1);">Delete
                            All</button>
                        <button type="button" class="btn btn-danger btn-sm mt-3" onclick="_shift_delete(0);">Delete
                            One</button>
                        <button type="button" class="btn btn-secondary btn-sm ms-auto me-0 mt-3"
                            data-bs-dismiss="modal">Close</button>
                    </div>
                </div>
            </div>
        </div>
    </div>


    <div class="modal fade" id="scheduler_delete_shift_model" tabindex="-1" aria-labelledby="" aria-hidden="true">
        <div class="modal-dialog modal-dialog-centered">
            <div class="modal-content">
                <div class="modal-header bg-danger px-4 py-2">
                    <h5 class="modal-title text-white" id="">Delete Shift</h5>
                </div>
                <div class="modal-body">
                    Are you sure you want to delete this shift?<br><br>
                    <b class="text-warning">Warning:</b> This shift will no longer be available. Please ensure you
                    genuinely want to delete it before clicking the delete button.
                </div>
                <div class="modal-footer border-top py-2">
                    <button type="button" class="btn btn-sm  btn-danger" onclick="_shift_delete(0);">Delete</button>
                    <button type="button" class="btn btn-sm  btn-outline-dark" data-bs-dismiss="modal">Close</button>
                </div>
            </div>
        </div>
    </div>


    <div class="modal fade" id="History" tabindex="-1" aria-labelledby="" aria-hidden="true">
        <div class="modal-dialog modal-dialog-centered">
            <div class="modal-content">
                <div class="modal-header bg-primary px-4 py-2">
                    <h5 class="modal-title text-white" id="">History</h5>
                </div>

                <div class="modal-body history-div" style="min-height:70vh;max-height:70vh;overflow-y: scroll;">


                </div>

                <div class="modal-footer border-top py-2">
                    <button type="button" class="btn btn-outline-dark" data-bs-dismiss="modal">Close</button>
                </div>
            </div>
        </div>
    </div>


    <input type="hidden" value="" id="scheduler_delete_repeat_shift">
    <input type="hidden" value="" id="scheduler_delete_date">
    <input type="hidden" value="" id="scheduler_delete_template_id">
    <input type="hidden" value="" id="scheduler_delete_user_id">



@endsection






@section('css-js')
    <style>
        .roster-detail {
            display: flex;
        }

        @media only screen and (min-width: 280px) and (max-width: 768px) {
            .roster-detail {
                display: block;
            }

        }
        @media only screen and (min-width: 280px) and (max-width: 480px) {
            .publish-notify-dropdown{
                inset: 0px auto auto -199px !important;
            }
        }
    </style>








    <script>
         function customMatcher(params, data) {
        if ($.trim(params.term) === '') {
            return data;
        }

        var term = params.term.toLowerCase();
        var optionText = data.text.toLowerCase();

        var nameParts = term.split(' ');

        for (var i = 0; i < nameParts.length; i++) {
            if (optionText.indexOf(nameParts[i]) === -1) {
                return null;
            }
        }

        return data;
    }
        $(document).ready(function() {
            $(document).ready(function() {
            $('#emp_id').select2({
                placeholder: "Select Employees",
                width: 'resolve',
                matcher: customMatcher 
            });
        });
 
       
      

            var s2 = $('#scheduler_notify_recipents').select2();
            $('#emp_id').select2({
                placeholder: "Select Employees",
                width: 'resolve',
                matcher: customMatcher 
            });

            $("#scheduler_repeat_shift").change(function() {
                if (this.checked) {
                    $(".hide_every_week").removeClass("d-none");
                } else {
                    $(".hide_every_week").addClass("d-none");
                }
            });

        });

        $(document).ready(function() {


            $('#scheduler_date').datepicker({
                uiLibrary: 'bootstrap5'
            });

            $('#scheduler_date').next().remove();
            $('.gj-datepicker').removeClass('mb-3');
            _today();

            var tooltipTriggerList = [].slice.call(document.querySelectorAll('[data-bs-toggle="tooltip1"]'));
            var tooltipList = tooltipTriggerList.map(function(tooltipTriggerEl) {
                return new bootstrap.Tooltip(tooltipTriggerEl);
            });


        });

        function _date_today() {
            var today = new Date();
            var dd = String(today.getDate()).padStart(2, '0');
            var mm = String(today.getMonth() + 1).padStart(2, '0');
            var yyyy = today.getFullYear();
            return `${mm}/${dd}/${yyyy}`;

        }

        function _today() {
            $('#scheduler_date').attr('value', _date_today());
            var date_list = _get_selected_dateRange();
            $(".full_date").html(date_list.full_date);
            _get_scheduler(date_list.start_date, date_list.end_date);

        }

        function _onchange_date(date) {
            $('#scheduler_date').attr('value', date);
            var date_list = _get_selected_dateRange();
            $(".full_date").html(date_list.full_date);
            _get_scheduler(date_list.start_date, date_list.end_date);
        }


        

        function _next_date() {
            var date_list = _get_selected_dateRange();
            var currentDate = new Date(date_list.end_date);
            var nextDate = new Date(date_list.end_date);
            nextDate.setDate(currentDate.getDate() + 1);
            var options = {
                month: '2-digit',
                day: '2-digit',
                year: 'numeric'
            };
            var formattedNextDate = nextDate.toLocaleDateString('en-AU', options);
            var _date = formattedNextDate.split('/');
            _onchange_date(`${_date[1]}/${_date[0]}/${_date[2]}`);
        }

        function _prev_date() {
            var date_list = _get_selected_dateRange();
            var currentDate = new Date(date_list.start_date);
            var prevDate = new Date(date_list.start_date);
            prevDate.setDate(currentDate.getDate() - 1);
            var options = {
                month: '2-digit',
                day: '2-digit',
                year: 'numeric'
            };
            var formattedPrevDate = prevDate.toLocaleDateString('en-AU', options);
            var _date = formattedPrevDate.split('/');
            _onchange_date(`${_date[1]}/${_date[0]}/${_date[2]}`);
        }

        function _change_mode() {
            var date_list = _get_selected_dateRange();
            $(".full_date").html(date_list.full_date);
            _get_scheduler(date_list.start_date, date_list.end_date);
        }


        function _get(from) {
            $('#from').val(from);
            var date_list = _get_selected_dateRange();
            $(".full_date").html(date_list.full_date);
            _get_scheduler(date_list.start_date, date_list.end_date);

        }

        function _get_scheduler(start_date, end_date) {
            var scheduler_mode = $('#scheduler_mode').val();
            var selectEmployee = $('#emp_id').val();
           
            $.ajax({
                type: "GET",
                url: `{{ url('/api/roaster') }}`,
                headers: {
                    'X-CSRF-TOKEN': '{{ csrf_token() }}'
                },
                data: {
                    'start_date': yyyy_mm_dd(start_date),
                    'end_date': yyyy_mm_dd(end_date),
                    'scheduler_mode': scheduler_mode,
                    'user_type': $('#user_type').val(),
                    'from': $('#from').val(),
                    'selected_employee': selectEmployee,
                },
                success: function(response) {
                   
                  

                    $('.append_table').html(response.data.html);
                  
                },
                error: function(response) {

                    console.log(response);


                    if (response.status == 500) {
                        toastr.error("Something went wrong")
                    } else {
                        toastr.error(response.responseJSON.message)
                    }
                }
            });

        }

        function _get_selected_dateRange() {

            var scheduler_mode = $('#scheduler_mode').val();
            var selected_date = new Date($('#scheduler_date').attr('value'));
            var startDate = ''
            var endDate = '';

            switch (scheduler_mode) {
                case 'Day':
                    startDate = selected_date;
                    endDate = selected_date;
                    full_date = _full_day_date(selected_date);
                    break;

                case 'Week':
                    startDate = new Date(selected_date);
                    startDate.setDate(selected_date.getDate() - selected_date.getDay());
                    endDate = new Date(startDate);

                    endDate.setDate(startDate.getDate() + 6);

                    full_date = _full_date(startDate, endDate);
                    break;

                case '2 Week':
                    startDate = new Date(selected_date);
                    startDate.setDate(selected_date.getDate() - selected_date.getDay());
                    endDate = new Date(startDate);
                    endDate.setDate(startDate.getDate() + 13);
                    full_date = _full_date(startDate, endDate);
                    break;

                case 'Month':
                    startDate = new Date(selected_date.getFullYear(), selected_date.getMonth(), 1);
                    endDate = new Date(selected_date.getFullYear(), selected_date.getMonth() + 1, 0);
                    full_date = _full_month_date(startDate, endDate);
                    break;
            }



            return {
                start_date: startDate.toDateString(),
                end_date: endDate.toDateString(),
                full_date: full_date
            }
        }

        function _full_day_date(inputDateString) {
            var inputDate = new Date(inputDateString);

            var monthNames = [
                'January', 'February', 'March', 'April', 'May', 'June', 'July',
                'August', 'September', 'October', 'November', 'December'
            ];

            var day = inputDate.getDate();
            var month = monthNames[inputDate.getMonth()];
            var year = inputDate.getFullYear();

            var dayNames = ['Sun', 'Mon', 'Tue', 'Wed', 'Thu', 'Fri', 'Sat'];

            var dayName = dayNames[inputDate.getDay()];

            return `${dayName}, ${month} ${day}, ${year}`;

        }

        function _full_date(startDateString, endDateString) {
            const startDate = new Date(startDateString);
            const endDate = new Date(endDateString);

            const months = [
                "Jan", "Feb", "Mar", "Apr", "May", "Jun",
                "Jul", "Aug", "Sep", "Oct", "Nov", "Dec"
            ];

            const formattedStartDate = `${months[startDate.getMonth()]} ${startDate.getDate()}`;
            const formattedEndDate = `${months[endDate.getMonth()]} ${endDate.getDate()}, ${endDate.getFullYear()}`;

            return `${formattedStartDate} - ${formattedEndDate}`;

        }

        function _full_month_date(startDate, endDate) {
            // Convert string dates to Date objects
            const startDateObj = new Date(startDate);
            const endDateObj = new Date(endDate);

            // Get month and year from the start date
            const month = startDateObj.toLocaleString('en-US', {
                month: 'long'
            });
            const year = startDateObj.getFullYear();

            // Check if the start and end dates have the same month and year
            if (startDateObj.getMonth() === endDateObj.getMonth() && startDateObj.getFullYear() === endDateObj
                .getFullYear()) {
                return `${month} ${year}`;
            } else {
                // If different, include both start and end dates
                const endMonth = endDateObj.toLocaleString('en-US', {
                    month: 'long'
                });
                const endYear = endDateObj.getFullYear();
                return `${month} ${year} - ${endMonth} ${endYear}`;
            }
        }

        function _template_modal(date, user_id, is_template, template_id, edit) {

            var dateObject = new Date(date);
            var options = {
                year: 'numeric',
                month: 'short',
                day: 'numeric'
            };

            if (edit == 'edit') {
                $('.modal_title').html('Edit Shift for ' + $('.userId' + user_id).html() + ' at ' + dateObject
                    .toLocaleDateString('en-AU', options));
            } else {
                $('.modal_title').html('Create Shift for ' + $('.userId' + user_id).html() + ' at ' + dateObject
                    .toLocaleDateString('en-AU', options));
            }


            $.ajax({
                type: "GET",
                url: `{{ url('/api/roaster/create') }}`,
                headers: {
                    'X-CSRF-TOKEN': '{{ csrf_token() }}'
                },
                data: {
                    'date': date,
                    'user_id': user_id,
                    'is_template': is_template,
                    'template_id': template_id
                },
                success: function(response) {
                    
                    if (is_template == 1) {
                        var saved_templates = response.data.saved_templates;

                        $('#scheduler_hidden_user').val(user_id);
                        $('#scheduler_hidden_date').val(date);
                        $('#scheduler_template_id').val(template_id);


                        var html = ``;

                        for (var i = 0; i < saved_templates.length; i++) {
                            html += `
                                        <div class="col-auto">
                                            <div class="input-group mb-3 mt-3 ">
                                                <a  class="btn details text-dark text-lowercase" aria-current="page" style="font-weight:bold; background-color: ${saved_templates[i].color_code} !important; border-color: ${saved_templates[i].color_code} !important;" onclick="_template_assign($('#scheduler_hidden_date').val(),$('#scheduler_hidden_user').val(),${saved_templates[i].id});"     >${saved_templates[i].start_time_am_pm} - ${saved_templates[i].end_time_am_pm}  <span class="${saved_templates[i].repeat_shift == '1' ? 'mdi mdi-repeat' : '' }"><span></a>
                                                <a role="button" class="btn btn-sm details text-dark waves-effect waves-light" style="font-weight:bold; background-color: ${saved_templates[i].color_code} !important; border-color: ${saved_templates[i].color_code} !important;"  onclick="$('#scheduler_template_model').modal('hide'); _template_modal($('#scheduler_hidden_date').val(),$('#scheduler_hidden_user').val(),0,${saved_templates[i].id},'');"   ><span class="mdi mdi-pencil"></span></a>
                                             <a role="button" class="btn btn-sm text-dark waves-effect waves-light"
                                                style="font-weight:bold; background-color: ${saved_templates[i].color_code} !important; border-color: ${saved_templates[i].color_code} !important;"
                                                onclick="deleteTemplate(${saved_templates[i].id});">
                                                <span class="mdi mdi-delete"></span>
                                            </a>
                                                </div>
                                        </div>`;
                        }


                        $('.append_templates').html(html);
                        if (html == ``) {
                            $('.append_templates').html(
                                `<div class="col-12 text-center">No template saved yet</div>`);
                        }
                        $('#scheduler_template_model').modal('show');



                    } else {
                        var template = response.data.template;

                        $('#scheduler_assing_to').val(user_id);
                        $('#scheduler_h_date').val(date);
                        $('#scheduler_edit').val(edit);
                        $('#scheduler_template_id').val(template_id);

                        $('#scheduler_message').val(template ? template.shift_notes : '');
                        $('#scheduler_pick_color').val(template ? template.color_code : '#FF0000');
                        $('#scheduler_paid_break').val(template ? template.break_minutes : '0');
                        $('#scheduler_total_required_hours').val(template ? template.working_hours / 60 : '0');
                        $('#scheduler_end_time').val(template ? template.end_time : '');
                        $('#scheduler_start_time').val(template ? template.start_time : '');
                        $('#scheduler_save_shift_template').prop('checked', false);
                        $('#old_scheduler_repeat_shift').val(template ? template.repeat_shift : '');


                        if (template && template.repeat_shift == '1') {
                            $('#scheduler_repeat_shift').prop('checked', true);
                            $(".hide_every_week").removeClass("d-none");
                            $('#scheduler_repeat_every').val(template ? template.repeat_every : '1');
                            $('#scheduler_ending').val(template ? template.end_date : '');
                        } else {
                            $('#scheduler_repeat_shift').prop('checked', false);
                            $('#scheduler_ending').val(date);
                            $(".hide_every_week").addClass("d-none");

                        }



                        $('#scheduler_model').modal('show');

                    }



                },
                error: function(response) {


                    if (response.status == 500) {
                        toastr.error("Something went wrong")
                    } else {
                        toastr.error(response.responseJSON.message)
                    }
                }
            });
        }
        function deleteTemplate(templateId) {
            $('#scheduler_template_model').modal('hide');
            $('#scheduler_model').modal('hide');
            Swal.fire({
                title: 'Are you sure?',
                text: "You won't be able to revert this! Future shifts for this template will be deleted.",
                icon: 'warning',
                showCancelButton: true,
                confirmButtonColor: '#3085d6',
                cancelButtonColor: '#d33',
                confirmButtonText: 'Yes, delete it!'
            }).then((result) => {
                if (result.isConfirmed) {
                    $.ajax({
                        url: 'api/template/delete',  // API endpoint
                        type: 'POST',
                        data: {
                            template_id: templateId,
                            _token: '{{ csrf_token() }}',
                        },
                        success: function(response) {
                            if (response.success) {

                            toastr.success(response.success);

                                $(`#template-${templateId}`).remove();
                            } else {
                                toastr.error(response.error || 'Failed to delete template');
                            }
                        },
                        error: function(xhr, status, error) {
                            toastr.error('An error occurred: ' + error);
                        }
                    });
                }
            });
        }

        function _template_assign(date, user_id, template_id) {


            $.ajax({
                type: "POST",
                url: `{{ url('/api/roaster/template_assign') }}`,
                headers: {
                    'X-CSRF-TOKEN': '{{ csrf_token() }}'
                },
                data: {
                    'date': date,
                    'user_id': user_id,
                    'template_id': template_id
                },
                success: function(response) {
                    console.log(response);
                    $('#scheduler_template_model').modal('hide');

                    _onchange_date($('#scheduler_date').attr('value'));



                },
                error: function(response) {


                    if (response.status == 500) {
                        toastr.error("Something went wrong")
                    } else {
                        toastr.error(response.responseJSON.message)
                    }
                }
            });
        }

        function _save_shift_and_publish(publish) {


            var user_id = $('#scheduler_assing_to').val();
            var date = $('#scheduler_h_date').val();
            var shift_notes = $('#scheduler_message').val();
            var color_code = $('#scheduler_pick_color').val();
            var break_minutes = $('#scheduler_paid_break').val();
            var end_time = $('#scheduler_end_time').val();
            var start_time = $('#scheduler_start_time').val();
            var repeat_every = $('#scheduler_repeat_every').val();
            var end_date = $('#scheduler_ending').val();
            var template_id = $('#scheduler_template_id').val();
            var repeat_shift = $('#scheduler_repeat_shift').is(":checked") ? '1' : '0';
            var old_repeat_shift = $('#old_scheduler_repeat_shift').val();
            var save_shift = $('#scheduler_save_shift_template').is(":checked") ? '1' : '0';
            var edit = $('#scheduler_edit').val();
            var working_hours = $('#scheduler_total_required_hours').val();

            var today = new Date().toISOString().split('T')[0];
            var startDateTime = new Date(today + 'T' + start_time);
            var endDateTime = new Date(today + 'T' + end_time);

            var diffMs = endDateTime - startDateTime;
            var diffHours = diffMs / (1000 * 60 * 60);

            var workingHoursNum = parseFloat(working_hours);
            var breakMinutesNum = parseFloat(break_minutes) || 0;
            var availableHours = diffHours - (breakMinutesNum / 60);

            if (workingHoursNum > availableHours) {
                toastr.error("Total required hours cannot exceed the time between start and end time minus break.");
                return;
            }

            $.ajax({
                type: "POST",
                url: `{{ url('/api/roaster') }}`,
                headers: {
                    'X-CSRF-TOKEN': '{{ csrf_token() }}'
                },
                data: {
                    'user_id': user_id,
                    'date': date,
                    'shift_notes': shift_notes,
                    'color_code': color_code,
                    'break_minutes': break_minutes,
                    'end_time': end_time,
                    'start_time': start_time,
                    'repeat_shift': repeat_shift,
                    'old_repeat_shift': old_repeat_shift,
                    'repeat_every': repeat_every,
                    'end_date': end_date,
                    'template_id': template_id,
                    'save_shift': save_shift,
                    'publish': publish,
                    'edit': edit,
                    'working_hours': working_hours

                },
                success: function(response) {
                    console.log('Edit Validation data',response);
                    $('#scheduler_model').modal('hide');
                    $('#scheduler_to_all_shift_model').modal('hide');

                    _onchange_date($('#scheduler_date').attr('value'));





                },
                error: function(response) {

                    console.log(response.message);
                    if (response.status == 500) {
                        toastr.error("Something went wrong")
                    } else {
                        toastr.error(response.responseJSON.message)
                    }
                }
            });
        }

        function _if_repeating_shift(publish) {
            var edit = $('#scheduler_edit').val();
            var repeat_shift = $('#old_scheduler_repeat_shift').val();

            if (edit == 'edit') {
                if (repeat_shift == '1') {
                    $('#scheduler_model').modal('hide');
                    $('#scheduler_to_all_shift_model').modal('show');

                } else {
                    _save_shift_and_publish(publish);
                }


            } else {
                _save_shift_and_publish(publish);
            }
        }

        function _update_repeat_shift_and_publish(publish) {


            var user_id = $('#scheduler_assing_to').val();
            var date = $('#scheduler_h_date').val();
            var shift_notes = $('#scheduler_message').val();
            var color_code = $('#scheduler_pick_color').val();
            var break_minutes = $('#scheduler_paid_break').val();
            var end_time = $('#scheduler_end_time').val();
            var start_time = $('#scheduler_start_time').val();
            var repeat_every = $('#scheduler_repeat_every').val();
            var end_date = $('#scheduler_ending').val();
            var template_id = $('#scheduler_template_id').val();
            var repeat_shift = $('#scheduler_repeat_shift').is(":checked") ? '1' : '0';
            var old_repeat_shift = $('#old_scheduler_repeat_shift').val();
            var save_shift = $('#scheduler_save_shift_template').is(":checked") ? '1' : '0';
            var edit = $('#scheduler_edit').val();



            $.ajax({
                type: "POST",
                url: `{{ url('/api/roaster/repeat-shift-update') }}`,
                headers: {
                    'X-CSRF-TOKEN': '{{ csrf_token() }}'
                },
                data: {
                    'user_id': user_id,
                    'date': date,
                    'shift_notes': shift_notes,
                    'color_code': color_code,
                    'break_minutes': break_minutes,
                    'end_time': end_time,
                    'start_time': start_time,
                    'repeat_shift': repeat_shift,
                    'old_repeat_shift': old_repeat_shift,
                    'repeat_every': repeat_every,
                    'end_date': end_date,
                    'template_id': template_id,
                    'save_shift': save_shift,
                    'publish': publish,
                    'edit': edit

                },
                success: function(response) {

                    $('#scheduler_model').modal('hide');
                    $('#scheduler_to_all_shift_model').modal('hide');
                    _onchange_date($('#scheduler_date').attr('value'));



                },
                error: function(response) {


                    if (response.status == 500) {
                        toastr.error("Something went wrong")
                    } else {
                        toastr.error(response.responseJSON.message)
                    }
                }
            });
        }

        function _shift_delete_modal(date, user_id, template_id, repeat_shift) {
            $('#scheduler_delete_date').val(date);
            $('#scheduler_delete_user_id').val(user_id);
            $('#scheduler_delete_template_id').val(template_id);
            $('#scheduler_delete_repeat_shift').val(repeat_shift);

            if (repeat_shift == '1') {
                $('#scheduler_delete_all_shift_model').modal('show');
            } else {
                $('#scheduler_delete_shift_model').modal('show');
            }
        }

        function _shift_delete(to_all_shift) {

            var date = $('#scheduler_delete_date').val();
            var user_id = $('#scheduler_delete_user_id').val();
            var template_id = $('#scheduler_delete_template_id').val();
            var repeat_shift = $('#scheduler_delete_repeat_shift').val();



            $.ajax({
                type: "DELETE",
                url: `{{ url('/api/roaster/0') }}`,
                headers: {
                    'X-CSRF-TOKEN': '{{ csrf_token() }}'
                },
                data: {
                    'user_id': user_id,
                    'date': date,
                    'template_id': template_id,
                    'repeat_shift': repeat_shift,
                    'to_all_shift': to_all_shift
                },
                success: function(response) {
                    console.log("response data",response);
                    $('#scheduler_delete_all_shift_model').modal('hide');
                    $('#scheduler_delete_shift_model').modal('hide');
                    _onchange_date($('#scheduler_date').attr('value'));

                },
                error: function(response) {


                    if (response.status == 500) {
                        toastr.error("Something went wrong")
                    } else {
                        toastr.error(response.responseJSON.message)
                    }
                }
            });
        }


        function _publish() {
            loader(true);
            var date_list = _get_selected_dateRange();



            $.ajax({
                type: "POST",
                url: `{{ url('/api/roaster/publish') }}`,
                headers: {
                    'X-CSRF-TOKEN': '{{ csrf_token() }}'
                },
                data: {
                    'start_date': yyyy_mm_dd(date_list.start_date),
                    'end_date': yyyy_mm_dd(date_list.end_date),
                    'note': '',
                    'emp_arr': ''
                },
                success: function(response) {
                    loader(false);


                },
                error: function(response) {

                    loader(false);
                    if (response.status == 500) {
                        toastr.error("Something went wrong")
                    } else {
                        toastr.error(response.responseJSON.message)
                    }
                }
            });
        }


        function _publish_custom() {

            loader(true);

            $.ajax({
                type: "POST",
                url: "{{ url('/api/roaster/publish-custom') }}",
                headers: {
                    'X-CSRF-TOKEN': '{{ csrf_token() }}'
                },
                data: {
                    'start_date': $('#scheduler_notify_date_range_start').val(),
                    'end_date': $('#scheduler_notify_date_range_end').val(),
                    'note': $('#scheduler_notify_message').val(),
                    'recipients': $('#scheduler_notify_recipents').val()
                },
                success: function(response) {

                    loader(false);
                    $('#scheduler_notify_date_range_start').val('');
                    $('#scheduler_notify_date_range_end').val('');
                    $('#scheduler_notify_message').val('');
                    $('#scheduler_notify_recipents').val([]).trigger('change')

                    toastr.success(response.message);


                },
                error: function(response) {

                    loader(false);
                    if (response.status == 500) {
                        toastr.error("Something went wrong");
                    } else {
                        toastr.error(response.responseJSON.message);
                    }
                }
            });

        }


        function _history_modal() {
            $.ajax({
                type: "POST",
                url: "{{ url('/api/roaster/history') }}",
                headers: {
                    'X-CSRF-TOKEN': '{{ csrf_token() }}'
                },
                success: function(response) {

                    var historis = response.data.history;


                    var html = ``;

                    for (var i = 0; i < historis.length; i++) {
                        html += `<div class="history-box ${i == (historis.length-1) ? 'history-box-last' : '' }  ">
                                <div class="history-tagline">
                                ${historis[i].description}
                                </div>
                                <div class="history-timestamp">
                                ${date_formate_style(historis[i].created_at)}
                                </div>
                                <div class="history-circle ${i == 0 ? 'history-circle-active' : '' }  "></div>
                            </div>`;
                    }

                    if (html == ``) {
                        html += `<div class="text-center" >No history yet</div>`;
                    }

                    $('.history-div').html(html);




                    $('#History').modal('show');





                },
                error: function(response) {

                    if (response.status == 500) {
                        toastr.error("Something went wrong")
                    } else {
                        toastr.error(response.responseJSON.message)
                    }
                }
            });

        }


        function _leave_request_store() {

            var formData = $('#leave-request-form').serialize();
            if ($('#leave_request_id').val() == 0) {
                $.ajax({
                    url: "{{ url('/api/leave-request-store') }}",
                    type: 'POST',
                    data: formData,
                    dataType: 'json',
                    headers: {
                        'X-CSRF-TOKEN': '{{ csrf_token() }}'
                    },
                    success: function(response) {
                        $('#request_time_off').modal('hide');
                        _onchange_date($('#scheduler_date').attr('value'));

                    },
                    error: function(response) {

                        if (response.status == 500) {
                            toastr.error("Something went wrong")
                        } else {
                            toastr.error(response.responseJSON.message)
                        }
                    }
                });
            } else {

                $.ajax({
                    url: "{{ url('/api/leave-request-update') }}/" + $('#leave_request_id').val(),
                    type: 'POST',
                    data: formData,
                    dataType: 'json',
                    headers: {
                        'X-CSRF-TOKEN': '{{ csrf_token() }}'
                    },
                    success: function(response) {
                        $('#request_time_off').modal('hide');
                        _onchange_date($('#scheduler_date').attr('value'));

                    },
                    error: function(response) {

                        if (response.status == 500) {
                            toastr.error("Something went wrong")
                        } else {
                            toastr.error(response.responseJSON.message)
                        }
                    }
                });
            }

        }

        function _request_time_off_modal() {
            $('#leave_request_employee').val($('#scheduler_hidden_user').val());
            $('#leave_request_start_date').val($('#scheduler_hidden_date').val());
            $('#leave_request_end_date').val($('#scheduler_hidden_date').val());
            $('#leave_request_id').val(0);
            $('#leave_request_start_time').val("09:00");
            $('#leave_request_end_time').val("17:00");
            $('#leave_request_reason').val('');
            _leave_package_function($('#scheduler_hidden_user').val());
            $('[name="full_day"]').prop('checked', true);
            _leave_request_full_day(1);
            $('#scheduler_template_model').modal('hide');
            $('#request_time_off').modal('show');
        }

        function _leave_request_full_day(_checked) {

            if (_checked == 1) {
                $('.block_start_date').addClass('col-lg-6');
                $('.block_end_date').show();
                $('.block_end_time').hide();
                $('.block_start_time').hide();
            } else {
                $('.block_start_date').removeClass('col-lg-6');
                $('.block_end_date').hide();
                $('.block_end_time').show();
                $('.block_start_time').show();
            }


        }

        function _leave_package_function(id) {

            $.ajax({
                url: '{{ url('/api/employee-pkg') }}/' + id,
                method: 'POST',
                dataType: 'json',
                headers: {
                    'X-CSRF-TOKEN': '{{ csrf_token() }}'
                },
                success: function(response) {
            
                    if (Array.isArray(response.all_packages) && response.all_packages.length > 0) {
                        var selectElement = $('#leave_request_leave_package');
                        selectElement.empty();

                        response.all_packages.forEach(function(package) {
                            selectElement.append('<option value="' + package.id + '">' + package.title +
                                '</option>');
                        });
                    } else {
                        var selectElement = $('#leavePackageSelect');
                        selectElement.empty();
                        selectElement.append('<option value="" >Select Package</option>');
                    }
                },
                error: function(xhr, status, error) {
                    console.error(error);
                }
            });
        }

        function edit_leave(id) {
            $.ajax({
                url: '{{ url('/api/edit-leave-for-roster') }}',
                method: 'POST',
                dataType: 'json',
                headers: {
                    'X-CSRF-TOKEN': '{{ csrf_token() }}'
                },
                data: {
                    id: id
                },
                success: function(response) {

                    var data = response.data.leave_rquest;



                    $('#leave_request_employee').val(data.employee_id);
                    $('#leave_request_id').val(data.id);
                    $('#leave_request_start_date').val(data.from);
                    $('#leave_request_end_date').val(data.to);
                    $('#leave_request_start_time').val(data.start_time);
                    $('#leave_request_end_time').val(data.end_time);
                    $('#leave_request_reason').val(data.reason);
                    _leave_package_function(data.employee_id);
                    if (data.full_day == 1) {
                        $('[name="full_day"]').prop('checked', true);
                    } else {
                        $('[name="full_day"]').prop('checked', false);
                    }

                    _leave_request_full_day(data.full_day);

                    $('#request_time_off').modal('show');

                },
                error: function(xhr, status, error) {
                    console.error(error);
                }
            });

        }

        function leave_request_start_date_change(_this) {
            if (!$("#leave_request_full_day").is(":checked")) {
                $("#leave_request_end_date").val($(_this).val());
            }
        }


        function _bulk_schedule() {
            $('#bulk_scheduler_model_Label').html('Bulk Scheduler');
            $('#bulk_scheduler_start_date').val('');
            $('#bulk_scheduler_end_date').val('');
            $('#bulk_scheduler_start_time').val('');
            $('#bulk_scheduler_end_time').val('');
            $('#bulk_scheduler_message').val('');
            $('#bulk_scheduler_paid_break').val('0');
            $('#bluk_search_bar').val('');
            $('#bulk_scheduler_pick_color').val('#ff0000');
            $('#bulk_scheduler_end_date').val('');
            $(".bulk_scheduler_checkbox").prop("checked", false);
            $('#bulk_scheduler_model').modal('show');
            $('.res-btn').css('color', '#8a8d93');
            $('.res-btn').css('borderColor', '#8a8d93');
            $('.res-checkbox').attr('checked', false);
            $('#working_days_hidden').val('');
        }

        function bulk_delete_modal() {

            $('#bulk_delete_model').modal('show');
            $('.modal_title').html('Bulk Delete');
        }

        function bulk_delete() {
            loader(true);
            var users_ids = [];
            $('.bulk_delete_checkbox:checked').each(function() {
                users_ids.push($(this).val());
            });


            var bulk_delete_start_time = $('#bulk_delete_start_time').val();
            var bulk_delete_end_time = $('#bulk_delete_end_time').val();
            var bulk_delete_start_date = $('#bulk_delete_start_date').val();
            var bulk_delete_end_date = $('#bulk_delete_end_date').val();

            $.ajax({
                type: "POST",
                url: `{{ url('/api/roster/bulk-delete') }}`,
                headers: {
                    'X-CSRF-TOKEN': '{{ csrf_token() }}'
                },
                data: {
                    'users_ids': users_ids,
                    'start_time': bulk_delete_start_time,
                    'end_time': bulk_delete_end_time,
                    'start_date': bulk_delete_start_date,
                    'end_date': bulk_delete_end_date,
                },
                success: function(response) {
                    $('#bulk_delete_model').modal('hide');
                    toastr.success(response.message);
                    location.reload();
                    loader(false);
                },
                error: function(response) {
                    loader(false);
                    if (response.status == 500) {
                        toastr.error("Something went wrong")
                    } else {
                        toastr.error(response.responseJSON.message)
                    }
                }
            });
        }

        function _bulk_schedule_save() {
            loader(true);
            var users_ids = [];
            $('.bulk_scheduler_checkbox:checked').each(function() {
                users_ids.push($(this).val());
            });


            var shift_notes = $('#bulk_scheduler_message').val();
            var color_code = $('#bulk_scheduler_pick_color').val();
            var break_minutes = $('#bulk_scheduler_paid_break').val();
            var end_time = $('#bulk_scheduler_end_time').val();
            var start_time = $('#bulk_scheduler_start_time').val();
            var start_date = $('#bulk_scheduler_start_date').val();
            var end_date = $('#bulk_scheduler_end_date').val();
            var working_hours = $('#scheduler_total_required_hours_bulk').val();
            var working_days_hidden = $('#working_days_hidden').val();



            $.ajax({
                type: "POST",
                url: `{{ url('/api/roaster/bulk-schedule-save') }}`,
                headers: {
                    'X-CSRF-TOKEN': '{{ csrf_token() }}'
                },
                data: {
                    'users_ids': users_ids,
                    'shift_notes': shift_notes,
                    'color_code': color_code,
                    'break_minutes': break_minutes,
                    'end_time': end_time,
                    'start_time': start_time,
                    'end_date': end_date,
                    'start_date': start_date,
                    'working_hours': working_hours,
                    'working_days_hidden': working_days_hidden

                },
                success: function(response) {
                    console.log("bulk message",response);
                    $('#bulk_scheduler_model').modal('hide');
                    _onchange_date($('#scheduler_date').attr('value'));
                    loader(false);
                },
                error: function(response) {
                    loader(false);
                    if (response.status == 500) {
                        toastr.error("Something went wrong")
                    } else {
                        toastr.error(response.responseJSON.message)
                    }
                }
            });
        }



        $(document).ready(function() {
            $('#bluk_search_bar').on('keyup', function() {
                var searchText = $(this).val().toLowerCase();
                $('#bluk_tbody tr').each(function() {
                    var listItemText = $(this).text().toLowerCase();
                    if (listItemText.indexOf(searchText) === -1) {
                        $(this).hide();
                    } else {
                        $(this).show();
                    }
                });
            });


            $('.bulk_scheduler_checkbox_all').change(function() {
                $('.bulk_scheduler_checkbox').prop('checked', $(this).prop('checked'));
            });

            $('.bulk_scheduler_checkbox').change(function() {
                if (false == $(this).prop("checked")) {
                    $('.bulk_scheduler_checkbox_all').prop('checked', false);
                }
                if ($('.bulk_scheduler_checkbox:checked').length == $('.bulk_scheduler_checkbox').length) {
                    $('.bulk_scheduler_checkbox_all').prop('checked', true);
                }
            });


            $('#bulk_delete_search_bar').on('keyup', function() {
                var searchText = $(this).val().toLowerCase();
                $('#bulk_delete_tbody tr').each(function() {
                    var listItemText = $(this).text().toLowerCase();
                    if (listItemText.indexOf(searchText) === -1) {
                        $(this).hide();
                    } else {
                        $(this).show();
                    }
                });
            });

            $('.bulk_delete_checkbox_all').change(function() {
                $('.bulk_delete_checkbox').prop('checked', $(this).prop('checked'));
            });

            $('.bulk_delete_checkbox').change(function() {
                if (false == $(this).prop("checked")) {
                    $('.bulk_delete_checkbox_all').prop('checked', false);
                }
                if ($('.bulk_delete_checkbox:checked').length == $('.bulk_delete_checkbox').length) {
                    $('.bulk_delete_checkbox_all').prop('checked', true);
                }
            });
        });


        $(document).ready(function() {
            const workingDays = document.querySelectorAll('.working-days');


            workingDays.forEach(checkbox => {

                checkbox.addEventListener('change', function() {

                    onChangeWorkingDays(workingDays);
                });

            });

        });


        function onChangeWorkingDays(workingDays) {
            var concatenatedValues = "";

            workingDays.forEach(checkbox => {
                const label = checkbox.nextElementSibling;
                if (checkbox.checked) {
                    label.style.color = '#15A7F5';
                    label.style.borderColor = '#15A7F5';
                    concatenatedValues += checkbox.value + ",";
                } else {
                    label.style.color = '#8a8d93';
                    label.style.borderColor = '#8a8d93';
                }
            });

            $('#working_days_hidden').val(concatenatedValues.slice(0, -1));

        }
    </script>



    <style>
        .dropdown-menu {
            width: 200px;
        }



        @media only screen and (min-width: 320px)and (max-width: 568px) {
            .dropdown-menu {
                width: 285px;
                margin-left: -17px !important;
            }


        }

        @media only screen and (min-width: 375px)and (max-width: 667px) {
            .dropdown-menu {
                width: 236px;
                margin-left: -20px !important;
            }


        }
    </style>
@endsection