@extends('includes/layout')
@section('main-page-content')
    <div class="container-xxl flex-grow-1 container-p-y">
        <!-- Overtime Entry Card -->
        <div class="card mb-4">
            <div class="border-bottom p-3">
                <div class="h4 pb-0 mb-0">Add Overtime Entry</div>
            </div>
            <form id="overtime-form">
                <div class="row p-3">
                    <div class="col-6 mb-3">
                        <label>Employee</label>
                        <select class="form-select" name="employee_id" aria-label="Default select example">
                            <option value="" selected disabled>Select Employee</option>
                            @foreach ($get_employes as $get_employe)
                                @if ($get_employe->EmpPersonalDetails)
                                    <option value="{{ $get_employe->id }}">
                                        {{ $get_employe->EmpPersonalDetails->first_name }}
                                        {{ $get_employe->EmpPersonalDetails->middle_name }}
                                        {{ $get_employe->EmpPersonalDetails->last_name }}
                                    </option>
                                @endif
                            @endforeach
                        </select>
                    </div>
                    <div class="col-6 mb-3">
                        <label>Site</label>
                        <select class="form-select" name="site_id" aria-label="Default select example">
                            <option value="" selected disabled>Select Site</option>
                            @foreach ($sites as $site)
                                <option value="{{ $site->id }}">{{ $site->title }}</option>
                            @endforeach
                        </select>
                    </div>
                    <div class="col-6 mb-3">
                        <label>Check In</label>
                        <input type="datetime-local" name="check_in" class="form-control" value="">
                    </div>
                    <div class="col-6 mb-3">
                        <label>Check Out</label>
                        <input type="datetime-local" name="check_out" class="form-control" value="">
                    </div>
                    <div class="col-12 col-md-6 mb-3">
                        <label>Date</label>
                        <input type="date" class="form-control" name="date" value="">
                    </div>
                    <div class="col-12 col-md-6 mb-3">
                        <label>Status</label>
                        <select class="form-select" name="status">
                            <option value="" selected disabled>Select Status</option>
                            <option value="1">Pending</option>
                            <option value="2">Approved</option>
                            <option value="3">Reject</option>
                        </select>
                    </div>
                    <div class="col-12 col-md-12 mb-3">
                        <label>Description</label>
                        <textarea class="form-control" name="description"  rows="4"></textarea>
                    </div>
                </div>
                <div class="border-top p-3 d-flex justify-content-end">
                    <button type="button" class="btn btn-outline-light text-dark me-2"
                        onclick="window.location='{{ url('/') }}/overtimes'">CANCEL</button>
                    <button type="button" class="btn btn-primary waves-effect" onclick="overtime_store();">SAVE</button>
                </div>
            </form>
        </div>
    </div>
@endsection

@section('css-js')
    <script>
        function overtime_store() {
            var formData = $('#overtime-form').serialize();

            $.ajax({
                url: "{{ url('/overtimes') }}",
                type: 'POST',
                data: formData,
                dataType: 'json',
                headers: {
                    'X-CSRF-TOKEN': '{{ csrf_token() }}'
                },
                success: function(response) {
                    window.location.href = "{{ url('/') }}/overtimes";
                },
                error: function(response) {
                    if (response.status == 500) {
                        toastr.error("Something went wrong");
                    } else {
                        toastr.error(response.responseJSON.message);
                    }
                }
            });
        }
    </script>
@endsection
