<?php

use Illuminate\Http\Request;
use Illuminate\Support\Facades\Auth;
use Illuminate\Support\Facades\Route;
use App\Http\Controllers\AuthController;
use App\Http\Controllers\SiteController;
use App\Http\Controllers\LeaveController;
use App\Http\Controllers\PayRollController;
use App\Http\Controllers\WarningController;
use App\Http\Controllers\EmployeeController;
use App\Http\Controllers\OvertimeController;
use App\Http\Controllers\LeaveTypeController;
use App\Http\Controllers\AttendanceController;
use App\Http\Controllers\LeavePackageController;
use App\Http\Controllers\LeaveRequestController;

// use App\Http\Controllers\NotificationController;
// use App\Http\Controllers\IncidentReportController;
use App\Http\Controllers\RosterTemplateController;
use App\Http\Controllers\EmployeeOnboardingController;
use App\Http\Controllers\UserCommentManagementController  ;
use App\Http\Controllers\ExternalEmployeeOnboardingController;


/*
|--------------------------------------------------------------------------
| API Routes
|--------------------------------------------------------------------------
|
| Here is where you can register API routes for your application. These
| routes are loaded by the RouteServiceProvider within a group which
| is assigned the "api" middleware group. Enjoy building your API!
|
*/

Route::get('/roster-clean-api/{id}', [RosterTemplateController::class, 'rosterDataCleanApi']);
// loop badge and limit 
Route::get('/roster-clean-api-loop/{limit}/{badge}', [RosterTemplateController::class, 'rosterDataCleanApiloop']);




Route::get('/assignShift', [ExternalEmployeeOnboardingController::class, 'assignShift']);
Route::post('/external-employee-onboarding-edit', [ExternalEmployeeOnboardingController::class, 'externalEmployeeOnboardingEdit']);
Route::post('/external-employee-onboarding-store', [ExternalEmployeeOnboardingController::class, 'externalEmployeeOnboardingsStore']);
Route::post('/delete-medical-attachment', [ExternalEmployeeOnboardingController::class, 'deleteMedicalAttachment']);



Route::middleware('auth:sanctum')->group(function () {
    Route::post('/logout', [AuthController::class, 'logout']);

    Route::post('/emp-company-details-edit', [EmployeeOnboardingController::class, 'empCompanyDetailsEdit']);
    Route::post('/emp-company-details-store', [EmployeeOnboardingController::class, 'empCompanyDetailsStore']);

    Route::post('/emp-personal-details-edit', [EmployeeOnboardingController::class, 'empPersonalDetailsEdit']);
    Route::post('/emp-personal-details-store', [EmployeeOnboardingController::class, 'empPersonalDetailsStore']);

    Route::post('/emp-documents-edit', [EmployeeOnboardingController::class, 'empDocumentsEdit']);
    Route::post('/emp-documents-store', [EmployeeOnboardingController::class, 'empDocumentsStore']);
    Route::post('/emp-documents-delete', [EmployeeOnboardingController::class, 'empDocumentsDelete']);
    Route::post('/emp-documents-count', [EmployeeOnboardingController::class, 'empDocumentsCount']);

    Route::post('/emp-emergency-contacts-edit', [EmployeeOnboardingController::class, 'empEmergencyContactsEdit']);
    Route::post('/emp-emergency-contacts-store', [EmployeeOnboardingController::class, 'empEmergencyContactsStore']);
    Route::post('/emp-emergency-contacts-delete', [EmployeeOnboardingController::class, 'empEmergencyContactsDelete']);
    Route::post('/emp-emergency-contacts-count', [EmployeeOnboardingController::class, 'empEmergencyContactsCount']);
    Route::post('/emp/download', [EmployeeController::class, 'empDownload']);
    Route::post('/emp-access-edit', [EmployeeOnboardingController::class, 'empAccessEdit']);
    Route::post('/emp-access-store', [EmployeeOnboardingController::class, 'empAccessStore']);

    Route::put('/employee/{id}/update-status', [EmployeeController::class, 'updateStatus']);
    Route::resource('/employee', EmployeeController::class);

    Route::post('/profile', [EmployeeController::class, 'profile']);
    Route::post('/approved_invite/{id}', [EmployeeOnboardingController::class, 'approvedInvite']);
    Route::post('/send-credentials', [EmployeeOnboardingController::class, 'sendCredentials']);

    Route::post('/rejected', [EmployeeOnboardingController::class, 'rejected']);
    Route::post('/profile-submit-history', [EmployeeOnboardingController::class, 'profileSubmitHistory']);

    Route::post('/site-store', [SiteController::class, 'store']);
    Route::get('/sites-get', [SiteController::class, 'index']);
    Route::post('/site-delete/{id}', [SiteController::class, 'destroy']);
    Route::post('/site-update/{id}', [SiteController::class, 'update']);
    Route::put('/site/{id}/update-status', [SiteController::class, 'updateStatus']);
    //Cron job on 1st date
    Route::post('/generate/selected-slips', [PayRollController::class, 'generateReceiptsForAllEmployees']);



    Route::get('/attendance-get', [AttendanceController::class, 'index']);
    Route::get('/get-attendance', [AttendanceController::class, 'calculateHours']);
    Route::get('overtimes-get', [OvertimeController::class, 'getOvertimes']);
    Route::post('/roaster/template_assign', [RosterTemplateController::class, 'templateAssign']);
    Route::post('/roaster/history', [RosterTemplateController::class, 'getHistory']);
    Route::post('/roaster/repeat-shift-update', [RosterTemplateController::class, 'repeatShiftUpdate']);
    Route::post('/roaster/publish', [RosterTemplateController::class, 'publish']);
    Route::post('/roaster/publish-custom', [RosterTemplateController::class, 'publishCustom']);
    Route::post('/roaster/bulk-schedule-save', [RosterTemplateController::class, 'bulkScheduleSave']);
    Route::resource('/roaster', RosterTemplateController::class);
    Route::resource('public-holiday', LeaveController::class);
    Route::get('/holiday-desc/{id}', [LeaveController::class, 'holidaydesc']);
    Route::post('/roster-api', [RosterTemplateController::class, 'rosterApi']);
    Route::post('/roster/bulk-delete', [RosterTemplateController::class, 'deleteTemplate']);
    Route::post('/template/delete', [RosterTemplateController::class, 'templateDelete']); // delete roster template
 
    Route::resource('leave-type', LeaveTypeController::class);
    Route::get('/leave-type-desc/{id}', [LeaveTypeController::class, 'leavetypedesc']);

    Route::post('/leavepackage-store', [LeavePackageController::class, 'store']);
    Route::get('/leavepackage-get', [LeavePackageController::class, 'index']);
    Route::post('/leavepackage-delete/{id}', [LeavePackageController::class, 'destroy']);
    Route::post('/leavepackage-update/{id}', [LeavePackageController::class, 'update']);

    Route::post('/leave-request-store', [LeaveRequestController::class, 'store']);
    Route::get('/leave-request-get', [LeaveRequestController::class, 'index']);
    Route::post('/leave-request-delete/{id}', [LeaveRequestController::class, 'destroy']);
    Route::post('/leave-request-update/{id}', [LeaveRequestController::class, 'update']);
    Route::put('/leave-request/{id}/update-status', [LeaveRequestController::class, 'updateStatus']);
    Route::put('/leave-request/{id}/custom-approve', [LeaveRequestController::class, 'customApprove']);
    Route::get('/leave-request-reason/{id}', [LeaveRequestController::class, 'leavereason']);

    Route::post('/remaining-leave', [LeaveRequestController::class, 'remainingleave']);
    Route::post('/leave-count/{id}', [LeaveRequestController::class, 'leave_count']);
    Route::get('/leave-pkg', [LeaveRequestController::class, 'leave_pkg']);

    Route::get('/upcoming-leave', [LeaveRequestController::class, 'upcoming_leave']);
    Route::get('/approved-leave', [LeaveRequestController::class, 'approved_leave']);
    Route::get('/rejected-leave', [LeaveRequestController::class, 'rejected_leave']);
    Route::get('/exipired-leave', [LeaveRequestController::class, 'exipired_leave']);

    ////////////leave Api//////////////////
    Route::post('/applie-leave-request', [LeaveRequestController::class, 'applie_leave_request']);
    Route::post('/leave-request-api', [LeaveRequestController::class, 'leave_request_api']);
    Route::get('/leave-request-get-api', [LeaveRequestController::class, 'leave_request_get_api']);
    Route::get('/leave-request-edit-api', [LeaveRequestController::class, 'leave_request_edit_api']);
    Route::post('/leave-request-update-api/{id}', [LeaveRequestController::class, 'leave_request_update_api']);
    Route::post('/destroy-api/{id}', [LeaveRequestController::class, 'destroy_api']);
    Route::get('/get-leave-request', [LeaveRequestController::class, 'get_leave_request']);
    Route::get('/employee-leave-pkg', [LeaveRequestController::class, 'employee_leave_pkg']);
    Route::post('/checkin-history', [AttendanceController::class, 'checkin_history']);
    ///////////leave Api//////////////////
    Route::resource('Warnings', WarningController::class);
    Route::post('/get-Warnings', [WarningController::class, 'getUserWarning']);
    Route::post('/update-Warnings', [WarningController::class, 'UpdateUserWarning']);


    Route::resource('comment-management', UserCommentManagementController::class);
    Route::post('/get-comment-management', [UserCommentManagementController::class, 'getUserComment']);
    Route::post('/update-comment-management', [UserCommentManagementController::class, 'UpdateUserComment']);

    //////////////////// user 
    Route::post('/checkin', [AttendanceController::class, '_check_in']);

    Route::post('/attendance/download', [AttendanceController::class, 'attendanceDownload']);
    Route::post('/checkout', [AttendanceController::class, '_check_out']);
    Route::get('/last-checkin', [AttendanceController::class, 'last_check_in']);

    Route::post('/breakin', [AttendanceController::class, 'break_in']);
    Route::post('/breakout', [AttendanceController::class, 'break_out']);
    Route::get('/last-breakin', [AttendanceController::class, 'last_break_in']);

    Route::post('/employee-pkg/{id}', [LeaveRequestController::class, 'employee_pkg']);
    Route::post('/edit-leave-for-roster', [LeaveRequestController::class, 'edit_leave_for_roster']);

    // get Attendance
    Route::post('/attendance', [AttendanceController::class, 'single_employee_attendance']);
    Route::post('/employee/fines', [PayRollController::class, 'getEmployeeFines']);
    Route::post('/employee/leaves', [LeaveRequestController::class, 'viewLeaves']);
    Route::get('/active_employees_list', [EmployeeController::class, 'active_employees_list']);
    Route::get('/public/holidays', [LeaveController::class, 'list_holidays']);
    Route::post('/leave-request-approve-multiple', [LeaveRequestController::class, 'approveMultiple']);

    // overtime

    Route::post('/apply-overtime', [OvertimeController::class, 'applyOvertime'])->name('apply.overtime');
    Route::post('/overtimes-approve-multiple', [OvertimeController::class, 'approveMultiple']);
    Route::get('/site-list',[SiteController::class, 'site_list']);
    
});

Route::post('/update-password', [AuthController::class, 'updatepassword'])->name('updatepassword');
Route::post('/first-rest-password-logic', [AuthController::class, 'firstRestPasswordLogic'])->name('firstRestPasswordLogic');

Route::post('/login', [AuthController::class, 'login']);
Route::post('/verify-2fa', [AuthController::class, 'verifyTwoFactorAuth']);
Route::post('/forget-password-send-otp', [AuthController::class, 'forgetPasswordSendOTP'])->name('forgetPasswordSendOTP');
Route::post('/forget-password-receive-otp', [AuthController::class, 'forgetPasswordReceiveOTP'])->name('forgetPasswordReceiveOTP');

Route::post('/update-profile-password', [AuthController::class, 'updateprofilePassword'])->name('updateprofilePassword');
Route::post('/resend-OTP', [AuthController::class, 'resendOTP'])->name('resendOTP');

Route::post('/resend-OTP-Api', [AuthController::class, 'resendOTP_api'])->name('resendOTP_api');

Route::post('/forget-Password-Match-OTP', [AuthController::class, 'forgetPasswordMatchOTP'])->name('forgetPasswordMatchOTP');
// ====================== Incident Report ========================
// Route::get('/incident-reports', [IncidentReportController::class,  'index']);
// Route::delete('/incident-reports/{id}', [IncidentReportController::class,  'destroy']);
// Route::post('/incident-report-edit-step1', [IncidentReportController::class,  'editStep1']);
// Route::post('/incident-report-store-step1', [IncidentReportController::class, 'storeStep1']);
// Route::post('/incident-report-edit-step2', [IncidentReportController::class,  'editStep2']);
// Route::post('/incident-report-store-step2', [IncidentReportController::class, 'storeStep2']);
// Route::post('/incident-report-edit-step3', [IncidentReportController::class,  'editStep3']);
// Route::post('/incident-report-store-step3', [IncidentReportController::class, 'storeStep3']);
// Route::post('/incident-report-edit-step4', [IncidentReportController::class,  'editStep4']);
// Route::post('/incident-report-store-step4', [IncidentReportController::class, 'storeStep4']);
// Route::post('/incident-report-listing-step4', [IncidentReportController::class,  'listingStep4']);
// Route::post('/incident-report-delete-step4', [IncidentReportController::class, 'deleteStep4']);
// Route::post('/incident-report-edit-step5', [IncidentReportController::class,  'editStep5']);
// Route::post('/incident-report-store-step5', [IncidentReportController::class, 'storeStep5']);
// Route::post('/incident-report-edit-step6', [IncidentReportController::class,  'editStep6']);
// Route::post('/incident-report-store-step6', [IncidentReportController::class, 'storeStep6']);
// Route::post('/incident-report-edit-step7', [IncidentReportController::class,  'editStep7']);
// Route::post('/incident-report-store-step7', [IncidentReportController::class, 'storeStep7']);
// Route::post('/incident-report-edit-step8', [IncidentReportController::class,  'editStep8']);
// Route::post('/incident-report-store-step8', [IncidentReportController::class, 'storeStep8']);
// Route::post('/incident-report-edit-step9', [IncidentReportController::class,  'editStep9']);
// Route::post('/incident-report-store-step9', [IncidentReportController::class, 'storeStep9']);
// Route::post('/incident-report-store-step10', [IncidentReportController::class, 'storeStep10']);

// Route::post('/incident-report-check-sign-off', [IncidentReportController::class, 'checkSignOffApi']);
// Route::post('/incident-report-images-list', [IncidentReportController::class, 'getImages']);



/////////////////// CRON JOB ///////////////////////
Route::get('auto-checkout', [AttendanceController::class, 'autoCheckout']);
Route::get('/check-token', function (Request $req) {
    $token = $req->token;
    $user = Auth::guard('sanctum')->setToken($token)->user();
    return response()->json($user);
});
Route::post('/calculate-update-working-hours', [AttendanceController::class, 'calculateAndUpdateWorkingHours']);